// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: framedlg.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// frame menu dialogs
// class FrameMarginDialog
// class FillPatternDialog 
// class SplitFrameDialog
// class RemoveFrameDialog
// class InsertFrameDialog
// class CombineFrameDialog
// class AlignFrameDialog

#ifndef FRAMEDLG_H
#define FRAMEDLB_H

#include "dlg.h"
#include "twonumdl.h"
#include "fillobjc.h"

// ------------------------------------------------------------
// class FrameMarginDialog

class FrameMarginDialog
  : public NoKanjiModalDialog
{
  // margin
  word m[4];
  
public:
  // constructor
  FrameMarginDialog(Iunit top, Iunit bot, Iunit lft, Iunit rgh);
    
  // window proc.
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // accessor
  uword GetTop()
  {
    return mm0_to_iu(m[0]);
  }
  
  uword GetBottom()
  {
    return mm0_to_iu(m[1]);
  }
  
  uword GetRight()
  {
    return mm0_to_iu(m[2]);
  }
  
  uword GetLeft()
  {
    return mm0_to_iu(m[3]);
  }
};

// ------------------------------------------------------------
// class FillPatternDialog 

class FillPatternDialog 
  : public NoKanjiModalDialog
{
  static struct _pattmsg
  {
    FillObject::FillType patt;
    int msg;
  }
  pattmsg[];
  
  // current pattern
  FillObject::FillType curpat;
  
public:
  // constructor
  FillPatternDialog(FillObject::FillType def_type);
  
  // window proc.
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // get value
  FillObject::FillType GetValue() 
  {
    return curpat;
  }
};

// ------------------------------------------------------------
// class SplitFrameDialog

class SplitFrameDialog
  : public TwoNumDialog
{
private:
  // make table flag
  bool make_table;
  
public:
  // constructor
  SplitFrameDialog();
  
  // constructor for make table
  SplitFrameDialog(bool dummy);
  
protected:
  // value check
  int CheckValue(int, int);
  
  LRESULT_T WndProc(MSG_T mes, WPARAM_T wParam, LPARAM_T lParam);
};

// ------------------------------------------------------------
// class RemoveFrameDialog

class RemoveFrameDialog
  : public NoKanjiModalDialog
{
  // settings
  bool remove_line;
  bool expand_size;
  
  // condition
  bool posible_remove_line;
  bool posible_remove_column;
  bool is_table;
  
private:
  // initialize dialog
  void InitDialog();
  
public:
  
  // constructor
  RemoveFrameDialog(bool posible_remove_line,
		     bool posible_remove_column,
		     bool is_table);
  // window proc
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
  bool RemoveLineP()
  {
    return remove_line;
  }
  
  bool ExpandSizeP()
  {
    return expand_size;
  }
};

// ------------------------------------------------------------
// class InsertFrameDialog

class InsertFrameDialog
  : public NoKanjiModalDialog
{
  // condition
  bool posible_insert_line;
  bool posible_insert_column;
  bool is_table;
  
  // settings
  enum insert_dir
  { 
    insert_up,
    insert_down,
    insert_left,
    insert_right,
  };
  
  insert_dir dir;
  static bool expand_size;
  static uword copy_num;
  
public:
  InsertFrameDialog(bool posible_insert_line,
		     bool posible_insert_column,
		     bool is_table);
  
  bool PostInsertP()
  {
    return(dir == insert_down) || (dir == insert_right);
  }
  
  bool ExpandSizeP()
  {
    return expand_size;
  }
  
  bool InsertLineP()
  {
    return(dir == insert_up) || (dir == insert_down);
  }
  
  uword GetCopyNum()
  {
    return copy_num;
  }
  
protected:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  void InitDialog();
};

// ------------------------------------------------------------
// class CombineFrameDialog

class CombineFrameDialog
  : public NoKanjiModalDialog
{
  bool combine_vertical;
  bool combine_horizontal;
  
public:
  // constructor
  CombineFrameDialog();
  
  bool CombineVerticalP()
  {
    return combine_vertical;
  }
  
  bool CombineHorizontalP()
  {
    return combine_horizontal;
  }
  
protected:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

// ------------------------------------------------------------
// class AlignFrameDialog

class AlignFrameDialog
  : public CombineFrameDialog
{
public:
  // constructor
  AlignFrameDialog();
  
  bool AlignVerticalP()
  {
    return CombineVerticalP();
  }
  
  bool AlignHorizontalP()
  {
    return CombineHorizontalP();
  }
};

// ------------------------------------------------------------
// class MakeTableDialog

class MakeTableDialog
  : public NoKanjiModalDialog
{
  enum
  {
    default_h_div = 1,
    default_v_div = 1,
    default_h_size = 100, // mm0
    default_v_size = 100, // mm0
  };
  
  uword h_div;
  uword v_div;
  Iunit h_size;
  Iunit v_size;
  
protected:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
public:
  MakeTableDialog();
  uword GetHDiv()
  {
    return h_div;
  }
  uword GetVDiv()
  {
    return v_div;
  }
  Iunit GetHSize()
  {
    return h_size;
  }
  Iunit GetVSize()
  {
    return v_size;
  }
};

#endif /* FRAMEDLB_H */
