// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frameins.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class FrameInstance
// eCX^XƂ̃t[

#include "pword.h"
#include "docconte.h"
#include "frametem.h"
#include "frameins.h"
#include "textflow.h"
#include "pagemap.h"
#include "layoutte.h"
#include "layoutin.h"
#include "line.h"
#include "bufnew.h"
#include "docprese.h"
#include "rect.h"
#include "view.h"
#ifndef NDEBUG
#include "ddisplay.h"
#endif

// common initializer
void
FrameInstance::InitializeForConstructor(FrameTemplate* ft,
					 LayoutInstance* li)
{
  this->layout_instance = li;
  this->ft = ft;
  this->next_lfi = 0;
  this->broken_pipe = False;
  this->prev_tfi = NULL;
  this->next_tfi = NULL;
  this->lines = NULL;
  this->first_bp = NULL;
  this->next_bp = NULL;
  this->next_shadow_bp = NULL;
  this->format_needed_p = True;
  this->prev_end_of_text_p = False;
  this->end_of_text_p = False;
  this->primary_background = False;
  this->secondary_background = False;
  
  // manage lfi link
  if (li->GetFirstFrame() == 0) 
  {
    li->SetFirstFrame(this);
    li->SetLastFrame(this);
  }
  else 
  {
    FrameInstance* prev = li->GetLastFrame();
    li->SetLastFrame(this);
    prev->next_lfi = this;
  }
}

// constructor, after insertion
FrameInstance::FrameInstance(FrameTemplate* ft,
			      FrameInstance* prev,
			      LayoutInstance* li)
{
  this->InitializeForConstructor(ft, li);
  // link text-flow pipe
  if (prev != 0) 
  {
    prev_tfi = prev;
    next_tfi = prev->next_tfi;
    prev->next_tfi = this;
    if (next_tfi != 0) 
    {
      next_tfi->prev_tfi = this;
    }
  }
  this->ReportTextFlow();
}

// constructor, befor insertion
FrameInstance::FrameInstance(FrameTemplate* ft, 
			      LayoutInstance* li, 
			      FrameInstance* next)
{
  this->InitializeForConstructor(ft, li);
  // link text-flow pipe
  if (next != 0) 
  {
    next_tfi = next;
    prev_tfi = next->prev_tfi;
    next->prev_tfi = this;
    if (prev_tfi != 0) 
    {
      prev_tfi->next_tfi = this;
    }
  }
  this->ReportTextFlow();
}

// destructor
FrameInstance::~FrameInstance()
{
  this->DeleteForFormatter();
  
  TextFlow* tf = layout_instance->GetAssignedTextFlow(this);
  tf->ReportDeadFrame(this);
  
  // broken pipe check.
  if (broken_pipe) 
  {
    // This frame-instance is alredy unlinked from 
    // the text-flow pipe.
    return;
  }
  
  // unlink from the text-flow pipe
  if (prev_tfi != 0) 
  {
    prev_tfi->next_tfi = next_tfi;
  }
  if (next_tfi != 0) 
  {
    next_tfi->prev_tfi = prev_tfi;
  }
  
  // unlink from the 'next_lfi' frame-instance management link
  FrameInstance* fi = layout_instance->GetFirstFrame();
  if (fi == this) 
  {
    layout_instance->SetFirstFrame(next_lfi);
    if (next_lfi == 0) 
    {
      layout_instance->SetLastFrame(0);
    }
  }
  else 
  {
    while (fi != 0) 
    {
      if (fi->next_lfi == this) 
      {
	fi->next_lfi = next_lfi;
	if (next_lfi == 0) 
	{
	  layout_instance->SetLastFrame(fi);
	}
	break;
      }
      fi = fi->next_lfi;
    }
  }
}

// rebind text-flow link
void 
FrameInstance::RebindLink(FrameInstance* next)
{
  //
  //  unlink "next" 
  //
  
  // prev
  if (next->prev_tfi != 0) 
  {
    next->prev_tfi->next_tfi = next->next_tfi;
  }
  // next
  if (next->next_tfi != 0) 
  {
    next->next_tfi->prev_tfi = next->prev_tfi;
  }
  
  //
  // link "next" at rebind position 
  //
  next->next_tfi = next_tfi;
  if (next_tfi != 0) 
  {
    next_tfi->prev_tfi = next;
  }
  next_tfi = next;
  next->prev_tfi = this;
}

// which flow now assigned
TextFlow* 
FrameInstance::GetAssignedTextFlow()
{
  return layout_instance->GetAssignedTextFlow(this);
}

// report last frame
void 
FrameInstance::ReportLast()
{
  FrameInstance* fi = GetNextTextFrame();
  if (fi != 0) 
  {
    LayoutInstance::CheckUnused(fi->layout_instance);
  }
}

// get prev
FrameInstance* 
FrameInstance::GetPrevTextFrame()
{
  if (prev_tfi != 0) 
  {
    return prev_tfi;
  }
  if (this->GetTemplate() ->GetLayoutTemplate() ->GetKind()
      != LayoutTemplate::RegularTemplate)
  {
    return(NULL);
  }
  TextFlow* tf = layout_instance->GetAssignedTextFlow(this);
  LayoutInstance* li = layout_instance->GetPrevPageMapLayout();
  if (li != 0) 
  {
    return li->GetExitFI(tf);
  }
  else 
  {
    PageMap* pm = layout_instance->GetPageMap();
    while ((pm = pm->GetPrevPageMap()) != 0) 
    {
      FrameInstance* fi = pm->GetLastTextFlowFrame(tf);
      if (fi != 0) 
      {
	// find
	return fi;
      }
    }
    // can't find
    return 0;
  }
}

// get next
FrameInstance* 
FrameInstance::GetNextTextFrame()
{
  if (next_tfi != 0) 
  {
    return next_tfi;
  }
  if (this->GetTemplate() ->GetLayoutTemplate() ->GetKind()
      != LayoutTemplate::RegularTemplate)
  {
    return(NULL);
  }
  TextFlow* tf = layout_instance->GetAssignedTextFlow(this);
  LayoutInstance* li = layout_instance->GetNextPageMapLayout();
  if (li != 0) 
  {
    return li->GetGateFI(tf);
  }
  else 
  {
    PageMap* pm = layout_instance->GetPageMap();
    while ((pm = pm->GetNextPageMap()) != 0) 
    {
      FrameInstance* fi = pm->GetFirstTextFlowFrame(tf);
      if (fi != 0) 
      {
	// find
	return fi;
      }
    }
    // can't find
    return 0;
  }
}

FrameInstance* 
FrameInstance::EnsureNextTFI()
{
  FrameInstance* next = this->GetNextTextFrame();
  if (next == NULL)
  {
    if (this->GetTemplate() ->GetLayoutTemplate() ->GetKind()
	!= LayoutTemplate::RegularTemplate)
    {
      assert(this->GetFirstBP());
      this->GetFirstBP() ->GetTextFlow() ->SetOverflowP(True);
    }
    else
    {
      // There are no next frame-instance.
      // Now the time to create another page.
      PageMap* pm = this->layout_instance->GetPageMap();
      LayoutInstance* li = pm->GenerateNPage(1);
      next = this->GetNextTextFrame();
      li->Invalidate();
      if ((pm = pm->GetNextPageMap()) != 0)
      {
	pm->GetDocumentContent() ->InvalidateToEnd(pm);
      }
    }
  }
  return(next);
}

// check page aligned frame
bool 
FrameInstance::PageAlignedP()
{
  return(layout_instance->GetLayoutTemplate()->GetGateNumber(ft) != 0) ? 
  True :	// It's the gate frame-template
  False;	// It isn't the gate frame-template
}

Iunit 
FrameInstance::GetTopMargin()
{
  return ft->GetTopMargin();
}

Iunit 
FrameInstance::GetBottomMargin()
{
  return ft->GetBottomMargin();
}

Iunit 
FrameInstance::GetLeftMargin()
{
  return ft->GetLeftMargin();
}

Iunit 
FrameInstance::GetRightMargin()
{
  return ft->GetRightMargin();
}

void
FrameInstance::get_lpoint(Lpoint* lp)
{
  Ipoint ip[1];
  FrameTemplate* t = this->GetTemplate();
  SET_POINT(ip, t->GetCX(), t->GetCY());
  this->GetLayout() ->ipoint_to_lpoint(ip, lp);
}

void
FrameInstance::get_irect(Irect* r)
{
  FrameTemplate* t = this->GetTemplate();
  SET_RECT(r,
	    t->GetCX(),
	    t->GetCY(),
	    t->GetCX() + t->GetWidth(), t->GetCY() + t->GetHeight());
}

void
FrameInstance::get_lrect(Lrect* lr)
{
  Irect irect[1];
  this->get_irect(irect);
  this->GetLayout() ->irect_to_lrect(irect, lr);
}

void
FrameInstance::get_drawing_lrect(Lrect* r)
{
  Irect irect[1];
  this->get_drawing_irect(irect);
  this->GetLayout() ->irect_to_lrect(irect, r);
}

bool 
FrameInstance::EraseableFrameP()
{
  return(!format_needed_p) && end_of_text_p && EmptyLinesP();
}
