// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frameobj.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class FrameObject
// t[̊{NXAeLXgAhԂA}`Ȃǂ́ÃNX
// p

#include "pword.h"
#include "frameown.h"
#include "fission.h"

SuperFrameObject::SuperFrameObject()
{
  this->prev = this->next = this;
}

SuperFrameObject::SuperFrameObject(SuperFrameObject* next)
{
  next->prev = (this->prev = (this->next = next)->prev)->next = this;
}

SuperFrameObject::~SuperFrameObject()
{
  SuperFrameObject* next = this->next;
  (next->prev = this->prev)->next = next;
}

// constructor
FrameObject::FrameObject(CrossPoint* cp)
  : margin(0, 0, 0, 0)
, SuperFrameObject(cp->GetFissionFrame()
		    ->GetFrameOwner() ->GetNilFrameObject())
{
  FrameObject::cp = cp;
  this->UpdateInternalRect();
  cp->CreateFrameObject(this);
  SetFrameSelected(False);
  SetFrameMarginExchangeP(False);
}

// destructor
FrameObject::~FrameObject()
{
  cp->ResetFrameObject();
}

// set flow
bool 
FrameObject::SetFlow(FrameObject*)
{
  return True;
}

// set empty flow
bool 
FrameObject::SetEmptyFlow()
{
  return True;
}

// new flow
bool 
FrameObject::NewFlow()
{
  return True;
}

// update
void 
FrameObject::UpdateInternalRect()
{
  Fission* top_x;
  Fission* bot_x;
  Fission* top_y;
  Fission* bot_y;
  cp->GetCellFission(top_y, bot_y, top_x, bot_x);
  SET_RECT(&this->external_irect,
	    top_x->GetPoint(),
	    top_y->GetPoint(), bot_x->GetPoint(), bot_y->GetPoint());
  internal = cp->GetInternalRect();
}

Irect
FrameObject::GetInternalIrect()
{
  Irect r;
  SET_RECT(&r,
	    this->GetX1(),
	    this->GetY1(), this->GetX2() + 1, this->GetY2() + 1);
  return(r);
}

void
FrameObject::GetCrossPoints(CrossPoint** ltop_return,
			     CrossPoint** lbot_return,
			     CrossPoint** rtop_return,
			     CrossPoint** rbot_return)
{
  CrossPoint* ltop;
  CrossPoint* lbot;
  *ltop_return = ltop = this->GetCrossPoint();
  *lbot_return = lbot = ltop->GetCellBottomCrossPoint();
  *rtop_return = ltop->GetCellRightCrossPoint();
  do
  {
    lbot = lbot->GetHNext();
  } while (lbot->GetKind() & CrossPoint::VStart);
  *rbot_return = lbot;
}

// size change(virtual function)
void FrameObject::ChangeSize()
{
  ;	// do nothing
}

// cange flow(virtual function)
FrameObject* 
FrameObject::ChangeFlow(FrameObject* next)
{
  return next;
}

// check vanish
bool 
FrameObject::CheckVanish()
{
  return True;
}

// check first flow object
bool 
FrameObject::IsFirstObject()
{
  return True;
}

// get next frame object
FrameObject* 
FrameObject::GetNextFrameObject()
{
  return 0;
}

// get next link object
FrameObject* 
FrameObject::GetNextLinkObject()
{
  return 0;
}

void 
FrameObject::SetTopMargin(Iunit m)
{
  margin.SetTop(m);
  ChangeSize();
}

void 
FrameObject::SetBottomMargin(Iunit m)
{
  margin.SetBottom(m);
  ChangeSize();
}

void 
FrameObject::SetLeftMargin(Iunit m)
{
  margin.SetLeft(m);
  ChangeSize();
}

void 
FrameObject::SetRightMargin(Iunit m)
{
  margin.SetRight(m);
  ChangeSize();
}

void 
FrameObject::SetMargin(Margin& m)
{
  margin = m;
  ChangeSize();
}

void 
FrameObject::SetMargin(Iunit top, Iunit bottom, 
			Iunit left, Iunit right)
{
  margin.Set(top, bottom, left, right);
  ChangeSize();
}
