// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frameown.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class FrameOwner
// t[\hLg猩ɂNX
// FrameOwner p LayoutTemplate 

#include "pword.h"
#include "fission.h"
#include "frameown.h"

// constructor
FrameOwner::FrameOwner(Iunit x, Iunit y)
{
  ff = new FissionFrame(x, y, this);
}

// constructor. this constructor is called by derived class.
FrameOwner::FrameOwner()
{
  ff = 0;	// fission-frame must be set after constructor.
}

// destructor
FrameOwner::~FrameOwner()
{
  delete ff;
}

// update template.
void 
FrameOwner::UpDate()
{
  ;
}

// cerate new object, create FrameTemplate.
FrameObject* 
FrameOwner::CreateFrameObject(FrameObject* src
			       , CrossPoint* cp)
{
  if (src == 0) 
  {
    return CreateNewGate(cp);
  }
  return src->Duplicator(cp);		// duplicate virtual func call
}

// change object, FrameTemplate size is changed.
void 
FrameOwner::ChangeFrameObject(FrameObject* fr)
{
  fr->ChangeSize();			// change size virtual func call
}

// vanish object, FrameTemplate is Vanished
void 
FrameOwner::VanishFrameObject(FrameObject* fr)
{
  delete fr;				// virtual destructor call
}

// change flow
FrameObject* 
FrameOwner::ChangeFlow(FrameObject* from, FrameObject* to)
{
  if (from->GetObjectID() == to->GetObjectID()) 
  {
    return from->ChangeFlow(to);
  }
  else 
  {
    CrossPoint* cp = to->GetCrossPoint();
    VanishFrameObject(to);
    return CreateFrameObject(from, cp);
  }
}

// update fission frame size
void 
FrameOwner::UpdateSize()
{
  ; // do nothing.
}
