// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frameown.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Entrance of frame description classes from documentation.
// FrameOwner is a base class of LayoutTemplate.
// FrameObject is a base class of FrameTemplate.
// class FrameObject
// class FrameOwner

#ifndef FRAMEOWN_H
#define FRAMEOWN_H

#include "rect.h"
#include "margin.h"

class CrossPoint;	// forword ref.
class FissionFrame;	// forword ref.
class FrameObject;	// forword ref.
class FrameOwner;	// forword ref.

// ------------------------------------------------------------
// FrameObject, FrameTemplate and TableCell base class

class SuperFrameObject
{
public:
  // dual link
  SuperFrameObject* prev;
  SuperFrameObject* next;
  
public:
  SuperFrameObject();
  SuperFrameObject(SuperFrameObject* next);
  ~SuperFrameObject();
  
  FrameObject* CastToFrameObject();
  SuperFrameObject* GetNext() 
  {
    return(this->next);
  }
  
  SuperFrameObject* GetPrev() 
  {
    return(this->prev);
  }
};

class FrameObject 
  : public SuperFrameObject
{
  // crosspoint
  CrossPoint* cp;
  
  // frame margin
  Margin margin;
  
  // internal rect object
  Rect internal;
  
  // external rect
  Irect external_irect;
  
  // selection flag
  int frame_selected_p : 1;
  
  // redisplay requested flag
  int redisplay_requested_p : 1;
  
  // frame margin exchange flag
  int frame_mgn_exchangee_p : 1;
  
private:
  // set flow
  bool SetFlow(FrameObject* src);
  
  // set empty flow
  bool SetEmptyFlow();
  
  // new flow
  bool NewFlow();
  
public:
  // normal constructor
  FrameObject(CrossPoint* cp);
  
  // destructor
  virtual ~FrameObject();
  
  // get internal rect
  Rect GetInternalRect() 
  {
    return internal; 
  }
  
  Irect GetExternalIrect() 
  {
    return(this->external_irect);
  }
  
  Irect GetInternalIrect();
  void GetCrossPoints(CrossPoint** ltop_return, CrossPoint** lbot_return, 
		       CrossPoint** rtop_return, CrossPoint** rbot_return);
  
  // get right up position
  Vector GetPoint() 
  {
    return Vector(internal.x1, internal.y1);
  }
  
  Iunit GetX1() 
  {
    return internal.x1;
  }
  
  Iunit GetX2() 
  {
    return internal.x2;
  }
  
  Iunit GetY1() 
  {
    return internal.y1;
  }
  
  Iunit GetY2() 
  {
    return internal.y2;
  }
  
  // get x position
  Iunit GetCx() 
  {
    return internal.x1;
  }
  
  // get y position
  Iunit GetCy() 
  {
    return internal.y1;
  }
  
  // get width
  Iunit GetWidth() 
  {
    return internal.x2 - internal.x1 + 1;
  }
  
  // get height
  Iunit GetHeight() 
  {
    return internal.y2 - internal.y1 + 1;
  }
  
  // get cross-point
  CrossPoint* GetCrossPoint() 
  {
    return cp;
  }
  
  // set cross-point
  void SetCrossPoint(CrossPoint* cp) 
  {
    FrameObject::cp = cp;
  }
  
  // update
  void UpdateInternalRect();
  
  // get frame margin
  Iunit GetTopMargin()    
  {
    return margin.GetTop();
  }
  
  Iunit GetBottomMargin() 
  {
    return margin.GetBottom();
  }
  
  Iunit GetLeftMargin()   
  {
    return margin.GetLeft();
  }
  
  Iunit GetRightMargin()  
  {
    return margin.GetRight();
  }
  
  Margin GetMargin() 
  {
    return margin;
  }
  
  // set frame margin
  void SetTopMargin(Iunit m);
  void SetBottomMargin(Iunit m);
  void SetLeftMargin(Iunit m);
  void SetRightMargin(Iunit m);
  void SetMargin(Margin& m);
  void SetMargin(Iunit top, Iunit bottom, Iunit left, Iunit right);
  
  // ------------------------------
  // virtual interface
public:
  // display function.
  virtual void DisplayObject(VDisplay* dsp) = 0;
  
  // get frame object ID
  virtual uword GetObjectID() = 0;
  
  // duplicator
  virtual FrameObject* Duplicator(CrossPoint* cp) = 0;
  
  // size change
  virtual void ChangeSize();
  
  // change flow
  // return		: new next
  virtual FrameObject* ChangeFlow(FrameObject* next);
  
  // check vanish
  // return		: False : can not vanish frame-object
  //			: True  : can vanish frame-object
  virtual bool CheckVanish();
  
  // check first flow objct
  virtual bool IsFirstObject();
  
  // get next frame object
  virtual FrameObject* GetNextFrameObject();
  
  // get next link object
  virtual FrameObject* GetNextLinkObject();
  
  // set frame selected status
  void SetFrameSelected(bool s)
  {
    frame_selected_p = s;
  }
  
  // return frame selected status
  bool FrameSelectedP()
  {
    return frame_selected_p != 0;
  }
  
  // get redisplay requested status
  bool RedisplayRequestedP()
  {
    return redisplay_requested_p != 0;
  }
  
  // set redisplay requested status
  void SetRedisplayRequestedStatus(bool s)
  {
    redisplay_requested_p = s;
  }
  
  // invert redisplay requested status
  void InvertRedisplayRequestedStatus()
  {
    redisplay_requested_p = !redisplay_requested_p;
  }
  
  // frame margin exchange flag
  bool FrameMarginExchangeP()
  {
    return frame_mgn_exchangee_p != 0;
  }
  void SetFrameMarginExchangeP(bool p)
  {
    frame_mgn_exchangee_p = p;
  }
};

inline FrameObject* 
SuperFrameObject::CastToFrameObject()
{
  return((FrameObject*) this);
}

// ------------------------------------------------------------
// FrameOwner, LaytoutTemplate and Table base class

class FrameOwner
{
protected:
  
  // fission frame
  FissionFrame* ff;
  
private:
  SuperFrameObject nil_frame_object;
  
public:
  SuperFrameObject* GetNilFrameObject() 
  {return(&this->nil_frame_object);}

  // ------------------------------
  // call back functions

  // These functions are called by fission-frame.
  // Actually these functions are not public.
  // If there was protected friend class faculty in C++.
public:
  // update frame
  virtual void UpDate();
  
  // object create
  virtual FrameObject* CreateFrameObject(FrameObject* src , CrossPoint* cp);
  
  // object change
  virtual void ChangeFrameObject(FrameObject* fr);
  
  // object vanished
  virtual void VanishFrameObject(FrameObject* fr);
  
  // create new flow gate
  virtual FrameObject* CreateNewGate(CrossPoint* cp) = 0;
  
  // change flow
  // return		: new next
  virtual FrameObject* ChangeFlow(FrameObject* from, FrameObject* to);
  
  // create new flow
  virtual FrameObject* CreateNewFlow(CrossPoint* cp) = 0;
  
  // update fission frame size
  virtual void UpdateSize();
  
  // get proper virtical border
  virtual uword GetProperVBorder(CrossPoint* cp, uword index) = 0;
  
  // get proper horizontal border
  virtual uword GetProperHBorder(CrossPoint* cp, uword index) = 0;
  
public:
  
  // constructor
  FrameOwner(Iunit x, Iunit y);
  
  // desturctor
  ~FrameOwner();
  
  // get fission frame
  FissionFrame* GetFissionFrame() 
  {
    return ff;
  }
  
protected:
  // constructor, fission-frame must be
  // set atfer this function.
  FrameOwner();
};

#endif /* FRAMEOWN_H */
