// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: galist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// generic array list class

#ifndef GALIST_H
#define GALIST_H

// define name2 macro
#ifdef __BORLANDC__
#include <generic.h>
#endif
#ifndef name2
#define _Paste2(z, y) _Paste2_x(z, y)
#define _Paste2_x(z, y) z##y
#define name2 _Paste2
#endif

#include "alist.h"

// class name definition
#define GAList(T) name2(GAList, T)
#define GAListIterator(T) name2(GAListIterator, T)

// generic class declaration
#define GAListDeclare(T)						\
class GAList(T) : private ArrayList {					\
public:									\
   GAList(T)() { ; }			/* constructor */		\
   ~GAList(T)() { ; }			/* destructor */		\
   void Push(T* data);			/* push data */			\
   T* Pop();				/* pop data */			\
   void Inject(T* data);		/* push data to last */		\
   T* Eject();				/* pop last data */		\
   uword Number();			/* number */			\
   T* GetTopData();			/* get top data */		\
   uword Search(T* data);		/* search data */		\
   void Delete(T* data);		/* delete */			\
   void Delete(uword n);		/* delete with index */		\
   T* Access(uword n);			/* access with index(1~) */	\
   T* operator [] (uword n);		/* access with index - 1(0~) */\
   void Replace(uword n, T* data);	/* replace data with index */	\
   void Insert(uword prev, T* data);	/* insert data with index */	\
   void Insert(T* prev, T* data);	/* insert data */		\
   void Clear();			/* clear list */		\
};									\
									\
class GAListIterator(T) : private ArrayListIterator {			\
public:									\
   GAListIterator(T)(GAList(T)* alist);					\
   GAListIterator(T)(GAList(T)& alist);					\
   					/* constructor */		\
   T* operator() ();			/* iterator */			\
   /* bool IsEnd(); */			/* iteration end check */	\
   ArrayListIterator::IsEnd;						\
   /* void Revert(); */			/* revert to initial */		\
   ArrayListIterator::Revert;						\
};									\
									\
inline void GAList(T)::Push(T* data) { ArrayList::Push(data); }	\
inline T* GAList(T)::Pop() { return(T*)ArrayList::Pop(); }		\
inline void GAList(T)::Inject(T* data) { ArrayList::Inject(data); }	\
inline T* GAList(T)::Eject() { return(T*)ArrayList::Eject(); }	\
inline void GAList(T)::Delete(T* data) { ArrayList::Delete(data); }	\
inline void GAList(T)::Delete(uword n) { ArrayList::Delete(n); }	\
inline uword GAList(T)::Number() { return ArrayList::Number(); }	\
inline T* GAList(T)::GetTopData() { return(T*)ArrayList::GetTopData(); } \
inline uword GAList(T)::Search(T* data) { return ArrayList::Search(data); } \
inline T* GAList(T)::Access(uword n) { return(T*)ArrayList::Access(n); } \
inline T* GAList(T)::operator [] (uword n)				\
	{ return(T*)ArrayList::operator [] (n); }			\
inline void GAList(T)::Replace(uword n, T* data) 			\
	{ ArrayList::Replace(n, data); }				\
inline void GAList(T)::Insert(uword prev, T* data) 			\
	{ ArrayList::Insert(prev, data); }				\
inline void GAList(T)::Insert(T* prev, T* data) 			\
	{ ArrayList::Insert(prev, data); }				\
inline void GAList(T)::Clear() { ArrayList::Clear(); }			\
									\
inline GAListIterator(T)::GAListIterator(T)(GAList(T)* alist)		\
  : ArrayListIterator((ArrayList*)alist) { ; } 				\
inline GAListIterator(T)::GAListIterator(T)(GAList(T)& alist) 		\
  : ArrayListIterator((ArrayList&)alist) { ; } 				\
inline T* GAListIterator(T)::operator() () {				\
   return(T*)ArrayListIterator::operator() (); }			\

#endif /* GALIST_H */
