// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: gavllist.h,v 2.1 1999/02/27 13:49:36 kudou Ex
// AVL-Tree list generic class
// 92/05/07 Split and modify AVL class from the Leaf Class Library

#ifndef GAVLLIST_H
#define GAVLLIST_H

#include "avllist.h"

// define name2 and name3 macro
#ifdef __BORLANDC__
#include <generic.h>
#endif
#ifndef name2
#define _Paste2(z, y) _Paste2_x(z, y)
#define _Paste2_x(z, y) z##y
#define name2 _Paste2
#endif
#ifndef name3
#define _Paste3(z, y, x)    _Paste3_x(z, y, x)
#define _Paste3_x(z, y, x)  z##y##x
#define name3 _Paste3
#endif

#define GAvlList(T) name2(GAvlList, T)
#define GAvlListIterator(T) name2(GAvlListIterator, T)
#define GAvlSearch(T, Key) name3(GAvlSearch, T, Key)


#ifndef AVL_TEST

#define GAvlListDeclare(T)						\
class GAvlList(T)							\
{									\
   AvlList avl;								\
public:									\
   GAvlList(T)() : avl() { ; }						\
   GAvlList(T)(AvlList& sl) : avl(sl) { ; }				\
   GAvlList(T)(GAvlList(T)& sl) : avl(sl.avl) { ; }			\
   ~GAvlList(T)() { ; }							\
   void operator = (GAvlList(T)& l) { avl = l.avl; }			\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   unsigned int Number() { return avl.Number(); }			\
   T* Access(unsigned int n) { return(T*)avl.Access(n); }		\
   T* operator [] (unsigned int n) { return(T*)avl.Access(n + 1); }	\
   T* Prev(T* item) { return(T*)avl.Prev(item); }			\
   T* Next(T* item) { return(T*)avl.Next(item); }			\
   T* Head() { return(T*)avl.Head(); }					\
   T* Tail() { return(T*)avl.Tail(); }					\
   void Push(T* item) { avl.Push(item); }				\
   T* Pop() { return(T*)avl.Pop(); }					\
   void Inject(T* item) { avl.Inject(item); }				\
   T* Eject() { return(T*)avl.Eject(); }				\
   void InsertBefor (T* item, unsigned int pos) 			\
      { avl.InsertBefor (item, pos); }					\
   void InsertBefor (T* item, T* pos)					\
      { avl.InsertBefor (item, pos); }					\
   void InsertAfter(T* item, unsigned int pos)				\
      { avl.InsertAfter(item, pos); }					\
   void InsertAfter(T* item, T* pos)					\
      { avl.InsertAfter(item, pos); }					\
   void Delete(T* pos) { avl.Delete(pos); }				\
   void Delete(unsigned int pos) { avl.Delete(pos); }			\
   void Clear() { avl.Clear(); }					\
   void ExchangeItem(T* item, unsigned int pos)				\
      { avl.ExchangeItem(item, pos); }					\
   void ExchangeItem(T* item, T* pos)					\
      { avl.ExchangeItem(item, pos); }					\
   void SwapItem(T* i1, T* i2)						\
      { avl.SwapItem(i1, i2); }						\
   void SwapItem(unsigned int n1, unsigned int n2)			\
      { avl.SwapItem(n1, n2); }						\
   friend class GAvlListIterator(T); 					\
};									\
class GAvlListIterator(T) 						\
{									\
   AvlListIterator tpli; 						\
public:									\
   GAvlListIterator(T)(AvlList* l) : tpli(l) { ; }			\
   GAvlListIterator(T)(AvlList& l) : tpli(l) { ; }			\
   GAvlListIterator(T)(AvlSearch* l) : tpli(l) { ; }			\
   ~GAvlListIterator(T)() { ; }						\
   GAvlListIterator(T)(GAvlList(T)* l) : tpli(l->avl) { ; }		\
   T* operator() () { return(T*)tpli(); }				\
};

#ifdef MSC7_FUNARG_BUG
#define GAvlSearchDeclare(T, Key)					\
class GAvlSearch(T, Key)						\
{									\
   AvlSearch avl;							\
public:									\
   GAvlSearch(T, Key)(void *compare, void *key_compare)			\
      : avl(compare, key_compare) { ; }					\
   ~GAvlSearch(T, Key)() { ; }						\
   void Add(T* elem) { avl.Add(elem); }					\
   void Remove(T* elem) { avl.Remove(elem); }				\
   void KeyRemove(Key* key) { avl.KeyRemove(key); }			\
   T* Search(Key* key) { return(T*)avl.Search(key); }			\
    operator AvlSearch* () { return &avl; }				\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   uword Number() { return avl.Number(); }				\
   void Clear() { avl.Clear(); }					\
};
#else /* MSC7_FUNARG_BUG */
#define GAvlSearchDeclare(T, Key)					\
class GAvlSearch(T, Key)						\
{									\
   AvlSearch avl;							\
public:									\
   GAvlSearch(T, Key)(AvlSearch::Comp(* compare)(void*, void*), 	\
                       AvlSearch::Comp(* key_compare)(void*, void*)) 	\
      : avl(compare, key_compare) { ; }					\
   ~GAvlSearch(T, Key)() { ; }						\
   void Add(T* elem) { avl.Add(elem); }					\
   void Remove(T* elem) { avl.Remove(elem); }				\
   void KeyRemove(Key* key) { avl.KeyRemove(key); }			\
   T* Search(Key* key) { return(T*)avl.Search(key); }			\
    operator AvlSearch* () { return &avl; }				\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   uword Number() { return avl.Number(); }				\
   void Clear() { avl.Clear(); }					\
};
#endif /* MSC7_FUNARG_BUG */

#else

//
// for TEST
//
#define GAvlListDeclare(T)						\
class GAvlList(T)							\
{									\
   AvlList avl;								\
public:									\
   GAvlList(T)() : avl() { ; }						\
   GAvlList(T)(GAvlList(T)& sl) : avl(sl.avl) { ; }			\
   ~GAvlList(T)() { ; }							\
   void operator = (GAvlList(T)& l) { avl = l.avl; }			\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   unsigned int Number() { return avl.Number(); }			\
   T* Access(unsigned int n) { return(T*)avl.Access(n); }		\
   T* operator [] (unsigned int n) { return(T*)avl.Access(n + 1); }	\
   T* Prev(T* item) { return(T*)avl.Prev(item); }			\
   T* Next(T* item) { return(T*)avl.Next(item); }			\
   T* Head() { return(T*)avl.Head(); }					\
   T* Tail() { return(T*)avl.Tail(); }					\
   void Push(T* item) { avl.Push(item); }				\
   T* Pop() { return(T*)avl.Pop(); }					\
   void Inject(T* item) { avl.Inject(item); }				\
   T* Eject() { return(T*)avl.Eject(); }				\
   void InsertBefor (T* item, unsigned int pos) 			\
      { avl.InsertBefor (item, pos); }					\
   void InsertBefor (T* item, T* pos)					\
      { avl.InsertBefor (item, pos); }					\
   void InsertAfter(T* item, unsigned int pos)				\
      { avl.InsertAfter(item, pos); }					\
   void InsertAfter(T* item, T* pos)					\
      { avl.InsertAfter(item, pos); }					\
   void Delete(T* pos) { avl.Delete(pos); }				\
   void Delete(unsigned int pos) { avl.Delete(pos); }			\
   void Clear() { avl.Clear(); }					\
   void ExchangeItem(T* item, unsigned int pos)				\
      { avl.ExchangeItem(item, pos); }					\
   void ExchangeItem(T* item, T* pos)					\
      { avl.ExchangeItem(item, pos); }					\
   void SwapItem(T* i1, T* i2)						\
      { avl.SwapItem(i1, i2); }						\
   void SwapItem(unsigned int n1, unsigned int n2)			\
      { avl.SwapItem(n1, n2); }						\
   void ShowElement(void(* show)(void*))				\
      { avl.ShowElement(show); }					\
   friend class GAvlListIterator(T); 					\
};									\
class GAvlListIterator(T) 						\
{									\
   AvlListIterator tpli; 						\
public:									\
   GAvlListIterator(T)(AvlList* l) : tpli(l) { ; }			\
   GAvlListIterator(T)(AvlList& l) : tpli(l) { ; }			\
   GAvlListIterator(T)(AvlSearch* l) : tpli(l) { ; }			\
   ~GAvlListIterator(T)() { ; }						\
   GAvlListIterator(T)(GAvlList(T)* l) : tpli(l->avl) { ; }		\
   T* operator() () { return(T*)tpli(); }				\
};

#ifdef MSC7_FUNARG_BUG
// msc7 enum bug
#define GAvlSearchDeclare(T, Key)					\
class GAvlSearch(T, Key)						\
{									\
   AvlSearch avl;							\
public:									\
   GAvlSearch(T, Key)(void *compare, void *key_compare)			\
      : avl(compare, key_compare) { ; }					\
   ~GAvlSearch(T, Key)() { ; }						\
   void Add(T* elem) { avl.Add(elem); }					\
   void Remove(T* elem) { avl.Remove(elem); }				\
   void KeyRemove(Key* key) { avl.KeyRemove(key); }			\
   T* Search(Key* key) { return(T*)avl.Search(key); }			\
   void ShowElement(void(* show)(void* elem)) { avl.ShowElement(show); }\
   operator AvlSearch* () { return &avl; }				\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   uword Number() { return avl.Number(); }				\
   void Clear() { avl.Clear(); }					\
};
#else /* MSC7_FUNARG_BUG */
#define GAvlSearchDeclare(T, Key)					\
class GAvlSearch(T, Key)						\
{									\
   AvlSearch avl;							\
public:									\
   GAvlSearch(T, Key)(AvlSearch::Comp(* compare)(void*, void*), 	\
                       AvlSearch::Comp(* key_compare)(void*, void*)) 	\
      : avl(compare, key_compare) { ; }					\
   ~GAvlSearch(T, Key)() { ; }						\
   void Add(T* elem) { avl.Add(elem); }					\
   void Remove(T* elem) { avl.Remove(elem); }				\
   void KeyRemove(Key* key) { avl.KeyRemove(key); }			\
   T* Search(Key* key) { return(T*)avl.Search(key); }			\
   void ShowElement(void(* show)(void* elem)) { avl.ShowElement(show); }\
   operator AvlSearch* () { return &avl; }				\
   bool IsEmpty() { return avl.IsEmpty(); }				\
   uword Number() { return avl.Number(); }				\
   void Clear() { avl.Clear(); }					\
};
#endif /* MSC7_FUNARG_BUG */

#endif

#endif /* GAVLLIST_H */
