// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: gen_tab.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Generate some tables automagicaly.

#undef NDEBUG
#define NOT_WINDOWS
#include "pword.h"

#include <stdlib.h>

#include "sjis.h"

static char* 
char_class_name_0(int cc)
{
  return(cc == CharClass_RANDOM_PUNCT ? "CharClass_RANDOM_PUNCT"
	  : cc == CharClass_LEFT_PUNCT ? "CharClass_LEFT_PUNCT"
	  : cc == CharClass_RIGHT_PUNCT ? "CharClass_RIGHT_PUNCT"
	  : cc == CharClass_NORMAL_SPACE ? "CharClass_NORMAL_SPACE"
	  : cc == CharClass_SPECIAL_SPACE ? "CharClass_SPECIAL_SPACE"
	  : cc == CharClass_DIGIT ? "CharClass_DIGIT"
	  : cc == CharClass_EUROCHAR ? "CharClass_EUROCHAR"
	  : cc == CharClass_KANA ? "CharClass_KANA"
	  : cc == CharClass_RIGHT_KANA ? "CharClass_RIGHT_KANA"
	  : cc == CharClass_HIRAGANA ? "CharClass_HIRAGANA"
	  : cc == CharClass_RIGHT_HIRAGANA ? "CharClass_RIGHT_HIRAGANA"
	  : cc == CharClass_KATAKANA ? "CharClass_KATAKANA"
	  : cc == CharClass_RIGHT_KATAKANA ? "CharClass_RIGHT_KATAKANA"
	  : cc == CharClass_KANJI ? "CharClass_KANJI"
	  : cc == CharClass_RIGHT_KANJI ? "CharClass_RIGHT_KANJI"
	  : cc == CharClass_SPECIAL ? "CharClass_SPECIAL"
	  : cc == CharClass_RANDOM_PUNCT ? "CharClass_RANDOM_PUNCT"
	  : NULL);
}

static char* 
char_class_name(int cc)
{
  char* name = char_class_name_0(cc);
  assert(name != NULL);
  return(name);
}

// ------------------------------------------------------------
// generate `break_table'

char NEAR break_table[CharClass_UNUSED_MAX][CharClass_UNUSED_MAX];

static void
set_break(int i, int j, int value)
{
  assert(i != -1 || j != -1);
  assert(-1 <= i && i < CharClass_UNUSED_MAX);
  assert(-1 <= i && i < CharClass_UNUSED_MAX);
  
  if (i == -1)
  {
    for (i = 0; i != CharClass_UNUSED_MAX; ++i)
    {
      break_table[i][j] = value;
    }
  }
  else if (j == -1)
  {
    for (j = 0; j != CharClass_UNUSED_MAX; ++j)
    {
      break_table[i][j] = value;
    }
  }
  else
  {
    break_table[i][j] = value;
  }
}

static void
make_break_table()
{
  memset(break_table, 1, sizeof(break_table));
  
  set_break(CharClass_RIGHT_PUNCT, -1, 10);
  set_break(CharClass_RIGHT_KANA, -1, 10);
  set_break(CharClass_RIGHT_HIRAGANA, -1, 10);
  set_break(CharClass_RIGHT_KATAKANA, -1, 10);
  set_break(CharClass_RIGHT_KANJI, -1, 10);
  
  set_break(-1, CharClass_LEFT_PUNCT, 10);
  
  set_break(CharClass_KANA, -1, 1);
  set_break(-1, CharClass_KANA, 1);
  set_break(CharClass_HIRAGANA, -1, 4);
  set_break(-1, CharClass_HIRAGANA, 4);
  set_break(CharClass_KATAKANA, -1, 4);
  set_break(-1, CharClass_KATAKANA, 4);
  set_break(CharClass_KANJI, -1, 2);
  set_break(-1, CharClass_KANJI, 2);
  
  set_break(-1, CharClass_RIGHT_PUNCT, 0);
  set_break(-1, CharClass_RIGHT_KANA, 0);
  set_break(-1, CharClass_RIGHT_HIRAGANA, 0);
  set_break(-1, CharClass_RIGHT_KATAKANA, 0);
  set_break(-1, CharClass_RIGHT_KANJI, 0);
  
  set_break(CharClass_LEFT_PUNCT, -1, 0);
  
  set_break(CharClass_DIGIT, CharClass_DIGIT, 0);
  set_break(CharClass_DIGIT, CharClass_EUROCHAR, 0);
  set_break(CharClass_EUROCHAR, CharClass_DIGIT, 0);
  set_break(CharClass_EUROCHAR, CharClass_EUROCHAR, 0);
  
  set_break(CharClass_SPECIAL, -1, 15);
  set_break(-1, CharClass_SPECIAL, 15);
  
  set_break(CharClass_SPECIAL_SPACE, -1, 15);
  set_break(-1, CharClass_SPECIAL_SPACE, 15);
  set_break(CharClass_NORMAL_SPACE, -1, 15);
  set_break(-1, CharClass_NORMAL_SPACE, 15);
  set_break(CharClass_NORMAL_SPACE, CharClass_NORMAL_SPACE, 20);
  
  printf("\n");
  printf("char NEAR break_table[CharClass_UNUSED_MAX][CharClass_UNUSED_MAX] =\n");
  printf("{\n");
  for (int i = 0; i != CharClass_UNUSED_MAX; ++i)
  {
    printf("  {\n");
    for (int j = 0; j != CharClass_UNUSED_MAX; ++j)
    {
      printf("    %2d, // %s & %s\n",
	      break_table[i][j], char_class_name(i), char_class_name(j));
    }
    printf("  },\n");
  }
  printf("};\n");
}

// ------------------------------------------------------------
// generate character class tables

// Next 3 vectors is initialized by `CharClass_RANDOM'.
CharClass NEAR ansi_char_class_table[1 << BITS_PER_CHAR];
CharClass NEAR kana_char_class_table[1 << BITS_PER_CHAR];
CharClass NEAR sjis_char_class_table[SJIS_TABLE_SIZE];

#define print_char_class_table(name) \
print_char_class_table_ (#name, name, NUMBER_OF(name))

static void
print_char_class_table_ (char* name, CharClass* table, int size)
{
  printf("\n");
  printf("CharClass NEAR %s[] =\n", name);
  printf("{\n");
  for (int i = 0; i != size; ++i)
  {
    printf("  %s,\n", char_class_name(table[i]));
  }
  printf("};\n");
}

static void
set_ansi(unsigned int c, CharClass cc)
{
  assert(c < NUMBER_OF(ansi_char_class_table));
  ansi_char_class_table[c] = cc;
}

static void
set_kana(unsigned int c, CharClass cc)
{
  assert(c < NUMBER_OF(kana_char_class_table));
  kana_char_class_table[c] = cc;
}

static void
set_sjis(unsigned int c, CharClass cc)
{
  c -= SJIS_TABLE_BASE;
  assert(c < NUMBER_OF(sjis_char_class_table));
  sjis_char_class_table[c] = cc;
}

static void
set_ansi_range(unsigned int from, unsigned int to, CharClass cc)
{
  assert(from < to);
  for (unsigned int c = from; c <= to; ++c)
  {
    set_ansi(c, cc);
  }
}

static void
set_kana_range(unsigned int from, unsigned int to, CharClass cc)
{
  assert(from < to);
  for (unsigned int c = from; c <= to; ++c)
  {
    set_kana(c, cc);
  }
}

static void
set_sjis_range(unsigned int from, unsigned int to, CharClass cc)
{
  assert(from < to);
  for (unsigned int c = from; c <= to; ++c)
  {
    set_sjis(c, cc);
  }
}

static void
make_char_class_table()
{
  set_ansi_range('0', '9', CharClass_DIGIT);
  set_ansi_range('A', 'Z', CharClass_EUROCHAR);
  set_ansi_range('a', 'z', CharClass_EUROCHAR);
  set_ansi_range(0x80, MAX_UCHAR, CharClass_EUROCHAR);
  
  // special eurochars
  set_ansi('\'', CharClass_EUROCHAR);
  set_ansi('\"', CharClass_EUROCHAR);
  
  set_ansi('\0', CharClass_SPECIAL_SPACE);
  set_ansi('\t', CharClass_NORMAL_SPACE);
  set_ansi('\n', CharClass_SPECIAL_SPACE);
  set_ansi(' ', CharClass_NORMAL_SPACE);
  set_ansi('(', CharClass_LEFT_PUNCT);
  set_ansi(')', CharClass_RIGHT_PUNCT);
  set_ansi('<', CharClass_LEFT_PUNCT);
  set_ansi('>', CharClass_RIGHT_PUNCT);
  set_ansi('[', CharClass_LEFT_PUNCT);
  set_ansi(']', CharClass_RIGHT_PUNCT);
  set_ansi('{', CharClass_LEFT_PUNCT);
  set_ansi('}', CharClass_RIGHT_PUNCT);
  
  // special case
  set_ansi('!', CharClass_RIGHT_PUNCT);
  set_ansi(',', CharClass_RIGHT_PUNCT);
  set_ansi('.', CharClass_RIGHT_PUNCT);
  set_ansi('?', CharClass_RIGHT_PUNCT);
  set_ansi(':', CharClass_RIGHT_PUNCT);
  set_ansi(';', CharClass_RIGHT_PUNCT);
  set_ansi('#', CharClass_LEFT_PUNCT);
  set_ansi('$', CharClass_LEFT_PUNCT);
  set_ansi('%', CharClass_LEFT_PUNCT);
  set_ansi('@', CharClass_LEFT_PUNCT);

  set_kana_range(0xa0, 0xdf, CharClass_KANA);
  set_kana(0xa0, CharClass_NORMAL_SPACE);
  set_kana(0xa1, CharClass_RIGHT_PUNCT);	// maru
  set_kana(0xa2, CharClass_LEFT_PUNCT);	// left kakko
  set_kana(0xa3, CharClass_RIGHT_PUNCT);	// right kakko
  set_kana(0xa4, CharClass_RIGHT_PUNCT);	// ten
  set_kana(0xa5, CharClass_RIGHT_PUNCT);	// nakaguro
  set_kana(0xa7, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xa8, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xa9, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xaa, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xab, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xac, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xad, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xae, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xaf, CharClass_RIGHT_KANA);	// small kana
  set_kana(0xb0, CharClass_RIGHT_KANA);	// chyo-on
  set_kana(0xde, CharClass_RIGHT_KANA);	// dakuonn
  set_kana(0xdf, CharClass_RIGHT_KANA);	// han-dakuonn

  
  set_sjis(0x8140, CharClass_NORMAL_SPACE);	// ZENKANU space
  set_sjis(0x8141, CharClass_RIGHT_PUNCT);	// ten
  set_sjis(0x8142, CharClass_RIGHT_PUNCT);	// maru
  set_sjis(0x8143, CharClass_RIGHT_PUNCT);	// ,
  set_sjis(0x8144, CharClass_RIGHT_PUNCT);	// .
  set_sjis(0x8145, CharClass_RIGHT_PUNCT);	// nakaguro
  set_sjis(0x8146, CharClass_RIGHT_PUNCT);	// :
  set_sjis(0x8147, CharClass_RIGHT_PUNCT);	// ;
  set_sjis(0x8148, CharClass_RIGHT_PUNCT);	// ?
  set_sjis(0x8149, CharClass_RIGHT_PUNCT);	// !
  set_sjis(0x814a, CharClass_RIGHT_HIRAGANA);	// dakuonn
  set_sjis(0x814b, CharClass_RIGHT_HIRAGANA);	// han-dakuonn
  
  set_sjis_range(0x8152, 0x8156, CharClass_RIGHT_HIRAGANA); // repeat chars
  set_sjis(0x8157, CharClass_RIGHT_KANJI);	// repeat char
  set_sjis(0x8158, CharClass_RIGHT_KANJI);	// repeat char
  
  set_sjis(0x815b, CharClass_RIGHT_KATAKANA);	// chyo-on
  
  set_sjis(0x8163, CharClass_RIGHT_PUNCT);
  set_sjis(0x8164, CharClass_RIGHT_PUNCT);
  set_sjis(0x8165, CharClass_LEFT_PUNCT);
  set_sjis(0x8166, CharClass_RIGHT_PUNCT);
  set_sjis(0x8167, CharClass_LEFT_PUNCT);
  set_sjis(0x8168, CharClass_RIGHT_PUNCT);
  set_sjis(0x8169, CharClass_LEFT_PUNCT);
  set_sjis(0x816a, CharClass_RIGHT_PUNCT);
  set_sjis(0x816b, CharClass_LEFT_PUNCT);
  set_sjis(0x816c, CharClass_RIGHT_PUNCT);
  set_sjis(0x816d, CharClass_LEFT_PUNCT);
  set_sjis(0x816e, CharClass_RIGHT_PUNCT);
  set_sjis(0x816f, CharClass_LEFT_PUNCT);
  set_sjis(0x8170, CharClass_RIGHT_PUNCT);
  set_sjis(0x8171, CharClass_LEFT_PUNCT);
  set_sjis(0x8172, CharClass_RIGHT_PUNCT);
  set_sjis(0x8173, CharClass_LEFT_PUNCT);
  set_sjis(0x8174, CharClass_RIGHT_PUNCT);
  set_sjis(0x8175, CharClass_LEFT_PUNCT);
  set_sjis(0x8176, CharClass_RIGHT_PUNCT);
  set_sjis(0x8177, CharClass_LEFT_PUNCT);
  set_sjis(0x8178, CharClass_RIGHT_PUNCT);
  set_sjis(0x8179, CharClass_LEFT_PUNCT);
  set_sjis(0x817a, CharClass_RIGHT_PUNCT);

  set_sjis_range(0x818b, 0x818d, CharClass_RIGHT_PUNCT); // unit chars
  set_sjis_range(0x818e, 0x8198, CharClass_LEFT_PUNCT); // unit chars
  set_sjis_range(0x824f, 0x8258, CharClass_DIGIT);
  set_sjis_range(0x8260, 0x829a, CharClass_EUROCHAR);
  
  set_sjis_range(0x829f, 0x82f1, CharClass_HIRAGANA);
  set_sjis(0x829f, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82a1, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82a3, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82a5, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82a7, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82c1, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82e1, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82e3, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82e5, CharClass_RIGHT_HIRAGANA); // small char
  set_sjis(0x82ec, CharClass_RIGHT_HIRAGANA); // small char

  set_sjis_range(0x8340, 0x8396, CharClass_KATAKANA);
  set_sjis(0x8340, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8342, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8344, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8346, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8348, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8362, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8383, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8385, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8387, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x838e, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8395, CharClass_RIGHT_KATAKANA); // small char
  set_sjis(0x8396, CharClass_RIGHT_KATAKANA); // small char
  
  print_char_class_table(ansi_char_class_table);
  print_char_class_table(kana_char_class_table);
  print_char_class_table(sjis_char_class_table);
}

// ------------------------------------------------------------
// generate character type table

static void
make_char_type_table()
{
  printf("\n");
  printf("CharType NEAR char_type_table[] =\n");
  printf("{\n");
  for (int i = 0; i != MAX_UCHAR + 1; ++i)
  {
    sjis c = i << BITS_PER_CHAR;
    printf("  %s,\n",
	    (IsKanji(c) ? "CharType_KANJI"
	     : IsAnsi(c) ? "CharType_ANSI"
	     : IsKana(c) ? "CharType_KANA"
	     : IsPanel(c) ? "CharType_PANEL"
	     : "CharType_UNKNOWN"));
  }
  printf("};\n");
}

void CDECL
main()
{
  printf("//\n");
  printf("// This file is generated by program named gen_tab.\n");
  printf("//\n");
  printf("\n");
  printf("#include \"pword.h\"\n");
  printf("\n");
  printf("#include \"sjis.h\"\n");

  make_char_type_table();
  make_char_class_table();
  make_break_table();
  
  exit((ferror(stdout) || fclose(stdout) != 0) ? 1 : 0);
}
