// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: generics.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// generic superclasses for extendable tables and entries
// Mainly used in attribute management system.

#ifndef GENERICS_H
#define GENERICS_H

#include <stdio.h>

// fastest checking of attribute-system's index.
#define VALID_ATTR_INDEX_P(a) (0 < (signed short) (a))

class GenericTable
{
protected:
  // Following enum constants are written to BeatWord file.
  // Don't change there.  (konno)
  enum
  {
    ZERO_INDEX,
    UNKNOWN_INDEX,
    NONZERO_INDEX,
    FULL_ENTRY,
    SAME_INDEX,
  };

  unsigned int nEntries;
  unsigned int nMax;
  unsigned int cached_index;
  unsigned int marked;
#ifdef BW2_NEW_ATTR
  unsigned int hash_table[256];
#else /* not BW2_NEW_ATTR */
  unsigned int* hash_table;
#endif /* not BW2_NEW_ATTR */
  
public:
  GenericTable();
#ifdef BW2_NEW_ATTR
  void* CDECL operator new(size_t size);
  void CDECL operator delete(void* mem);
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */
  
public:
  virtual void ClearMarks() = 0;
  
public:
  unsigned int GetNEntries();
  
#ifndef NDEBUG
public:
  virtual void Dump(FILE*) = 0;
#endif
};

inline unsigned int
GenericTable::GetNEntries()
{
  return(this->nEntries);
}

class GenericEntry
{
private:
  int work;
  
public:
  unsigned int chain;
  
public:
  GenericEntry();
#ifdef BW2_NEW_ATTR
  void* CDECL operator new(size_t size);
  void CDECL operator delete(void* mem);
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */
  
public:
  int GetMark();
  void ClearMark();
  void Destroy();
  void Mark();
  void SetMark();
  void SetMark(int value);
};

inline
GenericEntry::GenericEntry()
{
  this->work = 0;
  this->chain = 0;
}

inline int
GenericEntry::GetMark()
{ 
  return(this->work);
}

inline void
GenericEntry::SetMark(int value)
{ 
  this->work = value;
}

inline void
GenericEntry::SetMark()
{ 
  this->SetMark(1);
}

inline void
GenericEntry::ClearMark()
{ 
  this->SetMark(0);
}

inline void
GenericEntry::Mark()
{
  this->SetMark();
}

// for tabletem.cpp
inline void
GenericEntry::Destroy()
{
}

class DeadableEntry
  : public GenericEntry
{
private:
  int dead;
  
protected:
  DeadableEntry::DeadableEntry();
  
protected:
  void DeadableEntry::ImmediateClearDead();
  void DeadableEntry::ImmediateSetDead();
  
public:
  int DeadableEntry::GetDead();
};

inline int
DeadableEntry::GetDead()
{
  return(this->dead);
}

inline void
DeadableEntry::ImmediateClearDead()
{
  this->dead = 0;
}

inline void
DeadableEntry::ImmediateSetDead()
{
  this->dead = 1;
}

inline
DeadableEntry::DeadableEntry()
{
  this->ImmediateClearDead();
}

#endif /* GENERICS_H */
