// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: grphobjc.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class GraphicObject
// rbg}bv}`̈\NX

#include "pword.h"
#include "rect.h"
#include "vdisplay.h"
#include "grphobjc.h"
#include "objectid.h"
#include "unknowno.h"
#include "fission.h"
#include "docwindo.h"
#include "picture.h"

// constructor for graphic panel.
GraphicObject::GraphicObject(CrossPoint* cp, Picture* pic)
   : FrameObject(cp)
{
   GraphicObject::pic = pic;
}

// constructor for duplicate
GraphicObject::GraphicObject(CrossPoint* cp, GraphicObject* gr)
   : FrameObject(cp)
{
   pic = new Picture(gr->pic);
}

// destructor
GraphicObject::~GraphicObject()
{
   delete pic;
}

// get freme object ID
uword
GraphicObject::GetObjectID()
{
   return IDGraphicObject;
}

// display grapic
void
GraphicObject::DisplayObject(VDisplay* vdsp)
{
  this->pic->Redisplay(vdsp, this->GetInternalRect());
}

// duplicator
FrameObject*
GraphicObject::Duplicator(CrossPoint* cp)
{
   GraphicObject* go = new GraphicObject(cp, this);
   if (!(go->pic->IsValid()))
   {
      delete go;
      return new UnknownObject(cp, True);
   }
   return go;
}

// copy to clipboard
void
GraphicObject::CopyToClipboard()
{
   pic->CopyToClipboard();
}
