// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: interval.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Intervals represent either a single point or a pair of points, thereby
// designating a location or range.  They OWN the buffer pointers they
// use.  For instance, they delete them when they themselves are destructed.
//
// Both buffer pointers, numbered 0 and 1, are always present.  If they are
// the same, the interval is a point.  If not, the interval is a range.
// The left-most point is NOT necessarily point 0; it must be retrieved using
// GetLeftBP; similarly, GetRightBP.
// 
// When you set a buffer pointer in an interval using SetBP0 and SetBP1,
// they are always copied.  If you don't need the buffer pointer anymore,
// you must get rid of it.
// 
// Interval arithmetic available at present includes the ability to discern
// whether or not a particular buffer pointer is inside the interval,
// and the intervals that would have to be subtracted from or added to an
// interval to get it to reach a particular point(Diff()).

#ifndef INTERVAL_H
#define INTERVAL_H

#include "attribut.h"
#include "base.h"
#include "bufnew.h"

class Interval
  : public BaseInterval
{
  friend class IntervalList;
  friend class IntervalListTraversor;

private:
  BP* BP0;
  BP* BP1;
  attr atts;
	
public:
  Interval();
  Interval(BPP bp0, BPP bp1);
  Interval(BPP bp0_and_1);
  Interval(Interval*);
  Interval(Interval&);
  Interval(EditText*);
  Interval(TextFlow*);
  Interval(PStream*);
  Interval(BoundInterval&, DocumentContent* dc);
  
  void Init();
  
  virtual ~Interval();

  BP* GetBP0();
  BP* GetBP1();

  attr GetAtts()
  {
    return atts;
  }
  
  Interval* GetNext()
  {
    return(Interval*)BaseInterval::GetNext();
  }
  
  void SetAtts(attr a);

  // returns True if `this' is an empty interval.
  bool PointP();
  signed int Sense();
  void DelayFormat();
  void DelayFormatParagraphs();
  Interval* Interval::IncludeAllChars();
  void SetBP0(BPP);
  void SetBP1(BPP);
  void Set(BPP, BPP);
  void Set(BPP);
  void Reverse();

  enum BPCMP
  {
    BC_WRONGINT,
    BC_BEYOND,
    BC_BEHIND,
    BC_INSIDE,
    BC_ERROR
  };

  BPCMP BPcmp(BPP);
  BPP GetLeft();
  BPP GetRight();
  void GetLeftRight(BP*&, BP*&);
  void GotoEndPoint(), GotoBeginningPoint();
  void Diff(BPP, Interval*&, Interval*&);
  unsigned long ParCount();
  int operator == (Interval&);
  void IncDefRegion(BPP, bool double_click);

  // routines related to moving and found in move.cpp
  
  void Navigate(WORD);
  void InsertASCII(BufStream* , int, bool);
  void InsertText(sjis*, uword);
  void InsertFromStream(PStream*);
  void TurnOff(), TurnOn(), TurnOnSub(), TurnOffMain();
  void TurnOnOff(uword, uword, bool invalidate=True);
  void TurnOffBlueOnYellow();
  void Collapse();
  void MakeBackSpace();
  void MakeWord();
  void MakeLine();
  void MakePara();
  void MakeRight();
  void MakeRightWord();
  void Delete();
  int Cut();
  attr InferAttributes();
	
  // routines for writing intervals to streams -- this is their
  // contents as text, not their start and end buffer poitners
  // probably oughta be two classes
		
  void  WriteASCIIToStream(BufStream*);
  void MarkCookieConnections(PStream*);
  void  WriteFormattedToStream(PStream*);
  TextFlow* GetTextFlow();
  DocumentContent* GetDocumentContent();
  int EQ(BaseInterval&);
  int Merge(Interval*);
  void Mitose();  
  int VariableTextUpdate();
  void ApplyCharAtt(attr(*func) (attr, int, int), int, int);
  void ApplyParAtt(attr(*func) (attr, int, int), int, int);
  void ApplyParAtt(AttSpecList*);
  void SetParCharAtts();
  bool GetCommonCharAtt(attr&);
  IntervalList* FindVText();
  char* GetHint();
};

inline BPP 
Interval::GetBP0()
{
  return BP0;
}

inline BPP 
Interval::GetBP1()
{
  return BP1;
}

inline TextFlow* 
Interval::GetTextFlow()
{
  return(this->GetBP0() ->GetTextFlow());
}

#endif /* INTERVAL_H */
