// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: intlist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define IntervalList class, for lists of intervals

#ifndef INTLIST_H
#define INTLIST_H

#include "base.h"
#include "interval.h"

class IntervalList
  : public BaseIntervalList
{
  void Init();
  virtual BaseInterval* NewMember(BaseInterval*);
  
public:
  IntervalList();
  IntervalList(Interval*);
  IntervalList(IntervalList*);
  IntervalList(DocumentContent*);
  IntervalList(BoundIntervalList* , DocumentContent*);
  ~IntervalList();
  
public:
  static IntervalList* IntervalList::Concat(IntervalList* a, IntervalList* b);
  
public:
  Interval* GetHead()
  {
    return(Interval*)BaseIntervalList::GetHead();
  }
  void AddInterval(BPP, BPP);
  void AddInterval(Interval* i);
  bool DeleteIntervalContaining(BPP bpp);
  void DeleteInterval(Interval* i);
  void DeleteSecondaryIntervals();
  void Collapse();
  void CutOffHead();
  void WeedDeadTextFlow(TextFlow*);  
  void RemoveNested();
  void Cycle(int direction);
  bool PointP();
  Interval* FindIntervalContaining(BPP bpp);
  int EQ(BaseIntervalList&);
  void Apply(void(Interval::*) ());
  void TurnOn();
  void TurnOff();
  void InsertASCII(char* stuff, uword count);
  void InsertText(sjis* stuff, uword count);
  BPP PointForCaret(bool& selection);
  void Cut();
  void BackSpace();
  void GotoEndPoint();
  void MergeWithFirst();
  void MergePoints();
  void InsertFromStream(PStream* stream);
  void WriteFormattedToStream(PStream* stream);
  void WriteASCIIToStream(BufStream* stream);
  void DelayFormat();
  void InferAttributes();  
  IntervalList* AllChars();
  bool BigP();
};

#endif /* INTLIST_H */
