// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutdl.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// layout menu dialogs
// class PageSizeDialog
// class HeaderDialog
// class PageNoDialog
// class DefLayoutDialog 
// class ChangeLayoutDialog 
// class NewSectionDialog
// class ChangeLayoutNameDialog

#ifndef LAYOUTDL_H
#define LAYOUTDL_H

#include "dlg.h"
#include "pagesize.h"
#include "layoutte.h"

// ------------------------------------------------------------
// class PageSizeDialog

class PageSizeDialog
  : public NoKanjiModalDialog
{
  PageSize::Kind paper_name;
  int vert, horiz;
  int top, bottom, right, left;
  PageSize::Orientation orient;
  BOOL done_updating;
public:
  PageSizeDialog(PageSize::Kind initname, 
                  Iunit initvert, 
                  Iunit inithoriz, 
                  Iunit inittop, 
                  Iunit initbottom, 
                  Iunit initright, 
                  Iunit initleft, 
                  PageSize::Orientation initorient);
	
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

  PageSize::Kind GetName() { return paper_name; }
  PageSize::Orientation GetOrient() { return orient; }
  Iunit GetHoriz();
  Iunit GetVert();
  Iunit GetTop();
  Iunit GetBottom();
  Iunit GetLeft();
  Iunit GetRight();

private:

  void InitCombo();
  void SwapVH();
  void ResetName(int ID);
  void ChangeKind(PageSize::Kind kind, bool init);
  
  void SetValue(int ID, int& value);
  BOOL IsGood();
};

// ------------------------------------------------------------
// class HeaderDialog

class HeaderDialog
  : public NoKanjiModalDialog
{
  word all;
  word cur;
  word start_page;
  
public:
  HeaderDialog(word all, word cur, word start_page);
  
  void GetVal(word& all, word& cur, word& start_page)
  {
    all = HeaderDialog::all;
    cur = HeaderDialog::cur;
    start_page = HeaderDialog::start_page;
  }
  
private:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

// ------------------------------------------------------------
// class PageNoDialog

class PageNoDialog
  : public NoKanjiModalDialog
{
  int start_page;
public:
  PageNoDialog(int);
  void GetValues(int& start_p);

protected:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  void RetrieveValue();
  bool IsGood(unsigned int ID, int& result);
};

// ------------------------------------------------------------
// define layout dialog

#define LAYOUTNAMELEN LayoutTemplate::LayoutNameSize

class DefLayoutDialog
  : public PModalDialog
{
private:
  char LayoutName[LAYOUTNAMELEN + 1];
  
protected:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
public:
  DefLayoutDialog();
  char* GetLayoutName()
  {
    return LayoutName;
  }
};

// ------------------------------------------------------------
// class ChangeLayoutDialog 

class ChangeLayoutDialog 
  : public NoKanjiModalDialog
{
  // which layout is selected
  uword layout_id;
  
  // minimum gate number
  uword min_gate_num;
  
  // current gate number
  uword current_gate_num;
  
  // current layout
  LayoutTemplate* current_lt;
  
  // replace one page
  bool replace_one_page;
  
public:
  // constructor
  ChangeLayoutDialog(LayoutTemplate* current_lt,
		      uword min_gate_num, 
		      uword current_gate_num);
  
  uword GetLayoutID()
  {
    return layout_id;
  }

protected:
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SetFlowNum(uword layout_id);
  bool NEAR CheckItem();
  void InitDialog();
  
public:
  bool ReplaceOnePageP()
  {
    return replace_one_page;
  }
};

// ------------------------------------------------------------
// class NewSectionDialog

class NewSectionDialog 
  : public NoKanjiModalDialog
{
  bool next_page;
public:
  NewSectionDialog();
  bool GetNextPage()
  {
    return next_page;
  }
  
private:
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
};

// ------------------------------------------------------------
// class ChangeLayoutNameDialog

class ChangeLayoutNameDialog 
  : public PModalDialog
{
  uword layout_id;
  char name[LAYOUTNAMELEN + 1];
  
public:
  ChangeLayoutNameDialog();
  char* GetLayoutName()
  {
    return name;
  }
  uword GetLayoutID()
  {
    return layout_id;
  }
 
private:
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
};

#endif /* LAYOUTDL_H */
