// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutin.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// LayoutInstance class
// A LayoutInstance speaks of specific pages(or page groups) of a document.
// LayoutInstances contain a variable set of FrameInstances of the
// Frames defined by the FrameTemplates of the begetting LayoutTemplate.

#include "pword.h"
#include <math.h>
#include "ftlist.h"
#include "rect.h"
#include "fission.h"
#include "foiterat.h"
#include "fissioni.h"
#include "allayout.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "pagemap.h"
#include "panel.h"
#include "pref.h"
#include "table.h"
#include "tablepnl.h"
#include "vdisplay.h"
#include "objectid.h"
#include "pwordpre.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "editfram.h"
#include "textflow.h"
#include "screen.h"
#include "view.h"
#include "borderli.h"
#include "pagesize.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

// statics
LayoutInstance* LayoutInstance::zero_mapped_layout = NULL;

// add layout
LayoutInstance::LayoutInstance(PageMap* pm, LayoutInstance* prev)
{
  visible_zero_page = True;
  page_map = pm;
  first_fi = 0;
  last_fi = 0;
  lt = pm->GetLayoutTemplate();
  // link layout-instance chain
  if ((prev_li = prev) == 0) 
  {		// first page insertion 
    next_li = 0;
    pmpn = 1;
  }
  else 
  {				// middle page insertion or addition
    if (prev_li->next_li != 0) 
    {
      // middle insertion
      prev_li->next_li->prev_li = this;
    }
    next_li = prev_li->next_li;
    prev_li->next_li = this;
    pmpn = prev->pmpn + 1;
    for (LayoutInstance* li = next_li;
	 li != 0;
	 li = li->next_li) 
    {
      li->pmpn ++;
    }
  }
  // make 1 page frame-instance
  MakeFrameInstances();
}

// destructor
LayoutInstance::~LayoutInstance()
{
  // report to all window
  for (DocumentWindow* w = ((this->GetDocumentPresentation())
			    ->GetFirstDocWindow());
       w != NULL; w = w->GetNextDocWindow())
  {
    w->BreakLayout(this);
  }
  
  // report to frame editor
  GetDocument()->GetEditFrame()->ReportBreakLayout(this);
  
  if (current_top_level_layout == this)
  {
    current_top_level_layout = NULL;
  }
  
  if (this->GetZeroMappedLayout() == this)
  {
    this->SetZeroMappedLayout(NULL);
  }
  
  // page number
  if (next_li != 0) 
  {
    for (LayoutInstance* li = next_li;
	 li != 0;
	 li = li->next_li) 
    {
      li->pmpn --;
    }
  }
  
  // unlink from layout-instance chain..
  if (prev_li != 0) 
  {
    prev_li->next_li = next_li;
  }
  if (next_li != 0) 
  {
    next_li->prev_li = prev_li;
  }
  
  // delete frame-instances
  FrameInstance* next = 0;
  for (FrameInstance* fi = first_fi; fi != 0; fi = next) 
  {
    next = fi->GetNextLFI();
    fi->BreakPipe();
    delete fi;
  }
}

// make one page frame-instances
void 
LayoutInstance::MakeFrameInstances()
{
  FTListIterator ftli(lt->GetGateList());
  FrameTemplate* ft;
  while ((ft = ftli()) != 0) 
  {
    FrameInstance* prev_fi = new FrameInstance(ft, 0, this);
    for (ft = ft->GetNextTFFT();
	 ft != 0;
	 ft = ft->GetNextTFFT()) 
    {
      prev_fi = new FrameInstance(ft, prev_fi, this);
    }
  }
}

// call befor destructor
void 
LayoutInstance::PrepareToDie()
{
  FTListIterator ftli(lt->GetGateList());
  FrameTemplate* ft = 0;
  while ((ft = ftli()) != 0) 
  {
    while (ft->GetNextTFFT() != 0) 
    {
      ft = ft->GetNextTFFT();
    }
    (FindFIByFT(ft))->PrepareToChangeFlow();
  }
  
  for (FrameInstance* fi = first_fi; 
       fi != 0; 
       fi = fi->GetNextLFI()) 
  {
    fi->SetFormatNeededP(True);
  }
}

// get document content
DocumentContent* 
LayoutInstance::GetDocumentContent()
{
  return page_map->GetDocumentContent();
}

// get document
Document* 
LayoutInstance::GetDocument()
{
  return page_map->GetDocumentContent()->GetDocument();
}

// get document presentation
DocumentPresentation* 
LayoutInstance::GetDocumentPresentation()
{
  return page_map->GetDocumentContent()
  ->GetDocument()
  ->GetDocumentPresentation();
}

// which flow?
TextFlow* 
LayoutInstance::GetAssignedTextFlow(FrameInstance* fi)
{
  uword index = lt->WhichGateFT(fi->GetFrameTemplate());
  if (index == 0) 
  {
    return 0;			// may be error
  }
  return page_map->GetGateTF(index);
}

// get prev layout-instance
LayoutInstance* 
LayoutInstance::GetPrevLayout()
{
  if (prev_li != 0) 
  {
    return prev_li;
  }
  LayoutInstance* li = 0;
  if (lt->IsRegular())
  {
    for (PageMap* pm = page_map->GetPrevPageMap();
	 pm != 0;
	 pm = pm->GetPrevPageMap())
    {
      if ((li = pm->GetLastLayout()) != 0) 
      {
	break;
      }
    }
  }
  return li;
}

// get next layout-instance
LayoutInstance* 
LayoutInstance::GetNextLayout()
{
  if (next_li != 0) 
  {
    return next_li;
  }
  LayoutInstance* li = 0;
  if (lt->IsRegular())
  {
    for (PageMap* pm = page_map->GetNextPageMap();
	 pm != 0;
	 pm = pm->GetNextPageMap())
    {
      if ((li = pm->GetFirstLayout()) != 0) 
      {
	break;
      }
    }
  }
  return li;
}

// find frame-instance by frame-template
FrameInstance* 
LayoutInstance::FindFIByFT(FrameTemplate* ft)
{
  for (FrameInstance* fi = first_fi;
       fi != 0;
       fi = fi->GetNextLFI()) 
  {
    if (fi->GetFrameTemplate() == ft) 
    {
      // find
      return fi;
    }
  }
  return 0;
}

// find gate frame-instance by text-flow
FrameInstance* 
LayoutInstance::GetGateFI(TextFlow* tf)
{
  FrameTemplate* ft = page_map->GetGateFT(tf);
  if (ft == 0) 
  {
    // can not find
    return 0;
  }
  return FindFIByFT(ft);
}

// get exit frame-instance in this layout-instance
FrameInstance* 
LayoutInstance::GetExitFI(TextFlow* tf)
{
  FrameTemplate* ft = page_map->GetGateFT(tf);
  if (ft == 0) 
  {
    // can not find
    return 0;
  }
  while (ft->GetNextTFFT() != 0) 
  {
    ft = ft->GetNextTFFT();
  }
  return FindFIByFT(ft);
}

// get gate frame-instance by gate index
FrameInstance* 
LayoutInstance::GetGateFrame(uword index)
{
  FrameTemplate* ft = page_map->GetGateFT(index);
  if (ft == 0) 
  {
    // can not find
    return 0;
  }
  return FindFIByFT(ft);
}

void
LayoutInstance::ipoint_to_lpoint(Ipoint* ip, Lpoint* lp)
{
  SET_POINT(lp, this->GetLX() + POINT_X(ip), this->GetLY() + POINT_Y(ip));
}

void
LayoutInstance::lpoint_to_ipoint(Lpoint* lp, Ipoint* ip)
{
  SET_POINT(ip,
	     (Iunit) (POINT_X(lp) - this->GetLX()),
	     (Iunit) (POINT_Y(lp) - this->GetLY()));
}

void
LayoutInstance::irect_to_lrect(Irect* ir, Lrect* lr)
{
  this->ipoint_to_lpoint(RECT_POINT(ir, INDEX_TOP),
			  RECT_POINT(lr, INDEX_TOP));
  this->ipoint_to_lpoint(RECT_POINT(ir, INDEX_BOT),
			  RECT_POINT(lr, INDEX_BOT));
}

void
LayoutInstance::get_lpoint(Lpoint* lp)
{
  SET_POINT(lp, this->GetLX(), this->GetLY());
}

void
LayoutInstance::get_lrect(Lrect* lr)
{
  SET_RECT(lr,
	    this->GetLX(),
	    this->GetLY(),
	    this->GetLX() + this->GetWidth(),
	    this->GetLY() + this->GetHeight());
}

void
LayoutInstance::get_zero_page_lrect(Lrect* rect)
{
  this->GetMaybeZeroPageLayout() ->get_lrect(rect);
}

// ------------------------------------------------------------
// draw layout

static void NEAR
kill_object(HANDLE h)
{
  ::DeleteObject(h);
}

static BOOL NEAR
rect_in_region(HRGN region, RECT* rect)
{
  return(::RectInRegion(region, rect));
}

static HRGN NEAR
create_rect_region(RECT* rect)
{
  return((rect->left < rect->right && rect->top < rect->bottom)
	  ? ::CreateRectRgnIndirect(rect) : ::CreateRectRgn(0, 0, 0, 0));
}

static int NEAR
combine_region(HRGN region0, HRGN region1, HRGN region2, int op)
{
  return(::CombineRgn(region0, region1, region2, op));
}

static HGDIOBJ NEAR
select_object(HDC dc, HANDLE object)
{
  return(::SelectObject(dc, object));
}

static DWORD NEAR
set_text_color(HDC dc, DWORD color)
{
  return(::SetTextColor(dc, color));
}

static int NEAR
fill_rect(HDC dc, RECT* rect, HBRUSH brush)
{
  return(::FillRect(dc, rect, brush));
}

#define X0 0
#define X1 1
#define Y0 2
#define Y1 3

#define ZERO_ONE_MASK 1
#define ZERO_OR_ONE(a) ((a) & ZERO_ONE_MASK)
#define IS_0(a) (ZERO_OR_ONE(a) == 0)
#define IS_1(a) ZERO_OR_ONE(a)
#define NOT_01(a) ((a) ^ ZERO_ONE_MASK)

#define XY_MASK 2
#define XY_X 0
#define XY_Y 2
#define X_OR_Y(a) ((a) & XY_MASK)
#define IS_X(a) (X_OR_Y(a) == XY_X)
#define IS_Y(a) (!IS_X(a))
#define NOT_XY(a) ((a) ^ XY_MASK)

struct BorderDrawInfo
{
  int width[2];
  int effective_width[2];
  int ext[4];
  HBRUSH brush;
  DWORD color;
  int doublep;
};

struct PointDrawInfo
{
  int x;
  int y;
  RECT r[1];
  int width[4];
  BorderDrawInfo i[4];
  int prior[4];
  int force_double;
};

extern bool painting_selected_window;

RECT global_brush_org_rect[1];

static void NEAR
get_nil_border_info(BorderDrawInfo* i, int all_line_p)
{
  if (all_line_p)
  {
    i->effective_width[0] = 1;
    i->effective_width[1] = 1;
  }
}

static void NEAR
get_h_border_info(BorderDrawInfo* i,
		   View* view, int all_line_p, CrossPoint* cp)
{
  get_nil_border_info(i, all_line_p);
  i->brush = Screen::invisible_line_brush_h;
  i->color = ((painting_selected_window && cp->GetHRedSelection())
	      ? RED : BLACK);
  
  BorderLine* b;
  uword border;
  if ((border = cp->GetHBorder()) != 0
      && (b = BorderLine::Get(border))->GetType() != BorderLine::Invisible)
  {
    int doublep = !b->SingleP();
    int width;
    if (b->BisaiP())
    {
      width = doublep ? 4 : 1;
    }
    else
    {
      int iunits_width;
      if ((width = view->ScaleDunitY(iunits_width = b->GetWidth())) == 0
	  && iunits_width != 0)
      {
	width = 1;
      }
    }
    
    int width0 = 0;
    int width1 = 0;
    switch (b->GetHAlign())
    {
     case BorderLine::AlignAbove:
      width0 = width;
      width1 = 0;
      break;
      
     case BorderLine::AlignCenter:
      width0 = width / 2;
      width1 = width - width0;
      break;
      
     case BorderLine::AlignBelow:
      width0 = 0;
      width1 = width;
    }
    if (width0 + width1 != 0)
    {
      i->width[0] = i->effective_width[0] = width0;
      i->width[1] = i->effective_width[1] = width1;
      i->doublep = doublep;
      i->brush = b->get_brush(INDEX_HORIZONTAL);
    }
  }
}

static void NEAR
get_v_border_info(BorderDrawInfo* i,
		   View* view, int all_line_p, CrossPoint* cp)
{
  get_nil_border_info(i, all_line_p);
  i->brush = Screen::invisible_line_brush_v;
  i->color = ((painting_selected_window && cp->GetVRedSelection())
	      ? RED : BLACK);
  
  BorderLine* b;
  uword border;
  if ((border = cp->GetVBorder()) != 0
      && (b = BorderLine::Get(border))->GetType() != BorderLine::Invisible)
  {
    int doublep = !b->SingleP();
    int width;
    if (b->BisaiP())
    {
      width = doublep ? 4 : 1;
    }
    else
    {
      int iunits_width;
      if ((width = view->ScaleDunitX(iunits_width = b->GetWidth())) == 0
	  && iunits_width != 0)
      {
	width = 1;
      }
    }
    int width0 = 0;
    int width1 = 0;
    switch (b->GetVAlign())
    {
     case BorderLine::AlignLeft:
      width0 = width;
      width1 = 0;
      break;
      
     case BorderLine::AlignCenter:
      width0 = width / 2;
      width1 = width - width0;
      break;
      
     case BorderLine::AlignRight:
      width0 = 0;
      width1 = width;
    }
    if (width0 + width1 != 0)
    {
      i->width[0] = i->effective_width[0] = width0;
      i->width[1] = i->effective_width[1] = width1;
      i->doublep = doublep;
      i->brush = b->get_brush(INDEX_VERTICAL);
    }
  }
}

static void NEAR
get_point_info(PointDrawInfo* info,
		View* view,
		LayoutInstance* layout, int all_line_p, CrossPoint* cp)
{
  memset(info, 0, sizeof(*info));
  
  CrossPoint* h_prev = cp->GetHPrev();
  CrossPoint* h_next = cp->GetHNext();
  CrossPoint* v_prev = cp->GetVPrev();
  CrossPoint* v_next = cp->GetVNext();
  
  if (h_prev)
  {
    get_h_border_info(&info->i[X0], view, all_line_p, h_prev);
  }
  if (h_next)
  {
    get_h_border_info(&info->i[X1], view, all_line_p, cp);
  }
  if (v_prev)
  {
    get_v_border_info(&info->i[Y0], view, all_line_p, v_prev);
  }
  if (v_next)
  {
    get_v_border_info(&info->i[Y1], view, all_line_p, cp);
  }
  
  Lunit layout_lx = layout->GetLX();
  Lunit layout_ly = layout->GetLY();
  int x;
  int y;
  info->x = x = view->DunitX(layout_lx + cp->X());
  info->y = y = view->DunitY(layout_ly + cp->Y());
  
  info->r->left = x - (info->width[X0] = MAX(info->i[Y0].width[0],
					      info->i[Y1].width[0]));
  info->r->right = x + (info->width[X1] = MAX(info->i[Y0].width[1],
					       info->i[Y1].width[1]));
  info->r->top = y - (info->width[Y0] = MAX(info->i[X0].width[0],
					     info->i[X1].width[0]));
  info->r->bottom = y + (info->width[Y1] = MAX(info->i[X0].width[1],
						info->i[X1].width[1]));
}

static void NEAR
get_gap_info(PointDrawInfo* info,
	      View* view,
	      LayoutInstance* layout, int all_line_p, CrossPoint* cp)
{
  get_point_info(info, view, layout, all_line_p, cp);
  
  int a;
  int num_doubles = 0;
  int num_singles = 0;
  for (a = 0; a != 4; ++a)
  {
    BorderDrawInfo* i = &info->i[a];
    int width0;
    int width1;
    int width = (width0 = i->width[0]) + (width1 = i->width[1]);
    if (i->doublep && 3 <= width)
    {
      ++num_doubles;
      int gap = (IS_X(a) ? view->ScaleDunitY(DOUBLE_LINE_GAP)
		 : view->ScaleDunitX(DOUBLE_LINE_GAP));
      SET_BOUND(gap, 1, width - 2);
      int half = (width - gap) / 2;
      width0 -= half;
      width1 -= half;
    }
    else
    {
      if (width)
      {
	++num_singles;
      }
      width0 = 0;
      width1 = 0;
      i->doublep = False;
    }
    i->effective_width[0] = width0;
    i->effective_width[1] = width1;
  }
  info->force_double = 2 <= num_doubles || num_singles == 0;
}

static void NEAR
fill_gap(View* view, int top_x, int top_y, int bot_x, int bot_y)
{
  RECT rect[1];
  if ((rect->left = top_x) < (rect->right = bot_x)
      && (rect->top = top_y) < (rect->bottom = bot_y))
  {
    fill_rect(view->GetDC(), rect, Screen::stocked_white_brush);
  }
}

static void NEAR
draw_corner_gap(View* view, PointDrawInfo* info)
{
  if (info->force_double
      && info->r->left < info->r->right && info->r->top < info->r->bottom)
  {
    int a;
    int x = info->x;
    int y = info->y;
    for (a = 0; a != 4; ++a)
    {
      BorderDrawInfo* i = &info->i[a];
      if (i->doublep)
      {
	BorderDrawInfo* i0 = &info->i[NOT_XY(a)];
	BorderDrawInfo* i1 = &info->i[NOT_XY(NOT_01(a))];
	int from = -info->width[a];
	int to = from;
	if (i0->doublep || i1->doublep)
	{
	  if (i0->doublep)
	  {
	    int foo = i0->effective_width[NOT_01(ZERO_OR_ONE(a))];
	    SET_MAX(to, foo);
	  }
	  if (i1->doublep)
	  {
	    int foo = i1->effective_width[NOT_01(ZERO_OR_ONE(a))];
	    SET_MAX(to, foo);
	  }
	}
	else
	{
	  to = info->width[NOT_XY(NOT_01(a))];
	}
	int width0 = i->effective_width[0];
	int width1 = i->effective_width[1];
	RECT r[1];
	r->left = x - width0;
	r->right = x + width1;
	r->top = y - width0;
	r->bottom = y + width1;
	switch (a)
	{
	 case X0:
	  r->left = x + from;
	  r->right = x + to;
	  break;
	  
	 case X1:
	  r->left = x - to;
	  r->right = x - from;
	  break;
	  
	 case Y0:
	  r->top = y + from;
	  r->bottom = y + to;
	  break;
	  
	 case Y1:
	 default:
	  r->top = y - to;
	  r->bottom = y - from;
	  break;
	}
	fill_gap(view, r->left, r->top, r->right, r->bottom);
      }
    }
  }
}

static void NEAR
draw_h_gap(View* view,
	    LayoutInstance* layout,
	    int all_line_p, CrossPoint* cp0, CrossPoint* cp1)
{
  PointDrawInfo info0[1];
  PointDrawInfo info1[1];
  get_gap_info(info1, view, layout, all_line_p, cp0);
  draw_corner_gap(view, info1);
  int y = info1->y;
  while (cp0 != cp1)
  {
    cp0 = cp0->GetHNext();
    assert(cp0 != NULL);
    *info0 = *info1;
    get_gap_info(info1, view, layout, all_line_p, cp0);
    fill_gap(view,
	      info0->r->right,
	      y - info0->i[X1].effective_width[0],
	      info1->r->left, y + info0->i[X1].effective_width[1]);
    draw_corner_gap(view, info1);
  }
}

static void NEAR
draw_v_gap(View* view,
	    LayoutInstance* layout,
	    int all_line_p, CrossPoint* cp0, CrossPoint* cp1)
{
  PointDrawInfo info0[1];
  PointDrawInfo info1[1];
  get_gap_info(info1, view, layout, all_line_p, cp0);
  draw_corner_gap(view, info1);
  int x = info1->x;
  while (cp0 != cp1)
  {
    cp0 = cp0->GetVNext();
    assert(cp0 != NULL);
    *info0 = *info1;
    get_gap_info(info1, view, layout, all_line_p, cp0);
    fill_gap(view,
	      x - info0->i[Y1].effective_width[0],
	      info0->r->bottom,
	      x + info0->i[Y1].effective_width[1], info1->r->top);
    draw_corner_gap(view, info1);
  }
}

static int NEAR
compare_border_info(PointDrawInfo* info, int a, int b, int force_double)
{
  BorderDrawInfo* aa = &info->i[a];
  BorderDrawInfo* bb = &info->i[b];
  int aa_width = aa->width[0] + aa->width[1];
  int bb_width = bb->width[0] + bb->width[1];
  if (aa_width == 0 || bb_width == 0)
  {
    return(aa_width - bb_width);
  }
  int aa_doublep = aa->doublep;
  int bb_doublep = bb->doublep;
  if (aa_doublep != bb_doublep)
  {
    return(force_double ? aa_doublep - bb_doublep : bb_doublep - aa_doublep);
  }
  if (aa_width != bb_width)
  {
    return(aa_width - bb_width);
  }
  if (X_OR_Y(a) != X_OR_Y(b))
  {
    return(IS_Y(a) ? 1 : -1);
  }
  return(a - b);
}

static void NEAR
get_line_info(PointDrawInfo* info,
	       View* view,
	       LayoutInstance* layout, int all_line_p, CrossPoint* cp)
{
  get_point_info(info, view, layout, all_line_p, cp);
  
  int num_doubles = 0;
  int num_singles = 0;
  int a;
  int b;
  for (a = 0; a != 4; ++a)
  {
    info->prior[a] = a;
    BorderDrawInfo* i = &info->i[a];
    if (i->width[0] + i->width[1])
    {
      if (i->doublep)
      {
	++num_doubles;
      }
      else
      {
	++num_singles;
      }
    }
  }
  
  int force_double = 2 <= num_doubles || num_singles == 0;
  
  for (b = 1; b != 4; ++b)
  {
    a = b;
    while (a != 0
	   && (compare_border_info(info,
				    info->prior[a - 1],
				    info->prior[a], force_double)
	       < 0))
    {
      int tmp = info->prior[a - 1];
      info->prior[a - 1] = info->prior[a];
      info->prior[a] = tmp;
      --a;
    }
  }
  
  for (a = 0; a != 4; ++a)
  {
    BorderDrawInfo* i = &info->i[a];
    if (IS_X(a))
    {
      i->ext[X0] = info->width[X0];
      i->ext[X1] = info->width[X1];
      i->ext[Y0] = i->width[0];
      i->ext[Y1] = i->width[1];
    }
    else
    {
      i->ext[Y0] = info->width[Y0];
      i->ext[Y1] = info->width[Y1];
      i->ext[X0] = i->width[0];
      i->ext[X1] = i->width[1];
    }
  }
}

static void NEAR
fill_line(View* view,
	   BorderDrawInfo* i, int top_x, int top_y, int bot_x, int bot_y)
{
  RECT rect[1];
  if ((rect->left = top_x) < (rect->right = bot_x)
      && (rect->top = top_y) < (rect->bottom = bot_y))
  {
    HDC dc = view->GetDC();
    DWORD old_color = BLACK;
    if (i->color != BLACK)
    {
      old_color = set_text_color(dc, i->color);
    }
    HBRUSH brush = i->brush;
    view->set_brush_org(CastWindowsRECTToDrect(global_brush_org_rect),
			 brush);
    fill_rect(dc, rect, brush);
    if (i->color != BLACK)
    {
      set_text_color(dc, old_color);
    }
  }
}

static void NEAR
draw_corner_line(View* view, PointDrawInfo* info)
{
  int a;
  int x = info->x;
  int y = info->y;
  for (a = 3; 0 <= a; --a)
  {
    BorderDrawInfo* i = &info->i[info->prior[a]];
    fill_line(view,
	       i,
	       x - i->ext[X0],
	       y - i->ext[Y0], x + i->ext[X1], y + i->ext[Y1]);
  }
}

static void NEAR
draw_h_line(View* view,
	     LayoutInstance* layout,
	     int all_line_p, CrossPoint* cp0, CrossPoint* cp1)
{
  PointDrawInfo info0[1];
  PointDrawInfo info1[1];
  get_line_info(info1, view, layout, all_line_p, cp0);
  draw_corner_line(view, info1);
  int y = info1->y;
  while (cp0 != cp1)
  {
    cp0 = cp0->GetHNext();
    assert(cp0 != NULL);
    *info0 = *info1;
    get_line_info(info1, view, layout, all_line_p, cp0);
    fill_line(view,
	       &info0->i[X1],
	       info0->r->right,
	       y - info0->i[X1].effective_width[0],
	       info1->r->left, y + info0->i[X1].effective_width[1]);
    draw_corner_line(view, info1);
  }
}

static void NEAR
draw_v_line(View* view,
	     LayoutInstance* layout,
	     int all_line_p, CrossPoint* cp0, CrossPoint* cp1)
{
  PointDrawInfo info0[1];
  PointDrawInfo info1[1];
  get_line_info(info1, view, layout, all_line_p, cp0);
  draw_corner_line(view, info1);
  int x = info1->x;
  while (cp0 != cp1)
  {
    cp0 = cp0->GetVNext();
    assert(cp0 != NULL);
    *info0 = *info1;
    get_line_info(info1, view, layout, all_line_p, cp0);
    fill_line(view,
	       &info0->i[Y1],
	       x - info0->i[Y1].effective_width[0],
	       info0->r->bottom,
	       x + info0->i[Y1].effective_width[1], info1->r->top);
    draw_corner_line(view, info1);
  }
}

void NEAR
draw_line(HDC dc, Dpoint* dp0, Dpoint* dp1)
{
#ifdef _WIN32
  MoveToEx(dc, POINT_X(dp0), POINT_Y(dp0), NULL);
#else /* _WIN32 */
  MoveTo(dc, POINT_X(dp0), POINT_Y(dp0));
#endif /* _WIN32 */
  LineTo(dc, POINT_X(dp1), POINT_Y(dp1));
}

void NEAR
get_center_point(View* view,
		  LayoutInstance* layout, FrameInstance* fi, Dpoint* dp)
{
  Irect ir[1];
  fi->get_irect(ir);
  Ipoint ip[1];
  SET_POINT(ip,
	     (RECT_TOP_X(ir) + RECT_BOT_X(ir)) / 2,
	     (RECT_TOP_Y(ir) + RECT_BOT_Y(ir)) / 2);
  Lpoint lp[1];
  layout->ipoint_to_lpoint(ip, lp);
  view->lpoint_to_dpoint(lp, dp);
}

void
LayoutInstance::Redisplay(View* view, HRGN region, DWORD line_color)
{
  int device = view->GetDeviceType();
  int display_frame_line = False;
  int display_frame_margin = False;
  int display_para_margin = False;
  int display_flow_line = False;
  if (device != PRINTER)
  {
    display_frame_line = PWordPresentation::display_frame_line_p();
    display_frame_margin = PWordPresentation::display_frame_margin_p();
    display_para_margin = PWordPresentation::display_para_margin_p();
    display_flow_line = PWordPresentation::display_flow_line_p();
  }
  int all_line_p = (display_frame_line || line_color != BLACK);
  VDisplay vdsp(view, this);
  HDC dc = view->GetDC();
  
  int bk_mode;
  int old_bk_mode = ::SetBkMode(dc, bk_mode = OPAQUE);
  
  DWORD foreground;
  DWORD old_foreground = set_text_color(dc, foreground = line_color);
  
  FrameInstance* next_fi = this->GetFirstFrame();
  FrameInstance* fi = NULL;
  SuperFrameObject* nil_super_frame = (this->GetTemplate()
				       ->GetNilFrameObject());
  SuperFrameObject* super_frame = nil_super_frame;
  
  RECT clip_rect;
  ::GetRgnBox(region, &clip_rect);
  
  fill_rect(dc, &clip_rect, Screen::stocked_white_brush);
  
  for (;;)
  {
    FrameObject* frame;
    ObjectID id;
    
    // next `if' statement set variables `frame' and `id'
    if ((fi = next_fi) != NULL)
    {
      next_fi = fi->GetNextLFI();
      frame = fi->GetTemplate();
      id = IDTextObject;
    }
    else
    {
      for (;;)
      {
	if ((super_frame = super_frame->GetNext()) == nil_super_frame)
	{
#if (!defined(NDEBUG))
//	  syserr("Warning : bug on region operations");
	  super_frame = super_frame; // for breakpoint
#endif
	  goto done;
	}
	if ((id = ((ObjectID)
		   ((frame = super_frame->CastToFrameObject())
		    ->GetObjectID())))
	    != IDTextObject)
	{
	  break;
	}
      }
    }
    
    Lrect external_lrect;
    RECT external_rect;
    Irect external_irect = frame->GetExternalIrect();
    this->irect_to_lrect(&external_irect, &external_lrect);
    view->lrect_to_drect(&external_lrect,
			  CastWindowsRECTToDrect(&external_rect));
    if (external_rect.left < clip_rect.right
	&& clip_rect.left < external_rect.right
	&& external_rect.top < clip_rect.bottom
	&& clip_rect.top < external_rect.bottom
	&& rect_in_region(region, &external_rect))
    {
      HRGN external_region = create_rect_region(&external_rect);
      combine_region(external_region, external_region, region, RGN_AND);
      Lrect internal_lrect;
      RECT internal_rect;
      Irect internal_irect = frame->GetInternalIrect();
      this->irect_to_lrect(&internal_irect, &internal_lrect);
      view->lrect_to_drect(&internal_lrect,
			    CastWindowsRECTToDrect(&internal_rect));
      HRGN internal_region = 0;
      if (rect_in_region(external_region, &internal_rect))
      {
	internal_region = create_rect_region(&internal_rect);
	combine_region(internal_region, internal_region, region, RGN_AND);
	select_object(dc, internal_region);
	if (id == IDTextObject)
	{
	  fi->Redisplay(view, internal_region);
	}
	else
	{
	  frame->DisplayObject(&vdsp);
	}
	if (painting_selected_window && frame->FrameSelectedP())
	{
	  int old_rop2 = SetROP2(dc, R2_MASKPEN);
	  HPEN old_pen = (HPEN)select_object(dc, GetStockObject(NULL_PEN));
	  HBRUSH old_brush = (HBRUSH)select_object(dc, Screen::selected_frame_brush);
	  if (foreground != BLACK)
	  {
	    set_text_color(dc, foreground = BLACK);
	  }
	  Rectangle(dc,
		     internal_rect.left,
		     internal_rect.top,
		     internal_rect.right + 1, internal_rect.bottom + 1);
	  select_object(dc, old_brush);
	  select_object(dc, old_pen);
	  SetROP2(dc, old_rop2);
	}
      }
      
      // draw lines
      CrossPoint* ltop;
      CrossPoint* lbot;
      CrossPoint* rtop;
      CrossPoint* rbot;
      frame->GetCrossPoints(&ltop, &lbot, &rtop, &rbot);
      
      if (bk_mode != OPAQUE)
      {
	::SetBkMode(dc, bk_mode = OPAQUE);
      }
      if (foreground != line_color)
      {
	set_text_color(dc, foreground = line_color);
      }
      select_object(dc, external_region);
      draw_v_line(view, this, all_line_p, ltop, lbot);
      draw_v_line(view, this, all_line_p, rtop, rbot);
      draw_h_line(view, this, all_line_p, ltop, rtop);
      draw_h_line(view, this, all_line_p, lbot, rbot);
      draw_v_gap(view, this, all_line_p, ltop, lbot);
      draw_v_gap(view, this, all_line_p, rtop, rbot);
      draw_h_gap(view, this, all_line_p, ltop, rtop);
      draw_h_gap(view, this, all_line_p, lbot, rbot);
      kill_object(external_region);
      if (internal_region)
      {
	if (id == IDTextObject)
	{
	  if (display_frame_margin)
	  {
	    select_object(dc, internal_region);
	    fi->RedisplayFrameMargin(view);
	  }
	  if (display_para_margin)
	  {
	    select_object(dc, internal_region);
	    fi->RedisplayParagraphMargin(view);
	  }
	}
	kill_object(internal_region);
      }
    }
  }
 done:
  select_object(dc, region);
  if (display_flow_line)
  {
    if (foreground != BLACK)
    {
      set_text_color(dc, foreground = BLACK);
    }
    HPEN old_pen = (HPEN)select_object(dc, CreatePen(PS_SOLID,
						     Pref_flow_line_width, BLACK));
    double arrow_length = (double) (Screen::caption_height / 2);
    SET_MAX(arrow_length, 8.0);
#define DEGREE 20
    double sin_value = sin((3.14 * DEGREE) / 180);
    double cos_value = cos((3.14 * DEGREE) / 180);
    for (fi = this->GetFirstFrame(); fi != NULL; fi = fi->GetNextLFI())
    {
      next_fi = fi->GetNextTFI();
      if (next_fi != NULL)
      {
	Dpoint dp0[1];
	Dpoint dp1[1];
	get_center_point(view, this, fi, dp0);
	get_center_point(view, this, next_fi, dp1);
	draw_line(dc, dp0, dp1);
	double x = (double) (POINT_X(dp0) - POINT_X(dp1));
	double y = (double) (POINT_Y(dp0) - POINT_Y(dp1));
	double line_length = x * x + y * y;
	SET_MAX(line_length, 1);
	line_length = sqrt(line_length);
	double length = line_length / 2;
	SET_MIN(length, arrow_length);
	double ratio = length / line_length;
	double x0 = (x * cos_value - y * sin_value) * ratio;
	double y0 = (y * cos_value + x * sin_value) * ratio;
	double x1 = (x * cos_value + y * sin_value) * ratio;
	double y1 = (y * cos_value - x * sin_value) * ratio;
	SET_POINT(dp0,
		   (int) (x0 + (double) POINT_X(dp1)),
		   (int) (y0 + (double) POINT_Y(dp1)));
	draw_line(dc, dp0, dp1);
	SET_POINT(dp0,
		   (int) (x1 + (double) POINT_X(dp1)),
		   (int) (y1 + (double) POINT_Y(dp1)));
	draw_line(dc, dp0, dp1);
      }
    }
    kill_object(select_object(dc, old_pen));
  }
  if (bk_mode != old_bk_mode)
  {
    ::SetBkMode(dc, old_bk_mode);
  }
  if (foreground != old_foreground)
  {
    set_text_color(dc, old_foreground);
  }
}

// redisplay top-level layout(not panel, not zero-page)
void
LayoutInstance::RedisplayTopLevel(View* view, HRGN region)
{
  current_top_level_layout = this;
  LayoutInstance* zero = this->GetZeroPageLayout();
  global_brush_org_rect->left = view->DunitX(zero->GetLX());
  global_brush_org_rect->top = view->DunitY(zero->GetLY());
  
  assert(zero != NULL && zero != this);
  
  Lrect zero_lrect[1];
  RECT zero_rect[1];
  zero->get_lrect(zero_lrect);
  view->lrect_to_drect(zero_lrect, CastWindowsRECTToDrect(zero_rect));
  
  if (rect_in_region(region, zero_rect))
  {
    HDC dc = view->GetDC();
    
    HRGN zero_region = create_rect_region(zero_rect);
    combine_region(zero_region, zero_region, region, RGN_AND);
    int zero_region_empty_p = False;
    
    Lrect this_lrect[1];
    RECT this_rect[1];
    this->get_lrect(this_lrect);
    view->lrect_to_drect(this_lrect, CastWindowsRECTToDrect(this_rect));
    
    if (rect_in_region(zero_region, this_rect))
    {
      HRGN this_region = create_rect_region(this_rect);
      combine_region(this_region, this_region, zero_region, RGN_AND);
      
      zero_region_empty_p = (combine_region(zero_region,
					     zero_region,
					     this_region, RGN_DIFF)
			     == NULLREGION);
      
      select_object(dc, this_region);
      this->Redisplay(view, this_region, BLACK);
      kill_object(this_region);
    }
    if (!zero_region_empty_p)
    {
      select_object(dc, zero_region);
      if (this->visible_zero_page && 
	  zero->visible_zero_page && 
	  (GetDocumentContent()->GetLogicalPageNum(this) 
	  >= GetDocumentContent()->GetZeroDisplayStartPage()))
      {
	GetZeroPageLayout();	// update zero_mapped_layout
	current_top_level_layout = this;
	zero->Redisplay(view, zero_region, BLACK);
      }
      else
      {
	::FillRgn(dc, zero_region, Screen::stocked_white_brush);
      }
    }
    kill_object(zero_region);
    select_object(dc, region);
  }
}

// layout panel
Panel* 
LayoutInstance::GetPanel()
{
  return lt->IsTable() ? ((Table*)page_map)->GetPanel() : 0;
}


// --- header and footer --------------------------------------------

// get zero page layout from normal layout
LayoutInstance* 
LayoutInstance::GetZeroPageLayout()
{
  this->SetZeroMappedLayout(NULL);
  if (this->lt->IsTable())
  {
    return(NULL);
  }
  if (this->lt->IsZeroPage())
  {
    return(this);
  }
  this->SetZeroMappedLayout(this);
  PageSize* ps = (page_map->GetDocumentContent())->GetPageSize();
  ps->SetLayoutPosition(lpos_x, lpos_y);
  return(ps->GetLayout());
}

// get zero page layout from normal layout(maybe)
LayoutInstance* 
LayoutInstance::GetMaybeZeroPageLayout()
{
  LayoutInstance* layout = this->GetZeroPageLayout();
  return(layout == NULL ? this : layout);
}

// ------------------------------------------------------------
// vanishing unused layout

// check unused layout
void 
LayoutInstance::CheckUnused(LayoutInstance* li)
{
  PageMap::KillUnusedLayout(li);
}

// used check
bool 
LayoutInstance::IsUsed()
{
  uword gate_size = page_map->GetGateSize();
  if (gate_size == 0) 
  {
    // picture or fillframe
    return True;
  }
  
  for (uword gate = 1; gate <= gate_size; gate++) 
  {
    FrameInstance* fi = GetGateFrame(gate);
    if (fi != 0) 
    {
      if (!fi->EraseableFrameP()) 
      {
	// this layout is used now.
	return True;
      }
    }
  }
  // this layout is unused now.
  return False;
}
