// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutin.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// LayoutInstance class
// A LayoutInstance speaks of specific pages(or page groups) of a document.
// LayoutInstances contain a variable set of FrameInstances of the
// Frames defined by the FrameTemplates of the begetting LayoutTemplate.

#ifndef LAYOUTIN_H
#define LAYOUTIN_H

#include "layoutte.h"
#include "view.h"

class LayoutInstance
{
private:
  // page mapping and text-flow mapping info.
  // layout-inctance is generated by page-map.
  PageMap* page_map;
  
  // layout static info
  LayoutTemplate* lt;
  
  // double-list defining the document. Others in chain need not be of the
  // same template, however.
  LayoutInstance* prev_li;
  LayoutInstance* next_li;
  
  // single thl. of known frameinstance's
  FrameInstance* first_fi;
  FrameInstance* last_fi;
  
  // layout logical position x
  Lunit lpos_x;
  
  // layout logical position y
  Lunit lpos_y;
  
  // flag of zero page(header, footer) visible control
  bool visible_zero_page;
  
  // page-map page number
  uword pmpn;
  
private:
  static LayoutInstance* zero_mapped_layout;
  
public:
  static LayoutInstance* 
  GetZeroMappedLayout()
  {
    return(LayoutInstance::zero_mapped_layout);
  }
  
  static void
  SetZeroMappedLayout(LayoutInstance* foo)
  {
    LayoutInstance::zero_mapped_layout = foo;
  }

  // ------------------------------
  // page map interface

private:
#ifdef PAGEMAP_H
  // Only next two functions can call the layout-instance 
  // constructor and destructor
  friend LayoutInstance* PageMap::GenerateNPage(uword n);
  friend void PageMap::VanishNPage(uword n);
#endif
  
  // constructor, create layout instance
  // * This method links to layout chain, create frame-instacnes 
  // and pipe the text-flow.
  // pm		: page map info.
  // prev		: previous layout-instance. 0 is possible, 
  //                     it meens document first layout-instance
  LayoutInstance(PageMap* pm, LayoutInstance* prev);
  
  // destructor
  // * This method never care the text-flow pipe, only unlink 
  // from the layout chain and delete all frame-instances. 
  // Managements of the text-flow pipe shuld be done befor call.
  ~LayoutInstance();
  
  // make one page frame-instances
  // this creates frame-instance according to it template.
  void MakeFrameInstances();
  
  // call befor destructor
  void PrepareToDie();
  
public:
  // get page map
  // return	: assigned page map
  PageMap* GetPageMap() 
  {
    return page_map; 
  }
  
  // which text-flow ?
  // fi	: search frame-instance
  // return	: assigned text-flow
  TextFlow* GetAssignedTextFlow(FrameInstance* fi);
  
  // set page map
  void SetPageMap(PageMap* pm) 
  {
    page_map = pm; 
  }
  
  // get page map page-number
  uword GetPageMapPageNumber() 
  {
    return pmpn; 
  }
  
  // set page map page-number
  void SetPageMapPageNumber(uword n) 
  {
    pmpn = n; 
  }
  
  // ------------------------------
  // redisplay

public:
  void RedisplayTopLevel(View* view, HRGN region);
  void Redisplay(View* view, HRGN region, DWORD line_color);
  
  // ------------------------------

  // next 4 methods are frame-instance management functions.
  // get first frame-instance(lfi link)
  FrameInstance* GetFirstFrame() 
  {
    return first_fi; 
  }
  
  // set first frame-instance(lfi link)
  void SetFirstFrame(FrameInstance* fi) 
  {
    first_fi = fi; 
  }
  
  // get last frame-instance(lfi link)
  FrameInstance* GetLastFrame() 
  {
    return last_fi;
  }
  
  // set last frame-instance(lft link)
  void SetLastFrame(FrameInstance* fi) 
  {
    last_fi = fi;
  }
  
  // get next layout-instance
  // it returns sequence order layout
  LayoutInstance* GetNextLayout();
  
  // get previous layout-instance
  // it returns sequence reverse order layout
  LayoutInstance* GetPrevLayout();
  
  // get previous layout in page-map
  LayoutInstance* GetPrevPageMapLayout() 
  {
    return prev_li; 
  }
  
  // get next layout in page-map
  LayoutInstance* GetNextPageMapLayout() 
  {
    return next_li; 
  }
  
  // find frame-instance by frame-template
  FrameInstance* FindFIByFT(FrameTemplate* ft);
  
  // find gate frame-instance by text-flow
  FrameInstance* GetGateFI(TextFlow* tf);
  
  // get exit frame-instance in this layout-instance
  FrameInstance* GetExitFI(TextFlow* tf);
  
  // get gate frame-instance by gate index
  FrameInstance* GetGateFrame(uword index);
  
  // clear previous layout in page-map
  void ClearPrevPageMapLayout() 
  {
    prev_li = 0;
  }
  
  // clear next layout in page-map
  void ClearNextPageMapLayout() 
  {
    next_li = 0;
  }
  
  // get layout template
  LayoutTemplate* GetLayoutTemplate() 
  {
    return lt;
  }
  
  LayoutTemplate* GetTemplate() 
  {
    return lt;
  }
  
  // get document content
  DocumentContent* GetDocumentContent();
  
  // get document
  Document* GetDocument();
  
  // get document presentation
  DocumentPresentation* GetDocumentPresentation();
  
  // get layout logical position x
  Lunit GetLX() 
  {
    return lpos_x;
  }
  
  // get layout logical position y
  Lunit GetLY() 
  {
    return lpos_y;
  }
  
  // * next two member fuctions are called only from
  // void DocumentPresentation::RecalcAllLayoutLunit()
  // set layout logical posision x
  void SetLX(Lunit x) 
  {
    lpos_x = x;
  }
  
  // set layout logical posision y
  void SetLY(Lunit y) 
  {
    lpos_y = y;
  }
  
  void FixPosition();
  void FixPosition(DocumentWindow* window);
  
  // get width
  Iunit GetWidth() 
  { return lt->GetWidth(); }
  
  // get height
  Iunit GetHeight() 
  { return lt->GetHeight(); }
  
  bool
  IsTable()
  {
    return(this->lt->IsTable());
  }
  
  FrameInstance* navigate_frame1(Lpoint* lp);
  Panel* GetPanel();
  void Invalidate();
  void get_lpoint(Lpoint* lp);
  void get_lrect(Lrect* lr);
  void get_zero_page_lrect(Lrect* rect);
  void ipoint_to_lpoint(Ipoint* ip, Lpoint* lp);
  void irect_to_lrect(Irect* ir, Lrect* lr);
  void lpoint_to_ipoint(Lpoint* lp, Ipoint* ip);

  // ------------------------------
  // header and footer

public:
  // check zero page layout
  //bool IsZeroPageLayout();
  
  // get zero page layout from normal layout
  LayoutInstance* GetZeroPageLayout();
  LayoutInstance* GetMaybeZeroPageLayout();
  
  bool
  VisibleZeroPage()
  {
    return(this->visible_zero_page);
  }
  
  void
  SetVisibleZeroPage(bool visible_zero_page)
  {
    this->visible_zero_page = visible_zero_page != 0;
  }
  
  // ------------------------------
  // vanishing unused layout
  
  // check unused layout
  static void CheckUnused(LayoutInstance* li);
  
  // used check
  // return		: True   this frame is used now.
  //			: False  this frame is unused now.
  bool IsUsed();
};

#endif /* LAYOUTIN_H */
