// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutte.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// LayoutTemplate class
// A LayoutTemplate talks about how a certain kind of page or
// page-group is laid out, that is, what Frame(Templates) it contains.

#include "pword.h"
#include "ftlist.h"
#include "document.h"
#include "docconte.h"
#include "fission.h"
#include "fissioni.h"
#include "editfram.h"
#include "layoutte.h"
#include "layoutin.h"
#include "frametem.h"
#include "frameins.h"
#include "unknowno.h"
#include "objectid.h"
#include "lman.h"
#include "allayout.h"
#include "pstreams.h"
#include "borderli.h"
#include "blueprin.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

// copy constructor, for layout definition
LayoutTemplate::LayoutTemplate(DocumentContent* doc, LayoutTemplate* lt, char* name)
{
  ref_count = 0;
  kind = lt->kind;
  LayoutTemplate::doc = doc;
  first_ft = 0;
  gate_list = new FTList();
  BluePrint* bp = new BluePrint(lt->GetFissionFrame());
  ff = bp->Produce(this);
  delete bp;
  Vector size = ff->GetSize();
  width = size.x;
  height = size.y;
  layout_name[0] = '\0';
  SetLayoutName(name);
  doc_name = False;
  if (kind == RegularTemplate) 
  {
    LayoutManager::AddLayout(this);
  }
}

// constructor
LayoutTemplate::LayoutTemplate(DocumentContent* doc, BluePrint* bp, Kind k
				,char* name)
{
  ref_count = 0;
  kind = k;
  LayoutTemplate::doc = doc;
  first_ft = 0;
  gate_list = new FTList();
  ff = bp->Produce(this);
  Vector size = ff->GetSize();
  width = size.x;
  height = size.y;
  layout_name[0] = '\0';
  SetLayoutName(name);
  doc_name = False;
  if (kind == RegularTemplate) 
  {
    LayoutManager::AddLayout(this);
  }
}

// desutructor
LayoutTemplate::~LayoutTemplate()
{
  // frame editor report
  doc->GetDocument()->GetEditFrame()->ReportBreakLayout(this);
  
  // remove from menu
  if (kind == RegularTemplate) 
  {
    LayoutManager::ReportInactiveLayout(this);
  }
  
  // delete frame-template
  while (first_ft != 0) 
  {
    delete first_ft;
  }
}

// kill all frames
void 
LayoutTemplate::KillAllFrames()
{
  // delete frame-template
  while (first_ft != 0) 
  {
    delete first_ft;
  }
}

// decrement reference count
void 
LayoutTemplate::DecRefCount()
{
  if (--ref_count == 0) 
  {
    delete this;
  }
}

// add frame template
// return		: previous first_ft
FrameTemplate* 
LayoutTemplate::AddFrameTemplate(FrameTemplate* ft)
{
  FrameTemplate* ret = first_ft;
  first_ft = ft;
  return ret;
}

// remove frame-template
void 
LayoutTemplate::RemoveFrameTemplate(FrameTemplate* ft)
{
  if (ft == first_ft) 
  {
    first_ft = first_ft->GetNextFT();
  }
  else 
  {
    for (FrameTemplate* prev = first_ft; 
	 prev != 0; 
	 prev = prev->GetNextFT()) 
    {
      if (prev->GetNextFT() == ft) 
      {
	prev->SetNextFT(ft->GetNextFT());
	break;
      }
    }
  }
  RemoveFromPipe(ft);
}

// remove from pipe
void 
LayoutTemplate::RemoveFromPipe(FrameTemplate* ft)
{
  uword n = GetGateNumber(ft);
  if (n != 0) 
  {
    if (ft->GetNextTFFT() != 0) 
    {
      ReplaceGate(n, ft->GetNextTFFT());
    }
    else 
    {
      RemoveGate(n);
    }
  }
  else 
  {
    n = WhichGateFT(ft);
    // unlink next_tfft
    for (FrameTemplate* prev = GetGateFT(n);
	 prev != 0;
	 prev = prev->GetNextTFFT()) 
    {
      if (prev->GetNextTFFT() == ft) 
      {
	prev->SetNextTFFT(ft->GetNextTFFT());
	break;
      }
    }
  }
}


// FrameOwn virtual function interface.

// update template.
void 
LayoutTemplate::UpDate()
{
  ;
}

// cerate new flow gate
FrameObject* 
LayoutTemplate::CreateNewGate(CrossPoint* cp)
{
  // create frame, create new gate
  FrameTemplate* ft = new FrameTemplate(this, cp);
  return ft;
}

// create new flow
FrameObject* 
LayoutTemplate::CreateNewFlow(CrossPoint* cp)
{
  FrameTemplate* ft = (FrameTemplate*)CreateNewGate(cp);
  FI_CreateFrameTemplate(0, ft);
  return ft;
}

// update fission frame size
void 
LayoutTemplate::UpdateSize()
{
  // update layout template size.
  Vector size = ff->GetSize();
  width = size.x;
  height = size.y;
}


// gate interface

// gate size
uword 
LayoutTemplate::GetGateSize()
{
  return gate_list->Number();
}

// gate number
uword 
LayoutTemplate::GetGateNumber(FrameTemplate* ft)
{
  return gate_list->Search(ft);
}

// which gate frame-template
uword 
LayoutTemplate::WhichGateFT(FrameTemplate* ft)
{
  FTListIterator ftli(gate_list);
  FrameTemplate* f;
  uword n = 1;
  while ((f = ftli()) != 0) 
  {
    do 
    {
      if (f == ft) 
      {
	return n;
      }
    } while ((f = f->GetNextTFFT()) != 0);
    n++;
  }
  return 0;
}

// check gate frame
bool 
LayoutTemplate::IsGateFT(FrameTemplate* ft)
{
  FTListIterator ftli(gate_list);
  FrameTemplate* ift;
  while ((ift = ftli()) != 0) 
  {
    if (ift == ft) 
    {
      return True;
    }
  }
  return False;
}

// get gate frame template
FrameTemplate* 
LayoutTemplate::GetGateFT(uword n)
{
  return gate_list->Access(n);
}

// add gate
void 
LayoutTemplate::AddGate(FrameTemplate* ft)
{
  gate_list->Inject(ft);
}

// remove
void 
LayoutTemplate::RemoveGate(uword n)
{
  gate_list->Delete(n);
}

// replace
void 
LayoutTemplate::ReplaceGate(uword n, FrameTemplate* new_ft)
{
  if (n != 0) 
  {
    gate_list->Replace(n, new_ft);
  }
}

char* 
LayoutTemplate::GetLayoutName()
{
  return layout_name;
}

// set layout name
void 
LayoutTemplate::SetLayoutName(char* name)
{
  if (name == 0) 
  {
    layout_name[0] = '\0';
    return;
  }
  doc_name = False;
  copy_string(layout_name, name, LayoutNameSize + 1);
}

// save
void 
LayoutTemplate::WriteToStream(PStream* stream)
{
  // save header and version
  stream->StartBlockOut(PStream::HDR_LAYOUT, save_version);
  CHECK;
  
  // save blue print
  BluePrint* bp = new BluePrint(GetFissionFrame());
  bp->Save(stream);
  delete bp;
  
  // save layout template kind
  stream->OutUWord(kind);
  CHECK;
  
  // save layout template name
  stream->OutString(layout_name);
  CHECK;
  
  // save document name flag
  stream->OutUWord(doc_name);
  CHECK;
  
  stream->EndBlockOut();
}

// load
LayoutTemplate* 
LayoutTemplate::ReadFromStream(PStream* stream, 
				DocumentContent* doc)
{
  // load header and version
  word version;
  stream->StartTypedBlockIn(PStream::HDR_LAYOUT, version); 
  CHECK 0;
  
  // load blue print
  BluePrint* bp = new BluePrint();
  bp->Load(stream); CHECK 0;
  
  // get layout template kind
  Kind k = (Kind)stream->InUWord();
  CHECK 0;
  
  // make layout template by bluepint
  LayoutTemplate* lt = new LayoutTemplate(doc, bp, k, "Dummy");
  delete bp;
  
  // get layout name
  if (version == old_namelen_save_version)
  {
    stream->In(lt->layout_name, OldLayoutNameSize);
  }
  else
  {
    assert(version == save_version);
    char* name = stream->InString();
    if (name)
    {
      copy_string(lt->layout_name, name, LayoutNameSize + 1);
    }
    delete name;
  }
  CHECK 0;
  
  // get document name flag
  lt->doc_name = (bool)(stream->InUWord() != 0);
  CHECK 0;
  
  stream->EndBlockIn();
  return lt;
}

// readed layout check
bool 
LayoutTemplate::ConfirmReadAll()
{
  // scan all frame object
  SuperFrameObject* so = GetNilFrameObject();
  SuperFrameObject* nil = so;
  while ((so = so->GetNext()) != nil) 
  {
    FrameObject* fo = (FrameObject*)so;
    if (fo->GetObjectID() == IDUnknownObject) 
    {
      UnknownObject* uo = (UnknownObject*)fo;
      if (uo->GetError()) 
      {
	return False;
      }
    }
  }
  return True;
}

// get proper virtical border
uword 
LayoutTemplate::GetProperVBorder(CrossPoint* cp, uword index)
{
  if (index == 0) 
  {
    return 0;
  }
  VFission* v = cp->GetVFission();
  CrossPoint* cp_start = v->GetStartCrossPoint();
  if (cp_start->GetKind() == CrossPoint::LStart) 
  {
    // left rim fission
    return BorderLine::ForceAlignment(index, BorderLine::AlignRight);
  }
  else if (cp_start->GetKind() == CrossPoint::RStart) 
  {
    // right rim fission
    return BorderLine::ForceAlignment(index, BorderLine::AlignLeft);
  }
  if (IsZeroPage()) 
  {
    AllLayout* al = doc->GetAllLayout();
    if (al) 
    {
      Fission* top;
      Fission* bottom;
      Fission* left;
      Fission* right;
      al->GetMarginFission(&top, &bottom, &left, &right);
      if (v == left) 
      {
	return BorderLine::ForceAlignment(index, BorderLine::AlignLeft);
      }
      else if (v == right) 
      {
	return BorderLine::ForceAlignment(index, BorderLine::AlignRight);
      }
    }
  }
  return index;
}

// get proper horizontal border
uword 
LayoutTemplate::GetProperHBorder(CrossPoint* cp, uword index)
{
  if (index == 0) 
  {
    return 0;
  }
  HFission* h = cp->GetHFission();
  CrossPoint* cp_start = h->GetStartCrossPoint();
  if (cp_start->GetKind() == CrossPoint::TStart) 
  {
    // top rim fission
    return BorderLine::ForceAlignment(index, BorderLine::AlignBelow);
  }
  else if (cp_start->GetKind() == CrossPoint::BStart) 
  {
    // right rim fission
    return BorderLine::ForceAlignment(index, BorderLine::AlignAbove);
  }
  if (IsZeroPage()) 
  {
    AllLayout* al = doc->GetAllLayout();
    if (al) 
    {
      Fission* top;
      Fission* bottom;
      Fission* left;
      Fission* right;
      al->GetMarginFission(&top, &bottom, &left, &right);
      if (h == top) 
      {
	return BorderLine::ForceAlignment(index, BorderLine::AlignAbove);
      }
      else if (h == bottom) 
      {
	return BorderLine::ForceAlignment(index, BorderLine::AlignBelow);
      }
    }
  }
  return index;
}
