// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: line.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// line

#include "pword.h"
#include "line.h"
#include <stddef.h>
#include "attribut.h"
#include "borderli.h"
#include "rats.h"
#include "docconte.h"
#include "sjis.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "panel.h"
#include "vtextpnl.h"
#include "pref.h"
#include "bufnew.h"
#include "textflow.h"
#include "rect.h"
#include "view.h"

DEFINE_SMARTNEW(Line)

LayoutInstance* current_top_level_layout;

Line::Line(FrameInstance* frame, BP* bp)
{
  this->frame = frame;
  this->prev = this;
  this->next = this;
  this->first_bp = (bp == NULL ? NULL : new BP(bp));
  this->num_chars = 0;
  this->num_shadow_chars = 0;
  this->num_drawing_chars = 0;
  this->y = 0;
  this->top_border = 0;
  this->bot_border = 0;
  this->ascent = 0;
  this->descent = 0;
  this->top_x = 0;
  this->sub->num_drawing_chars = 0;
  this->sub->bot_x = 0;
  this->sub->chain = NULL;
  this->cache_index = 0;
  this->format_needed_p = True;
  this->force_redisplay_p = True;
  this->has_special_p = False;
  this->has_page_no_p = False;
  this->end_of_buffer_p = False;
  this->shadow_p = False;
  this->border_changed_p = False;
}

// Destructor unlinks myself.
Line::~Line()
{
  this->Uncache();
  this->DeleteSubLines();
  // unlink myself
  Line* prev = this->prev;
  (prev->next = this->next)->prev = prev;
  delete this->first_bp;
}

Line* 
Line::MakeInstance(FrameInstance* frame, BP* bp)
{
  return(new Line(frame, bp));
}

void
Line::KillInstance(Line* line)
{
  delete line;
}

Iunit
Line::GetBotX()
{
  SubLine* sub = this->sub;
  SubLine* next;
  while ((next = sub->chain) != NULL)
  {
    sub = next;
  }
  return(sub->bot_x);
}

void NEAR
Line::DeleteSubLines()
{
  SubLine* sub = this->sub->chain;
  while (sub != NULL)
  {
    SubLine* chain = sub->chain;
    delete sub;
    sub = chain;
  }
  this->sub->chain = NULL;
}

void
Line::LinkToPrev(Line* next)
{
  Line* prev = next->prev;
  this->prev = prev;
  this->next = next;
  prev->next = this;
  next->prev = this;
}

// This method unlink and delete from next line to last.
// `ReportLast' means `this' is last line in frame.
void
Line::ReportLast()
{
  for (;;)
  {
    Line* next = this->GetNextImmediately();
    if (next->NilP())
    {
      break;
    }
    assert(next != this);
    delete next;
  }
}

LayoutInstance* 
Line::GetLayout()
{
  return((this->GetFrame())->GetLayout());
}

Line* 
Line::GetPrev()
{
  Line* line = this->prev;
  return(line->NilP() ? NULL : line);
}

Line* 
Line::GetNext()
{
  Line* line = this->next;
  return((line->NilP() || line->GetShadowP()) ? NULL : line);
}

Line* 
Line::XGetPrev()
{
  Line* line = this->prev;
  while (line->NilP())
  {
    FrameInstance* frame = line->frame->GetPrevTextFrame();
    if (frame == NULL)
    {
      break;
    }
    line = frame->GetLines();
    for (;;)
    {
      line = line->prev;
      if (line->NilP() || !line->GetShadowP())
      {
	break;
      }
    }
  }
  return(line);
}

Line* 
Line::XGetNext()
{
  Line* line = this;
  while ((line = line->next)->NilP() || line->GetShadowP())
  {
    FrameInstance* frame = line->frame->GetNextTextFrame();
    if (frame == NULL)
    {
      frame = line->frame;
      line = frame->GetLines();
      if (frame->EndOfTextP() || (frame = frame->EnsureNextTFI()) == NULL)
      {
	break;
      }
    }
    if (frame->FormatNeededP())
    {
      frame->Format(True);
    }
    line = frame->GetLines();
  }
  return(line);
}

void
Line::set_panel_position_by_lpoint(Panel* panel, Lpoint* lp)
{
  Lpoint panel_lp[1];
  *panel_lp = *lp;
  if (!(this->GetFirstBP() ->GetTextFlow() ->tategaki_flow_p()))
  {
    POINT_Y(panel_lp) -= panel->GetHeight();
  }
  panel->SetPanelPosition(POINT_X(panel_lp), POINT_Y(panel_lp));
}

void
Line::set_panel_position_by_line_x(Panel* panel, Iunit line_x)
{
  Ipoint ip[1];
  Lpoint lp[1];
  SET_POINT(ip, line_x, this->GetBaseLineY());
  FrameInstance* frame = this->GetFrame();
  frame->line_point_to_ipoint(ip);
  frame->GetLayout() ->ipoint_to_lpoint(ip, lp);
  this->set_panel_position_by_lpoint(panel, lp);
}

void
Line::navigate_bp(Lpoint* lp, BP* bp, LayoutInstance** layout_return)
{
  if (layout_return != NULL)
  {
    *layout_return = NULL;
  }
  if (this != NULL)
  {
    FrameInstance* frame = this->GetFrame();
    Lrect frame_lr[1];
    frame->get_lrect(frame_lr);
    Lpoint fixed_lp[1];
    Lunit lx = POINT_X(lp);
    SET_BOUND(lx, RECT_TOP_X(frame_lr), RECT_BOT_X(frame_lr));
    POINT_X(fixed_lp) = lx;
    Lunit ly = POINT_Y(lp);
    SET_BOUND(ly, RECT_TOP_Y(frame_lr), RECT_BOT_Y(frame_lr));
    POINT_Y(fixed_lp) = ly;
    int index_x = this->GetFirstBP() ->GetTextFlow() ->get_index_x();
    Iunit x = (Iunit) (POINT_UNIT(fixed_lp, index_x)
		       - RECT_UNIT(frame_lr, INDEX_TOP, index_x));
    LineCharInfo* info = this->GetInfo();
    int num_drawing_chars = this->num_drawing_chars;
    int n;
    for (n = 0; n <= num_drawing_chars; ++n)
    {
      if (x <= info[n].x)
      {
	break;
      }
    }
    if (n != 0)
    {
      --n;
    }

    if (layout_return != NULL && n < num_drawing_chars)
    {
      sjis ch = info[n].ch;
      if (IsPanel(ch))
      {
	Panel* panel = (frame
			->GetLayout()
			->GetDocumentContent()
			->GetPanel(GetSpecialCode(ch)));
	if (panel != NULL)
	{
	  LayoutInstance* panel_layout = panel->GetLayout();
	  if (panel_layout != NULL)
	  {
	    this->set_panel_position_by_line_x(panel, info[n].x);
	    Lrect panel_lr[1];
	    panel_layout->get_lrect(panel_lr);
	    if (lrect_insidep(panel_lr, lp))
	    {
	      *layout_return = panel_layout;
	    }
	  }
	}
      }
    }
    
    if (n < num_drawing_chars)
    {
      if ((info[n].x + info[n + 1].x) / 2 < x)
      {
	++n;
      }
    }
    
    if (bp != NULL)
    {
      bp->Set(this->first_bp);
      bp->Add(info[n].i);
    }
    
    this->ReleaseInfo(info);
  }
}

BP* 
Line::GetBPAtXCreate(Lunit x)
{
  LineCharInfo* info = this->GetInfo();
  Iunit target_x = (int) (x - (this->GetLayout())->GetLX());
  int num_drawing_chars = this->num_drawing_chars;
  int n;
  for (n = 0; n <= num_drawing_chars; ++n)
  {
    if (target_x < info[n].x)
    {
      break;
    }
  }
  if (n != 0)
  {
    --n;
  }
  if (n < num_drawing_chars)
  {
    if ((info[n].x + info[n + 1].x) / 2 < target_x)
    {
      ++n;
    }
  }
  
  BP* result = new BP(this->first_bp);
  result->Add(info[n].i);
  this->ReleaseInfo(info);
  return(result);
}

// public method
void
Line::calc_margin(Iunit line_top,
		   Iunit line_bot,
		   Iunit* first_top_ret, Iunit* top_ret, Iunit* bot_ret)
{
  int* para_atts = get_atts(this->first_bp->GetParagraph() ->GetAtts());
  Iunit top = line_top + para_atts[PA_secondleftmargin];
  Iunit bot = line_bot - para_atts[PA_rightmargin];
  SET_BOUND(top, line_top, line_bot);
  SET_BOUND(bot, line_top, line_bot);
  if (bot < top)
  {
    top = bot = (top + bot) / 2;
  }
  Iunit first_top = top + para_atts[PA_firstleftmargin];
  SET_BOUND(first_top, line_top, bot);
  *first_top_ret = first_top;
  *top_ret = top;
  *bot_ret = bot;
}

// private method
#ifdef _WIN32
Iunit NEAR
Line::CalcIndent(Iunit* top_x_return, Iunit* bot_x_return)
#else /* _WIN32 */
Iunit NEAR
Line::CalcIndent(int* top_x_return, int* bot_x_return)
#endif /* _WIN32 */
{
  BP* first_bp = this->first_bp;
#ifdef _WIN32
  int* para_atts = get_atts(first_bp->GetParagraph() ->GetAtts());
  Iunit top_x = *top_x_return;
  Iunit bot_x = *bot_x_return;
  Iunit top = top_x + (Iunit)para_atts[PA_secondleftmargin];
  Iunit bot = bot_x - (Iunit)para_atts[PA_rightmargin];
#else /* _WIN32 */
  int* para_atts = get_atts(first_bp->GetParagraph() ->GetAtts());
  int top_x = *top_x_return;
  int bot_x = *bot_x_return;
  int top = top_x + para_atts[PA_secondleftmargin];
  int bot = bot_x - para_atts[PA_rightmargin];
#endif /* _WIN32 */
  top = MAX(top, top_x);
  top = MIN(top, bot_x);
  bot = MAX(bot, top_x);
  bot = MIN(bot, bot_x);
  if (bot < top)
  {
    top = bot = (top + bot) / 2;
  }
#ifdef _WIN32
  Iunit tab_base = top;
#else /* _WIN32 */
  int tab_base = top;
#endif /* _WIN32 */
  if (first_bp->BeginningOfBufferP())
  {
#ifdef _WIN32
    top += (Iunit)para_atts[PA_firstleftmargin];
#else /* _WIN32 */
    top += para_atts[PA_firstleftmargin];
#endif /* _WIN32 */
    top = MAX(top, top_x);
    top = MIN(top, bot);
  }
  *top_x_return = top;
  *bot_x_return = bot;
  return(tab_base);
}

void
Line::calc_margin_irects(Irect* first_ir, Irect* ir)
{
  Irect r[1];
  FrameInstance* frame = this->frame;
  frame->get_drawing_irect(r);
  int index_x = this->GetFirstBP() ->GetTextFlow() ->get_index_x();
  Iunit first_top;
  Iunit top;
  Iunit bot;
  this->calc_margin(RECT_UNIT(r, INDEX_TOP, index_x),
		     RECT_UNIT(r, INDEX_BOT, index_x),
		     &first_top, &top, &bot);
  RECT_UNIT(first_ir, INDEX_TOP, index_x) = first_top;
  RECT_UNIT(first_ir, INDEX_BOT, index_x) = bot;
  RECT_UNIT(ir, INDEX_TOP, index_x) = top;
  RECT_UNIT(ir, INDEX_BOT, index_x) = bot;
}

#ifdef _WIN32
Iunit
Line::GetMarginPosOnIunits(Iunit* top_return, Iunit* bot_return)
#else /* _WIN32 */
Iunit
Line::GetMarginPosOnIunits(int* top_return, int* bot_return)
#endif /* _WIN32 */
{
  Irect r[1];
  this->frame->get_drawing_irect(r);
  int index_x = this->GetFirstBP() ->GetTextFlow() ->get_index_x();
  *top_return = RECT_UNIT(r, INDEX_TOP, index_x);
  *bot_return = RECT_UNIT(r, INDEX_BOT, index_x);
  return(this->CalcIndent(top_return, bot_return));
}

// ------------------------------------------------------------
// formatting

// checking integer overflow with this value
#define MAX_LINE_CHARS	(0x4000 / sizeof(LineCharInfo))

// break_table[last_cc][cc] means :
// 0 :		no break
// other :	breakable

struct CharInfo
{
  sjis ch;
  attr attrib;
  int* atts;
  FontMetric* fm;
  CharClass cc;
  Iunit compression;
  int nonbreak;
  Iunit width;
  Iunit ascent;
  Iunit descent;
  Iunit over_ascent;
  Iunit under_descent;
  Iunit overhang;
  int overhang_changed_p;
  int use_kanji_font_p;
};

// maximum metric info
struct FMInfo
{
  Iunit ascent;
  Iunit descent;
  Iunit over_ascent;
  Iunit under_descent;
};

struct FCInfo
{
  CharInfo last[1];
  CharInfo c[1];
  EditText* editor;
  int index;
  FMInfo m;
};

enum FLType
{
  FL_SPACE,
  FL_NORMAL,
  FL_TAB,
  FL_END,
};

struct FLInfo
{
  FLType type;
  int first_index;
  int end_index;
  int num_chars;
  int top;
  int width;
  FMInfo m;
  FLInfo* chain;
};

static LayoutInstance* STATIC_NEAR f_top_level_layout;
static FrameInstance* STATIC_NEAR f_frame;
static int STATIC_NEAR f_tategaki_flow_p;
static int STATIC_NEAR f_index_x;
static int STATIC_NEAR f_index_y;
#define f_index_width f_index_x
#define f_index_height f_index_y

static void NEAR
f_set_frame(Line* line)
{
  f_top_level_layout = NULL;
  f_frame = line->GetFrame();
  f_tategaki_flow_p = (line
		       ->GetFirstBP() ->GetTextFlow() ->tategaki_flow_p());
  f_index_x = f_tategaki_flow_p ? INDEX_Y : INDEX_X;
  f_index_y = REVERSED_INDEX(f_index_x);
}

static FCInfo STATIC_NEAR fc;
static FLInfo* STATIC_NEAR fl_list;
static FLInfo* STATIC_NEAR fl_end;
static FLInfo* STATIC_NEAR fl_visible_end;
static FLInfo STATIC_NEAR fl;
static FLInfo STATIC_NEAR fl0;
static FLInfo STATIC_NEAR fl1;

static int STATIC_NEAR f_emptyp;
static int STATIC_NEAR f_has_border_p;
static int STATIC_NEAR f_has_special_p;
static int STATIC_NEAR f_has_page_no_p;
static Iunit STATIC_NEAR f_top;
static Iunit STATIC_NEAR f_bot;
static Iunit STATIC_NEAR f_tab_base;
static Iunit STATIC_NEAR f_tab_size;
static int STATIC_NEAR f_last_active_tab_style;
static int STATIC_NEAR f_last_tab_style;
static int STATIC_NEAR f_num_visible_chars;
static int STATIC_NEAR f_count_down;

static int STATIC_NEAR f_vtextp;
static int STATIC_NEAR f_vtext_page_no_p;
static int STATIC_NEAR f_vtext_index;
static sjis* STATIC_NEAR f_vtext_string;

static int STATIC_NEAR default_atts[16] = {0};

static void NEAR
static_empty()
{
  f_vtextp = False;
  fc.c->ch = EOB;
  fc.c->attrib = 0;
  fc.c->atts = default_atts;
  fc.c->fm = NULL;
  fc.c->cc = CharClass_RANDOM_PUNCT;
  fc.c->compression = 0;
  fc.c->nonbreak = False;
  fc.c->width = 0;
  fc.c->ascent = 0;
  fc.c->descent = 0;
  fc.c->overhang = 0;
  fc.c->overhang_changed_p = False;
  fc.c->over_ascent = 0;
  fc.c->under_descent = 0;
  fc.c->use_kanji_font_p = False;
}

static void NEAR
static_fill()
{
  int refillp = False;
  
  *fc.last = *fc.c;
  
 retry_for_vtext:
  if (f_vtextp)
  {
    ++f_vtext_index;
    fc.c->ch = *f_vtext_string++;
    if (fc.c->ch == EOB)
    {
      f_vtextp = False;
      refillp = True;
      goto retry_for_vtext;
    }
  }
  else
  {
    ++fc.index;
    fc.editor->GetCharInfo(fc.index, &fc.c->ch, &fc.c->attrib);
  }
  for (;;)
  {
    fc.c->cc = ::GetCharClass(fc.c->ch);
    fc.c->use_kanji_font_p = USE_KANJI_FONT(fc.c->ch);
    fc.c->overhang_changed_p = False;
    if (fc.c->ch != EOB)
    {
      if (refillp
	  || IsPanel(fc.last->ch)
	  || fc.last->attrib != fc.c->attrib
	  || fc.last->use_kanji_font_p != fc.c->use_kanji_font_p)
      {
	refillp = False;
	
	int* atts = get_atts(fc.c->attrib);
	fc.c->atts = atts;
	
	if (atts[CA_hidden] && !Pref_show_hidden_text)
	{
	  attr attrib = fc.c->attrib;
	  do
	  {
	    ++fc.index;
	    fc.editor->GetCharInfo(fc.index, &fc.c->ch, &fc.c->attrib);
	  } while (fc.c->ch != EOB && fc.c->attrib == attrib);
	  continue;
	}
	
	FontMetric* fm = get_font_metric(fc.c->attrib,
					  fc.c->use_kanji_font_p,
					  f_tategaki_flow_p);
	fc.c->fm = fm;
	fc.c->ascent = fm->GetAscent();
	fc.c->descent = fm->GetDescent();
	fc.c->overhang = fm->GetOverhang();
	if (fc.last->overhang != fc.c->overhang
	    || fc.last->ascent != fc.c->ascent
	    || fc.last->descent != fc.c->descent)
	{
	  fc.c->overhang_changed_p = True;
	}
	
	int subscriptness = atts[CA_subscript];
	if (subscriptness != 0)
	{
	  int delta = (fc.c->ascent * subscriptness) / 3;
	  fc.c->ascent += delta;
	  fc.c->descent -= delta;
	}
	
	fc.c->compression = atts[CA_compressed];
	fc.c->nonbreak = atts[CA_unbreakable];
	fc.c->over_ascent = 0;
	fc.c->under_descent = 0;
	int border = atts[CA_lines];
	if (border != 0)
	{
	  BorderLine* b = BorderLine::Get(border);
	  int border_width = b->strict_width(INDEX_HORIZONTAL);
	  if (b->overlinep())
	  {
	    f_has_border_p = True;
	    fc.c->over_ascent = (border_width
				 + mm0_to_iu(Pref_over_char_space));
	  }
	  if (b->underlinep())
	  {
	    f_has_border_p = True;
	    fc.c->under_descent = (border_width
				   + mm0_to_iu(Pref_under_char_space));
	  }
	}
      }
      
      if (!IsPanel(fc.c->ch))
      {
	fc.c->width = fc.c->fm->GetWidth(fc.c->ch);
      }
      else
      {
	Panel* panel = (fc.editor
			->GetDocContent()
			->GetPanel(GetSpecialCode(fc.c->ch)));
	assert(panel != NULL);
	
	if (panel->GetPanelID() == Panel::VTextPanelID)
	{
	  f_vtextp = True;
	  f_vtext_page_no_p = False;
	  VTextPanel* vtpanel = panel->CastToVTextPanel();
	  if ((vtpanel->GetVText())->GetVTextID() == VText::PageNoVTextID)
	  {
	    f_vtext_page_no_p = True;
	    if (f_top_level_layout == NULL)
	    {
	      TextFlow* flow = fc.editor->GetTextFlow();
	      if (flow->OnZeroPageP() || flow->OnTableP())
	      {
		f_top_level_layout = current_top_level_layout;
	      }
	      if (f_top_level_layout == NULL)
	      {
		f_top_level_layout = f_frame->GetLayout();
	      }
	    }
#ifndef NDEBUG
	    if (f_top_level_layout->GetDocumentContent()
		!= f_frame->GetLayout() ->GetDocumentContent())
	    {
	      syserr("static_fill : broken layout");
	    }
#endif
	    int page_no = (f_top_level_layout->GetDocumentContent()
			   ->GetLogicalPageNum(f_top_level_layout));
	    vtpanel->Evaluate(page_no);
	  }
	  f_vtext_index = -1;
	  f_vtext_string = (vtpanel)->GetWideString();
	  assert(f_vtext_string != NULL);
	  refillp = True;
	  goto retry_for_vtext;
	}
	
	fc.c->overhang = 0;
	fc.c->overhang_changed_p = (fc.last->overhang != 0);
	{
	  Ipoint ip[1];
	  POINT_UNIT(ip, INDEX_WIDTH) = panel->GetWidth();
	  POINT_UNIT(ip, INDEX_HEIGHT) = panel->GetHeight();
	  fc.c->width = POINT_UNIT(ip, f_index_width);
	  fc.c->ascent = POINT_UNIT(ip, f_index_height);
	}
	fc.c->descent = 0;
      }
    }
    break;
  }
  if (f_vtextp)
  {
    fc.c->nonbreak = (*f_vtext_string != EOB || fc.c->atts[CA_unbreakable]);
  }
  
  if (fc.last->ch == '\t')
  {
    fc.last->compression = 0;
  }
  
  if (((fc.c->ch & 0xff80U) ^ 0x0080U) == 0
      && 0x00e0 <= fc.c->ch
      && fc.c->fm->GetCharSet() == SHIFTJIS_CHARSET)
  {
    fc.c->ch -= 0x20;
    fc.c->width = fc.c->fm->GetWidth(fc.c->ch);
  }
}

static void NEAR
scan_char()
{
  if (::SpecialP(fc.c->cc))
  {
    f_has_special_p = True;
  }
  if (f_vtextp && f_vtext_page_no_p)
  {
    f_has_page_no_p = True;
  }
  
  static_fill();
  
  if (--f_count_down < 0)
  {
    fc.c->ch = EOB;
    fc.c->cc = CharClass_SPECIAL_SPACE;
  }
  else if (fc.c->ch != EOB)
  {
    SET_MAX(fc.m.ascent, fc.c->ascent);
    SET_MAX(fc.m.descent, fc.c->descent);
    SET_MAX(fc.m.over_ascent, fc.c->over_ascent);
    SET_MAX(fc.m.under_descent, fc.c->under_descent);
  }
}

static void NEAR
add_line(FLInfo* a, FLInfo* b)
{
  if (b->num_chars != 0)
  {
    if (a->num_chars == 0)
    {
      *a = *b;
    }
    else
    {
      if (b->type == FL_NORMAL)
      {
	a->type = FL_NORMAL;
      }
      a->end_index = b->end_index;
      a->num_chars += b->num_chars;
      a->width += b->width;
      a->m = b->m;
    }
  }
}

static void NEAR
register_line_immediately(FLInfo* a)
{
  FLInfo* b = new FLInfo;
  *b = *a;
  b->chain = NULL;
  if (fl_end == NULL)
  {
    fl_list = b;
  }
  else
  {
    fl_end->chain = b;
  }
  fl_end = b;
  if (b->type == FL_NORMAL)
  {
    fl_visible_end = b;
    f_last_active_tab_style = f_last_tab_style;
    f_num_visible_chars += b->num_chars;
  }
}

static void NEAR
register_line(FLInfo* a)
{
  switch (a->type)
  {
   case FL_NORMAL:
   case FL_SPACE:
    if (a->num_chars != 0)
    {
      register_line_immediately(a);
    }
    break;
  }
}

static int NEAR
DecimalCharP(sjis ch)
{
  if ('0' <= ch && ch <= '9')
  {
    return(True);
  }
  if (0x824f <= ch && ch <= 0x8258)
  {
    return(True);
  }
  static sjis* STATIC_NEAR chars = NULL;
  sjis* s = chars;
  if (s == NULL)
  {
    s = chars = jisz_spread(Pref_no_decimal_tab_chars, NULL);
  }
  sjis code;
  while ((code = *s++) != 0)
  {
    if (code == ch)
    {
      return(True);
    }
  }
  return(False);
}

static void NEAR
scan_line(int decimal_end_p)
{
  fl.first_index = fc.index;
  fl.num_chars = 0;
  fl.width = 0;
  if (EndOfLineP(fc.c->cc))
  {
    fl.type = FL_END;
    fl.end_index = fc.index + (fc.c->ch == EOB ? 0 : 1);
    fl.m = fc.m;
    return;
  }
  
  if (fc.c->ch == '\t')
  {
    fl.type = FL_TAB;
    fl.num_chars = 1;
    fl.m = fc.m;
    scan_char();
  }
  else if (WhiteSpaceP(fc.c->cc) && !fc.last->nonbreak)
  {
    fl.type = FL_SPACE;
    for (;;)
    {
      fl.width += fc.c->width + fc.last->compression;
      if (fc.c->overhang_changed_p)
      {
	fl.width += fc.last->overhang;
      }
      fl.m = fc.m;
      ++fl.num_chars;
      scan_char();
      if (fc.c->cc != CharClass_NORMAL_SPACE
	  || fc.c->ch == '\t' || fc.last->nonbreak)
      {
	break;
      }
    }
  }
  else
  {
    fl.type = FL_NORMAL;
    for (;;)
    {
      if (fl.num_chars != 0 && f_bot < f_top + fl.width)
      {
	break;
      }
      Iunit width = fc.c->width + fc.last->compression;
      if (fc.c->overhang_changed_p)
      {
	width += fc.last->overhang;
      }
      fl.width += width;
      if (f_emptyp && fl.num_chars != 0 && f_bot < f_top + fl.width)
      {
	fl.width -= width;
	break;
      }
      fl.m = fc.m;
      ++fl.num_chars;
      scan_char();
      if (EndOfLineP(fc.c->cc)
	  || fc.c->ch == '\t'
	  || (!fc.last->nonbreak
	      && (fc.c->nonbreak || break_table[fc.last->cc][fc.c->cc]))
	  || (decimal_end_p
	      && DecimalCharP(fc.last->ch) && !DecimalCharP(fc.c->ch)))
      {
	break;
      }
    }
  }
  fl.end_index = fc.index;
  if (f_vtextp && f_vtext_index != 0)
  {
    ++fl.end_index;
  }
}

static void NEAR
scan_multiple_lines(int decimal_end_p)
{
  fl1.num_chars = 0;
  fl0.num_chars = 0;
  fl0.width = 0;
  fl1.width = 0;
  fl0.type = fl.type;
  if (fl.type == FL_NORMAL || fl.type == FL_SPACE)
  {
    for (;;)
    {
      f_top += fl.width;
      if (fl.type == FL_SPACE)
      {
	add_line(&fl1, &fl);
      }
      else if (f_bot <= f_top && !f_emptyp)
      {
	f_top -= fl.width;
	break;
      }
      else
      {
	add_line(&fl0, &fl1);
	fl1.num_chars = 0;
	fl1.width = 0;
	add_line(&fl0, &fl);
      }
      f_emptyp = False;
      if (decimal_end_p &&
	  DecimalCharP(fc.last->ch) && !DecimalCharP(fc.c->ch))
      {
	scan_line(False);
	break;
      }
      scan_line(decimal_end_p);
      if (fl.type != FL_NORMAL && fl.type != FL_SPACE)
      {
	break;
      }
    }
  }
}

void
Line::Format(Iunit top_x, Iunit bot_x)
{
  this->Uncache();
  this->DeleteSubLines();
  
  BP* first_bp = this->first_bp;
  Paragraph* para = first_bp->GetParagraph();
  int* para_atts = get_atts(para->GetAtts());
  int first_index = first_bp->GetLogicalOffset();
  
  this->end_of_buffer_p = False;
  this->format_needed_p = False;
  
  fc.m.ascent = 0;
  fc.m.descent = 0;
  fc.m.over_ascent = 0;
  fc.m.under_descent = 0;
  
  f_tab_base = top_x;
  f_tab_size = para_atts[PA_tabsize];
  if (f_tab_size <= 0)
  {
    f_tab_size = mm_to_iu(15); // default value in atts.cpp
  }

  Iunit first_top;
  Iunit top;
  Iunit bot;
  this->calc_margin(top_x, bot_x, &first_top, &top, &bot);
  top_x = first_bp->BeginningOfBufferP() ? first_top : top;
  bot_x = bot;
  
  f_top = top_x;
  f_bot = bot_x;
  fl_list = NULL;
  fl_end = NULL;
  fl_visible_end = NULL;
  f_last_active_tab_style = TAB_reserved_0;
  f_last_tab_style = TAB_reserved_0;
  f_num_visible_chars = 0;
  f_has_border_p = False;
  f_has_special_p = False;
  f_has_page_no_p = False;
  f_count_down = MAX_LINE_CHARS;
  
  fc.index = first_index - 1;
  fc.editor = first_bp->GetEditor();
  f_set_frame(this);
  static_empty();
  scan_char();
  
  f_emptyp = True;
  scan_line(False);
  
  for (;;)
  {
    scan_multiple_lines(False);
    f_emptyp = False;
    switch (fl0.type)
    {
     case FL_END:
      assert(fl.num_chars == 0);
      if (fl_list == NULL)
      {
	register_line_immediately(&fl);
      }
      fl_end->end_index = fl.end_index;
      if (fc.c->ch == EOB && 0 <= f_count_down)
      {
	this->end_of_buffer_p = True;
      }
      break;
      
     case FL_NORMAL:
     case FL_SPACE:
      if (fl0.num_chars == 0 && fl1.num_chars == 0)
      {
	break;
      }
      register_line(&fl0);
      register_line(&fl1);
      continue;
      
     case FL_TAB:
      {
	FLInfo fl_tab;
	fl_tab = fl;
	Iunit tab_stop = f_tab_base;
	if (tab_stop <= f_top)
	{
	  tab_stop += f_tab_size * ((f_top - tab_stop) / f_tab_size + 1);
	}
	if (f_bot < tab_stop)
	{
	  if (fl_list != NULL)
	  {
	    break;
	  }
	  tab_stop = f_bot;
	}
	Iunit old_top = f_top;
	Iunit old_bot = f_bot;
	int style = fc.last->atts[CA_tab];
	f_last_tab_style = style;
	switch (style)
	{
	 default:
	  fl_tab.width = tab_stop - old_top;
	  f_top = tab_stop;
	  scan_line(False);
	  break;
	  
	 case TAB_right:
	 case TAB_decimal:
	  ++f_top;
	  f_bot = tab_stop;
	  while ((f_bot += f_tab_size) <= old_bot)
	  {
	  }
	  f_bot -= f_tab_size;
	  scan_line(style == TAB_decimal);
	  scan_multiple_lines(style == TAB_decimal);
	  f_bot = old_bot;
	  tab_stop -= old_top;
	  while (tab_stop <= fl0.width)
	  {
	    tab_stop += f_tab_size;
	  }
	  tab_stop += old_top;
	  fl_tab.width = (tab_stop - old_top) - fl0.width;
	  f_top = tab_stop + fl1.width;
	  break;
	  
	 case TAB_center:
	  {
	    Iunit x = tab_stop;
	    while ((x += f_tab_size + f_tab_size) <= f_bot)
	    {
	    }
	    x -= f_tab_size + f_tab_size;
	    ++f_top;
	    Iunit top_side = tab_stop - f_top;
	    Iunit space = f_bot - x;
	    SET_MIN(space, top_side);
	    SET_MAX(space, 0);
	    f_bot = f_top + space * 2 + (x - tab_stop);
	    scan_line(False);
	    scan_multiple_lines(False);
	    f_bot = old_bot;
	    if (fl0.num_chars == 0 && fl1.num_chars == 0)
	    {
	      fl_tab.width = tab_stop - old_top;
	      f_top = tab_stop;
	    }
	    else
	    {
	      int half_tab = (f_tab_size
			      * ((fl0.width / 2 - top_side + f_tab_size - 1)
				 / f_tab_size));
	      fl_tab.width = (tab_stop
			      + half_tab - fl0.width / 2 - old_top + 1);
	      f_top = old_top + fl_tab.width + fl0.width + fl1.width;
	    }
	  }
	  break;
	}
	register_line_immediately(&fl_tab);
	if ((fl0.type == FL_NORMAL || fl0.type == FL_SPACE)
	    && fl0.num_chars == 0 && fl1.num_chars == 0)
	{
	  break;
	}
	register_line(&fl0);
	register_line(&fl1);
      }
      continue;
      
     default:
      assert(0);
    }
    break;
  }
  
#if (!defined(NDEBUG))
  if (fl_list == NULL)
  {
    syserr("fl_list == NULL");
  }
#endif
  
  // final adjust
  {
    Iunit x = top_x;
    for (FLInfo* f = fl_list; f != NULL; f = f->chain)
    {
      f->top = x;
      x += f->width;
    }
    
    int adjustablep = True;
    switch (f_last_active_tab_style)
    {
     case TAB_right:
     case TAB_center:
     case TAB_decimal:
      adjustablep = False;
      break;
    }
    
    Iunit line_width = bot_x - top_x;
    Iunit visible_width = (fl_visible_end == NULL ? 0
			   : (fl_visible_end->top
			      + fl_visible_end->width - top_x));
    int last_visible_chars = (fl_visible_end == NULL
			      ? 0 : fl_visible_end->num_chars);
    int align = para_atts[PA_alignment];
    
    switch (align)
    {
     case AL_flushright:
      if (fl0.type == FL_END)
      {
	align = AL_leftaligned;
	break;
      }
      // no break
      
     case AL_stretched:
      if (!adjustablep || line_width < visible_width)
      {
	align = AL_leftaligned;
      }
      else if (visible_width == 0 || f_num_visible_chars <= 1)
      {
	align = align == AL_flushright ? AL_leftaligned : AL_centered;
      }
      else if (last_visible_chars <= 1)
      {
	align = AL_leftaligned;
      }
      else
      {
	align = AL_stretched;
      }
      break;
    }
    
    switch (align)
    {
     case AL_centered:
      if (visible_width < line_width)
      {
	top_x += (line_width - visible_width) / 2;
      }
      break;
      
     case AL_rightaligned:
      top_x = bot_x - visible_width;
      break;
      
     case AL_stretched:
      assert(fl_visible_end != NULL);
      if (fl_visible_end->top + fl_visible_end->width < bot_x)
      {
	fl_visible_end->width = bot_x - fl_visible_end->top;
      }
      break;
    }
  }
  
  this->ascent = fl_end->m.ascent;
  this->descent = fl_end->m.descent;
  if ((this->ascent | this->descent) == 0)
  {
    FontMetric* fm = get_font_metric(get_default_attributes(para),
				      ROMAJIFONT, f_tategaki_flow_p);
    this->ascent = fm->GetAscent();
    this->descent = fm->GetDescent();
  }
  this->ascent += fl_end->m.over_ascent + 1;
  this->descent += fl_end->m.under_descent + 1;
  
  this->num_chars = fl_end->end_index - first_index;
  this->num_shadow_chars = fc.index + 1 - first_index;
  this->top_x = top_x;
  this->has_border_p = f_has_border_p;
  this->has_special_p = f_has_special_p;
  this->has_page_no_p = f_has_page_no_p;
  
  int num_drawing_chars = 0;
  {
    SubLine* sub = this->sub;
    FLType trailing_type = FL_END;
    for (;;)
    {
      sub->trailing_spaces_p = False;
      top_x += fl_list->width;
      sub->bot_x = top_x;
      sub->num_drawing_chars = fl_list->num_chars;
      num_drawing_chars += fl_list->num_chars;
      trailing_type = fl_list->type;
      FLInfo* fl_next = fl_list->chain;
      delete(fl_list);
      fl_list = fl_next;
      if (fl_list == NULL)
      {
	break;
      }
      SubLine* sub_next = new SubLine;
      sub->chain = sub_next;
      sub = sub_next;
    }
    sub->chain = NULL;
    if (trailing_type == FL_SPACE)
    {
      sub->trailing_spaces_p = True;
    }
  }
  this->num_drawing_chars = num_drawing_chars;
}

// private method
void NEAR
Line::MakeInfo(LineCharInfo* info)
{
  int* heights = new int[this->num_drawing_chars + 1];
  long* expands = new long[this->num_drawing_chars + 1];
  
  BP* first_bp = this->first_bp;
  int first_index = first_bp->GetLogicalOffset();
  
  fc.index = first_index - 1;
  fc.editor = first_bp->GetEditor();
  f_set_frame(this);
  static_empty();
  
  int top_x = this->top_x;
  // index of info
  int n = 0;
  
  for (SubLine* sub = this->sub; sub != NULL; sub = sub->chain)
  {
    int num_drawing_chars = sub->num_drawing_chars;
    int top_n = n;
    int bot_n = n + num_drawing_chars;
    
    for (; n != bot_n; ++n)
    {
      static_fill();
      
      info[n].ch = fc.c->ch;
      info[n].attrib = fc.c->attrib;
      info[n].atts = fc.c->atts;
      info[n].i = fc.index - first_index;
      info[n].x = fc.c->width;
      info[n].overhang = 0;
      heights[n] = fc.c->ascent + fc.c->descent;
      if (fc.c->overhang_changed_p && n != 0)
      {
	int overhang = fc.last->overhang;
	info[n - 1].overhang = overhang;
	if (n != top_n)
	{
	  info[n - 1].x += overhang;
	}
      }
      if (n != top_n)
      {
	CharClass cc = fc.c->cc;
	switch (cc)
	{
	 case CharClass_RIGHT_KANA:
	 case CharClass_RIGHT_HIRAGANA:
	 case CharClass_RIGHT_KATAKANA:
	 case CharClass_RIGHT_KANJI:
	  cc = CharClass_KANA;
	  break;
	}
	expands[n - 1] = ((break_table[fc.last->cc][cc] + 1)
			  * MIN(heights[n - 1], heights[n]));
	info[n - 1].x += fc.last->compression;
      }
    }
    
    info[n].i = fc.index + 1 - first_index;
    info[n].ch = EOB;
    
    if (top_n != 0)
    {
      top_x += info[top_n - 1].overhang;
    }
    
    int bot_x = sub->bot_x;
    if (bot_x < top_x)
    {
      bot_x = top_x;
    }
    
    switch (num_drawing_chars)
    {
     case 0:
      break;
      
     case 1:
      if (info[top_n].ch == '\t')
      {
	info[top_n].ch = ' ';
	info[top_n].x = bot_x - top_x;
      }
      else
      {
	bot_x = top_x + info[top_n].x;
      }
      break;
      
     default:
      {
	Iunit total_width = 0;
	long total_expand = 0;
	int num_adjust_chars = num_drawing_chars - 1;
	int adjust_bot_n = top_n + num_adjust_chars;
	for (n = top_n; n != adjust_bot_n; ++n)
	{
	  total_width += info[n].x;
	  total_expand += expands[n];
	}
	total_width += info[n].x;
	
	Iunit adjust = (bot_x - top_x) - total_width;
	if (adjust < 0)
	{
	  // condense
	  adjust = -adjust;
	  int each = adjust / num_adjust_chars;
	  adjust -= num_adjust_chars * each;
	  for (n = top_n; n != adjust_bot_n; ++n)
	  {
	    info[n].x -= each;
	    if (adjust != 0)
	    {
	      --adjust;
	      --info[n].x;
	    }
	  }
	}
	else if (0 < adjust)
	{
	  // expand
	  for (n = top_n; n != adjust_bot_n; ++n)
	  {
	    if (adjust == 0)
	    {
	      break;
	    }
	    int foo = (int) ((adjust * expands[n] + ((total_expand - 1) >> 1))
			     / total_expand);
	    total_expand -= expands[n];
	    adjust -= foo;
	    info[n].x += foo;
	  }
	  assert(adjust == 0);
	}
      }
      break;
    }
    
    for (n = top_n; n != bot_n; ++n)
    {
      Iunit next_x = top_x + info[n].x;
      info[n].x = top_x;
      top_x = next_x;
    }
    info[n].x = top_x;
    n = bot_n;
    
    if (sub->trailing_spaces_p)
    {
      for (n = top_n; n != bot_n; ++n)
      {
	info[n].ch = EOB;
      }
    }
  }
  
  delete(expands);
  delete(heights);
}

// ------------------------------------------------------------
// info cache control

struct InfoCache
{
  unsigned char prev;
  unsigned char next;
  InfoHeader* h;
  Line* line;
};

static InfoCache STATIC_NEAR cache_table[256];

static inline void
link(InfoHeader* h)
{
  ++h->link_count;
  assert(0 < h->link_count);
}

static void NEAR
unlink(InfoHeader* h)
{
  assert(0 < h->link_count);
  if (--h->link_count == 0)
  {
    delete h;
  }
}

static void NEAR
unchain(int index)
{
  int prev = cache_table[index].prev;
  int next = cache_table[index].next;
  cache_table[prev].next = next;
  cache_table[next].prev = prev;
  assert(0 < index && index < 256);
  assert(0 <= prev);
  assert(0 <= next);
}

static void NEAR
chain(int prev, int index)
{
  int next = cache_table[prev].next;
  cache_table[index].prev = prev;
  cache_table[index].next = next;
  cache_table[prev].next = index;
  cache_table[next].prev = index;
  assert(0 < index && index < 256);
  assert(0 <= prev);
  assert(0 <= next);
}

// private lexical method
InfoHeader* NEAR
Line::MakeInfoHeader()
{
  InfoHeader* h
  = (InfoHeader *) new char[offsetof(InfoHeader, info)
			    + (sizeof(LineCharInfo)
			       * (this->num_drawing_chars + 1))];
  h->link_count = 1;
  this->MakeInfo(h->info);
  return(h);
}

LineCharInfo* 
Line::GetInfo()
{
  if (cache_table[0].prev == 0)
  {
    // initialize cache table
    for (int i = 1; i < 256; ++i)
    {
      chain(0, i);
    }
  }
  
  int index = this->cache_index;
  if (index == 0)
  {
    index = cache_table[0].prev;
    if (cache_table[index].h != NULL)
    {
      unlink(cache_table[index].h);
      cache_table[index].line->cache_index = 0;
    }
    cache_table[index].h = this->MakeInfoHeader();
    cache_table[index].line = this;
    this->cache_index = index;
  }
  
  assert(cache_table[index].h != NULL);
  assert(cache_table[index].line == this);
  
  unchain(index);
  chain(0, index);
  link(cache_table[index].h);
  return(cache_table[index].h->info);
}

void
Line::ReleaseInfo(LineCharInfo* info)
{
  InfoHeader* h = ((InfoHeader*)
		   ((char*) info - offsetof(InfoHeader, info)));
  unlink(h);
}

// private lexical method
// When LINE will be reformatted, must call this method to release cache
// information.
void NEAR
Line::Uncache()
{
  int index = this->cache_index;
  this->cache_index = 0;
  
  assert(0 <= index && index < 256);
  
  if (index != 0)
  {
    assert(cache_table[index].line == this);
    unlink(cache_table[index].h);
    cache_table[index].h = NULL;
    cache_table[index].line = NULL;
    unchain(index);
    chain(cache_table[0].prev, index);
  }
}
