// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: line.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// line

#ifndef LINE_H
#define LINE_H

#include "smartnew.h"

struct LineCharInfo
{
  // offset of `(line->GetFirstBP())->GetLogicalOffset()'
  int i;

  sjis ch;
  
  // character x position on layout relative
  Iunit x;
  
  // italic font overhang
  Iunit overhang;
  
  attr attrib;
  int* atts;
};

struct InfoHeader
{
  int link_count;
  LineCharInfo info[1];
};

struct SubLine
{
  int num_drawing_chars;
  Iunit bot_x;
  SubLine* chain;
  bool trailing_spaces_p;
};

class Line
{
private:
  // assigned in constructor only
  FrameInstance* frame;

  // dual link in frame
  Line* prev;
  Line* next;
  
  // `first_bp' points to first character in line.  If it is NULL, I
  // say "Nil line".  Frame-instance has nil-line's pointer.
  BP* first_bp;
  
  int num_chars;
  int num_shadow_chars;
  
  // `num_visible_chars + trailing-spaces'
  int num_drawing_chars;
  
  // positioning members
  Iunit top_x;
  Iunit y;
  Iunit top_border;
  Iunit bot_border;
  Iunit ascent;
  Iunit descent;
  SubLine sub[1];
  unsigned char cache_index;
  int format_needed_p : 1;
  int force_redisplay_p : 1;
  int has_special_p : 1;
  int has_page_no_p : 1;
  int end_of_buffer_p : 1;
  int shadow_p : 1;
  int border_changed_p : 1;
  int has_border_p : 1;
  
private:
  Line(FrameInstance* frame, BP* bp);
  ~Line();
public:
  REFER_SMARTNEW(Line)
  static Line* MakeInstance(FrameInstance* frame, BP* bp);
  static void KillInstance(Line* line);
  
private:
  InfoHeader* NEAR MakeInfoHeader();
#ifdef _WIN32
  Iunit NEAR CalcIndent(Iunit* top_x_return, Iunit* bot_x_return);
#else /* _WIN32 */
  Iunit NEAR CalcIndent(int* top_x_return, int* bot_x_return);
#endif /* _WIN32 */
  void NEAR DeleteSubLines();
  void NEAR MakeInfo(LineCharInfo* info);
  void NEAR Uncache();
public:
  BP* GetBPAtXCreate(Lunit x);
  BP* GetFirstBP();
  FrameInstance* GetFrame();
  LayoutInstance* GetLayout();
  Line* GetNext();
  Line* GetNextImmediately();
  Line* GetPrev();
  Line* GetPrevImmediately();
  Line* XGetNext();
  Line* XGetPrev();
  LineCharInfo* GetInfo();
  int EndOfBufferP();
  int GetBorderChangedP();
  int GetForceRedisplayP();
  int GetFormatNeededP();
  int GetNumChars();
  int GetNumDrawingChars();
  int GetNumShadowChars();
  int GetShadowP();
  int HasBorderP();
  int HasPageNoP();
  int HasSpecialP();
  int NilP();
  Iunit GetAscent();
  Iunit GetBaseLineY();
  Iunit GetBotBorder();
  Iunit GetBotX();
  Iunit GetDescent();
  Iunit GetHeight();
#ifdef _WIN32
  Iunit GetMarginPosOnIunits(Iunit* top_x_return, Iunit* bot_x_return);
#else /* _WIN32 */
  Iunit GetMarginPosOnIunits(int* top_x_return, int* bot_x_return);
#endif /* _WIN32 */
  Iunit GetTopBorder();
  Iunit GetTopX();
  Iunit GetY();
  void Format(Iunit top_x, Iunit bot_x);
  void LinkToPrev(Line* next);
  void ReleaseInfo(LineCharInfo* info);
  void ReportLast();
  void SetBorderChangedP(int border_changed_p);
  void SetBotBorder(Iunit bot_border);
  void SetForceRedisplayP(int force_redisplay_p);
  void SetFormatNeededP(int format_needed_p);
  void SetShadowP(int shadow_p);
  void SetTopBorder(Iunit top_border);
  void SetY(Iunit y);
  void  calc_margin(Iunit line_top, Iunit line_bot, Iunit* first_top_ret, Iunit* top_ret, Iunit* bot_ret);
  void calc_margin_irects(Irect* first_ir, Irect* ir);
  void navigate_bp(Lpoint* lp, BP* bp, LayoutInstance** layout_return);
  void set_panel_position_by_line_x(Panel* panel, Iunit line_x);
  void set_panel_position_by_lpoint(Panel* panel, Lpoint* lp);
};

inline FrameInstance* 
Line::GetFrame()
{
  return(this->frame);
}

inline Line* 
Line::GetNextImmediately()
{
  return(this->next);
}

inline Line* 
Line::GetPrevImmediately()
{
  return(this->prev);
}

inline BP* 
Line::GetFirstBP()
{
  return(this->first_bp);
}

inline int
Line::GetNumChars()
{
  return(this->num_chars);
}

inline int
Line::GetNumShadowChars()
{
  return(this->num_shadow_chars);
}

inline int
Line::GetNumDrawingChars()
{
  return(this->num_drawing_chars);
}

inline int
Line::NilP()
{
  return(this->GetFirstBP() == NULL);
}

inline Iunit
Line::GetY()
{
  return(this->y);
}

inline void
Line::SetY(Iunit y)
{
  this->y = y;
}

inline Iunit
Line::GetTopX()
{
  return(this->top_x);
}

inline Iunit
Line::GetAscent()
{
  return(this->ascent);
}

inline Iunit
Line::GetDescent()
{
  return(this->descent);
}

inline Iunit
Line::GetBaseLineY()
{
  return(this->y + this->ascent);
}

inline Iunit
Line::GetHeight()
{
  return(this->ascent + this->descent);
}

inline Iunit
Line::GetTopBorder()
{
  return(this->top_border);
}

inline void
Line::SetTopBorder(Iunit top_border)
{
  this->top_border = top_border;
}

inline Iunit
Line::GetBotBorder()
{
  return(this->bot_border);
}

inline void
Line::SetBotBorder(Iunit bot_border)
{
  this->bot_border = bot_border;
}

inline int
Line::GetFormatNeededP()
{
  return(this->format_needed_p);
}

inline void
Line::SetFormatNeededP(int format_needed_p)
{
  this->format_needed_p = format_needed_p;
}

inline int
Line::GetForceRedisplayP()
{
  return(this->force_redisplay_p);
}

inline void
Line::SetForceRedisplayP(int force_redisplay_p)
{
  this->force_redisplay_p = force_redisplay_p;
}

inline int
Line::EndOfBufferP()
{
  return(this->end_of_buffer_p);
}

inline int
Line::GetShadowP()
{
  return(this->shadow_p);
}

inline void
Line::SetShadowP(int shadow_p)
{
  this->shadow_p = shadow_p;
}

inline int
Line::HasBorderP()
{
  return(this->has_border_p);
}

inline int
Line::HasPageNoP()
{
  return(this->has_page_no_p);
}

inline int
Line::HasSpecialP()
{
  return(this->has_special_p);
}

inline int
Line::GetBorderChangedP()
{
  return(this->border_changed_p);
}

inline void
Line::SetBorderChangedP(int border_changed_p)
{
  this->border_changed_p = border_changed_p;
}

#endif /* LINE_H */
