// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: linesele.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class LineSelection
// t[GfB^̐IǗNX

#include "pword.h"
#include "linesele.h"
#include "fission.h"

// constructor
LineSelection::LineSelection(LayoutTemplate* lt, Fission* f, 
			      CrossPoint* start, CrossPoint* end)
{
  LineSelection::lt = lt;
  LineSelection::f = f;
  if (start == 0) 
  {
    // selection is the hole of the fission
    LineSelection::start = f->GetStartCrossPoint();
    LineSelection::end = f->GetEndCrossPoint();
  }
  else 
  {
    // selection is the part of the fission
    LineSelection::start = start;
    LineSelection::end = end;
  }
  
  // check selection bit
  if (f->GetDir() == Fission::Vertical) 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetVNext()) 
    {
      cp->SetVRedSelection();
    }
  }
  else 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetHNext()) 
    {
      cp->SetHRedSelection();
    }
  }
}

// get border line index
uword 
LineSelection::GetBorderLineIndex()
{
  return(f->GetDir() == Fission::Vertical) ?
  start->GetVBorder() :
  start->GetHBorder();
}

// set border line index
void 
LineSelection::SetBorderLineIndex(uword index)
{
  if (f->GetDir() == Fission::Vertical) 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetVNext()) 
    {
      cp->SetVBorder(index);
    }
  }
  else 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetHNext()) 
    {
      cp->SetHBorder(index);
    }
  }
}

// clear selection bit
void 
LineSelection::ClearSelection()
{
  // check selection bit
  if (f->GetDir() == Fission::Vertical) 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetVNext()) 
    {
      cp->ClearVRedSelection();
    }
  }
  else 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetHNext()) 
    {
      cp->ClearHRedSelection();
    }
  }
}

void 
LineSelection::SetSelection()
{
  // check selection bit
  if (f->GetDir() == Fission::Vertical) 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetVNext()) 
    {
      cp->SetVRedSelection();
    }
  }
  else 
  {
    for (CrossPoint* cp = start;
	 cp != end;
	 cp = cp->GetHNext()) 
    {
      cp->SetHRedSelection();
    }
  }
}
