// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: makenum.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Turn numbers into Japanese.

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "makenum.h"

#define	J_SPACE		"@"
#define	J_COMMA		"A"
#define	J_POINT		"B"
#define J_LPAREN        "i"
#define J_RPAREN        "j"

#define E_SPACE		" "
#define E_COMMA		","
#define E_POINT		"."
#define E_MINUS         "-"
#define E_LPAREN        "("
#define E_RPAREN        ")"

//  Japanese elements used in number construction

typedef char* NAME_TABLE[2];

LOCAL NAME_TABLE	units[] =
{
  {	"",	""	},
  {	"man",	""	},
  {	"oku",	""	},
  {	"chou",	""	},
  {	NULL,	NULL	}
};

#define NUM_UNITS	4

LOCAL NAME_TABLE 	elts [ ] =
{
  {	"",	""	},	
  {	"juu",	"\x8F\x5C"}, // character for "juu" -- compiler trouble
  {	"hyaku","S"	},
  {	"sen",	""	},
  {	NULL,	NULL	}
};

LOCAL NAME_TABLE	sino [ ] =
{
  {	"zero",	"Z"	},
  {	"ichi",	""	},
  {	"ni",	""	},
  {	"san",	"O"	},
  {	"yon",	"l"	},
  {	"go",	""	},
  {	"roku",	"Z"	},
  {	"nana",	""	},
  {	"hachi",""	},
  {	"kyuu",	""	},
  {	NULL,	NULL	}
};
 
LOCAL NAME_TABLE	zen [ ]  =
{
  {	"0",	"O"	},
  {	"1",	"P"	},
  {	"2",	"Q"	},
  {	"3",	"R"	},
  {	"4",	"S"	},
  {	"5",	"T"	},
  {	"6",	"U"	},
  {	"7",	"V"	},
  {	"8",	"W"	},
  {	"9",	"X"	},
  {	NULL,	NULL	},
};

LOCAL NAME_TABLE	decs [ ] =
{
  {	"wari",	""	},
  {	"bu",	""	},
  {	"ri",	""	},
  {	 NULL,	NULL	}
};

LOCAL NAME_TABLE weekdays [ 7 ] =
{
  {"Sunday",""},
  {"Monday",""},
  {"Tuesday",""},
  {"Wednesday",""},
  {"Thursday",""},
  {"Friday",""},
  {"Saturday","y"},
};

// ------------------------------------------------------------
// make_number
	
LOCAL void
add_num(char*, char* , int, int);

		
char* 
make_number(char* w, int flags)
{
  int	len,		// length of input left of '.'
  lang,			// ENGLISH or JAPANESE
  decdig=0;		// how far into fractional part

  int minus = 0;   // number is negative?
  
  int have_something=0,	// digit came forcing out  etc.
  predecimal=1;	// are we into the fractional part
	
  char* buf = new char[ strlen(w)*2*2 ];
  *buf = 0;
	
  if (flags&SINO_NUM) 
  {
    flags |= ZENKAKU_NUM;
  }
	
  char	*c;			// work
		
  if (!w) 
  {
    return NULL;
  }

  lang = flags & ENGLISH_NUM ? ENGLISH : JAPANESE;

  if (*w == '-')
  {
    minus = 1;
    w++;
    strcat(buf, (lang==ENGLISH ? E_MINUS : 
		  flags & ZENKAKU_NUM ? J_LPAREN : E_LPAREN));
  }
	
  for (c=w, len=0;  (*c && (*c != '.'));  c++, len++) 
  ;	// get length of portion before decimal point
			
  for (; *w; w++, --len) 
  {
	
    // handle case of fractional part
	
    if (!predecimal) // are already into the fraction
    {
      add_num(buf, w, flags, lang);
      if ((flags & UNITS_NUM)  &&  (decdig<3)) 
      {
	strcat(buf, decs[decdig++][lang]);
      }
      goto loopbot;
    }
	

    // this is the case of digits before the decimal point
			
    predecimal = *w != '.';
    if (predecimal)
    {
      if (! isdigit(*w))
      {
	return NULL;
      }

      if (((*w != '0') || (!*(w+1) && !have_something)) || 
	  !(flags & UNITS_NUM))
      {
	add_num(buf, w, flags, lang);
	have_something = 1;
      }
			
      if (flags & UNITS_NUM) 
      {
	if ((((len-1) % 4)==0) && have_something)
	{
	  // A
	  strcat(buf, units[len/4][lang]);
	  have_something = 0;
	}
	else if (flags & SINO_NUM) 
	{
	  if (*w=='1') // get rid of "" 
	  buf[ strlen(buf)-2 ] = '\0';
	  
	  if (*w != '0') 
	  // \ASA
	  strcat(buf, elts[(len-1) % 4][lang]);
	}
      }
    }	
	
    // and the decimal point itself
	
    else if (flags & UNITS_NUM)
    {
      strcat(buf, lang==ENGLISH ? E_SPACE : J_SPACE);
    }
    else 
    {
      strcat(buf, !(flags & ZENKAKU_NUM) ? E_POINT : (lang==ENGLISH ? E_POINT : J_POINT));
    }

    // and the comma
	
    if (predecimal &&  
	(flags & COMMA_NUM)  && 
	(((len % 3)==1) && (len != 1))
	)
    {
      strcat(buf, !(flags & ZENKAKU_NUM) ? "," : (lang==ENGLISH ? E_COMMA : J_COMMA));
    }
    
   loopbot: ;
  }
  
  if (minus)
  {
    if (lang==JAPANESE)
    {
      strcat(buf, flags & ZENKAKU_NUM ? J_RPAREN : E_RPAREN);
    }
  }
  
  return FixString(buf);
}


LOCAL void	
add_num(char* buf, char* c, int flags, int lang)
{
  char	string[2];
		
  if (flags & SINO_NUM) 
  {
    strcat(buf, sino[*c-'0'][lang]);
  }

  else if (flags & ZENKAKU_NUM) 
  {
    strcat(buf, zen[*c-'0'][lang]);
  }
	
  else 
  {
    // small arabic numbers
    string[0] = *c;
    string[1] = '\0';
    strcat(buf, string);
  }
}

char*  make_weekday(int w)
{
  if (w>=0 && w<= 6)
  {
    char* s = weekdays[ w ][ 1 ];
    char*  ret = new char[ strlen(s) + 2 ];
    strcpy(ret, s);
    return FixString(ret);
  }
  else return 0;
}

char* FixString(char* p)
{
  char* ret = p;
  for (;;)
  {
    unsigned char c1 = (unsigned char) *p;
    if (c1 == '\0')
    {
      break;
    }
    unsigned char c2 = (unsigned char) *(p+1);
    *(unsigned short*)p = (c1 << 8) | c2;
    p += 2;
  }
  *(unsigned short*)p = 0;
  return ret;
}
