// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: makenum.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// conversion of numbers into Japanese.

#ifndef MAKENUM_H
#define MAKENUM_H

// languages

#define	ENGLISH		0
#define JAPANESE	1
#define NUMBER_LANG	2
#define LOCAL static

// ------------------------------------------------------------
// NUMBERS

//  flags for conversion of numbers into Japanese.
//
// The flags below represent, respectively, whether to use zenkaku
// or hankaku characters, whether to use Sino-Japanese numbers or
// Arabic ones, whether to insert commas, and whether to insert units
// like .  SINO_NUM automatically implies ZENKAKU_NUM.  UNITS_NUM
// disables COMMA_NUM.
//
// OR these flags together for the flags argument to make_num.

#define	ZENKAKU_NUM	0x80
#define SINO_NUM	0x40
#define COMMA_NUM	0x20
#define UNITS_NUM	0x10
#define ENGLISH_NUM	0x08


char* FixString(char* p);


// make_number
// DESCRIPTION	convert a number-as-string into Japanese

char *		// result, or NULL for error(invalid character in string)
                //   points to storage provided by this routine;  user's
                //   responsibility to return!!
make_number
(
  char *,	// number to convert as zero-terminated ASCII string
  int		// flags governing conversion
)
;

// make_weekday
// DESCRIPTION	return day-of-week string, which you now own.

char *
make_weekday
(
int
)
;


// ------------------------------------------------------------
// KATAKANA-IZATION

// flags to control the thing

#define KKK_V		0x0001
				// use nigoried 'u' to represent v's
#define KKK_T		0x0002
				// try to duplicate the real 't' sound
#define KKK_F		0x0004
				// try to duplicate the real 'f' sound
#define KKK_NOBASU	0x0008
				// make vowels longer wherever possible
#define KKK_SHORT	0x0010
				// put in little tsu's wherever possible
								
		
char *		// result in temporary buffer, or NULL for failure
kkk
(
char *,		// lower-case english word to convert
int		// flags, see above
)
;

#endif /* MAKENUM_H */
