// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: margin.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// Margin class

#ifndef MARGIN_H
#define MARGIN_H

class Margin
{
  // margin data
  Iunit top;
  Iunit bottom;
  Iunit left;
  Iunit right;
  
public:
  Margin(Iunit top = 0, Iunit bottom = 0, 
	  Iunit left = 0, Iunit right = 0)
  {
    Margin::top    = top;
    Margin::bottom = bottom;
    Margin::left   = left;
    Margin::right  = right;
  }
  
  Iunit GetTop() 
  {
    return top;
  }
  
  Iunit GetBottom() 
  {
    return bottom;
  }
  
  Iunit GetLeft() 
  {
    return left;
  }
  
  Iunit GetRight() 
  {
    return right;
  }
  
  // mutater
  void SetTop(Iunit i) 
  {
    top = i;
  }
  
  void SetBottom(Iunit i) 
  {
    bottom = i;
  }
  
  void SetLeft(Iunit i) 
  {
    left = i;
  }
  void SetRight(Iunit i) 
  {
    right = i;
  }
  
  void Set(Iunit top, Iunit bottom, Iunit left, Iunit right)
  {
    Margin::top    = top;
    Margin::bottom = bottom;
    Margin::left   = left;
    Margin::right  = right;
  }
  
  // operator
  bool operator == (Margin& m)
  {
    return((top == m.top) &&
	    (bottom == m.bottom) &&
	    (left == m.left) &&
	    (right == m.right));
  }
  
  bool operator != (Margin& m)
  {
    return((top != m.top) ||
	    (bottom != m.bottom) ||
	    (left != m.left) ||
	    (right != m.right));
  }
};

#ifdef _WIN32
struct Bw2_Margin
{
  Bw2_Iunit top;
  Bw2_Iunit bottom;
  Bw2_Iunit left;
  Bw2_Iunit right;
};

inline void Bw2_Margin_to_Margin(Bw2_Margin& b2m, Margin& m)
{
  m.Set((Iunit)b2m.top, (Iunit)b2m.bottom, (Iunit)b2m.left, (Iunit)b2m.right);
}

inline void Margin_to_Bw2_Margin(Margin& m, Bw2_Margin& b2m)
{
  b2m.top = (Bw2_Iunit)m.GetTop();
  b2m.bottom = (Bw2_Iunit)m.GetBottom();
  b2m.left = (Bw2_Iunit)m.GetLeft();
  b2m.right = (Bw2_Iunit)m.GetRight();
}

#endif /* _WIN32 */

#endif /* MARGIN_H */
