// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mcursor.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class MouseCursor
// BeatWord Ŏgp}EXJ[\̃\[XnhNX

#include "pword.h"
#include "mcursor.h"

HCURSOR MouseCursor::cur = 0;

// windows cursors
HCURSOR MouseCursor::arrow;
HCURSOR MouseCursor::cross;
HCURSOR MouseCursor::wait;

// text cursor
HCURSOR MouseCursor::ibeam;
HCURSOR MouseCursor::hbeam;
HCURSOR MouseCursor::footer;
HCURSOR MouseCursor::vfooter;

// tool-box cursors
HCURSOR MouseCursor::cutclos;
HCURSOR MouseCursor::cutopen;
HCURSOR MouseCursor::pen;
HCURSOR MouseCursor::penon;
HCURSOR MouseCursor::penoff;
HCURSOR MouseCursor::grab;
HCURSOR MouseCursor::grabh;
HCURSOR MouseCursor::graba;
HCURSOR MouseCursor::grabha;
HCURSOR MouseCursor::graboff;
HCURSOR MouseCursor::grabdiag;
HCURSOR MouseCursor::paint;
HCURSOR MouseCursor::paintoff;
HCURSOR MouseCursor::selframe;
HCURSOR MouseCursor::sfoff;
HCURSOR MouseCursor::newflow;
HCURSOR MouseCursor::nfoff;
HCURSOR MouseCursor::flow;
HCURSOR MouseCursor::flowoff;
HCURSOR MouseCursor::flowto;
HCURSOR MouseCursor::flowton;
HCURSOR MouseCursor::flowtoe;
HCURSOR MouseCursor::exchange;
HCURSOR MouseCursor::exoff;
HCURSOR MouseCursor::exft;
HCURSOR MouseCursor::extooff;
HCURSOR MouseCursor::margin;
HCURSOR MouseCursor::margoff;
HCURSOR MouseCursor::table;
HCURSOR MouseCursor::tableoff;
HCURSOR MouseCursor::framemargin;
HCURSOR MouseCursor::framemargoff;
HCURSOR MouseCursor::framemarginh;
HCURSOR MouseCursor::framemarginhoff;

struct CursorTable
{
  HCURSOR* place;
  char* name;
  char system_cursor_p;
};

static CursorTable cursor_table[] =
{
  {&MouseCursor::arrow, (char*) IDC_ARROW, True},
  {&MouseCursor::cross, (char*) IDC_CROSS, True},
  {&MouseCursor::ibeam, (char*) IDC_IBEAM, True},
  {&MouseCursor::wait, (char*) IDC_WAIT, True},
  {&MouseCursor::hbeam, "HBeam", False},
  {&MouseCursor::footer, "Footer", False},
  {&MouseCursor::vfooter, "VFooter", False},
  {&MouseCursor::cutclos, "ToolBoxIconCutClose", False},
  {&MouseCursor::cutopen, "ToolBoxIconCutOpen", False},
  {&MouseCursor::pen, "ToolBoxIconPen", False},
  {&MouseCursor::penon, "ToolBoxIconPenOn", False},
  {&MouseCursor::penoff, "ToolBoxIconPenOff", False},
  {&MouseCursor::grab, "ToolBoxIconGrab", False},
  {&MouseCursor::grabh, "ToolBoxIconGrabH", False},
  {&MouseCursor::graba, "ToolBoxIconGrabA", False},
  {&MouseCursor::grabha, "ToolBoxIconGrabHA", False},
  {&MouseCursor::graboff, "ToolBoxIconGrabOff", False},
  {&MouseCursor::grabdiag, "ToolBoxIconGrabDiag", False},
  {&MouseCursor::selframe, "ToolBoxIconSelFrame", False},
  {&MouseCursor::sfoff, "ToolBoxIconSelFrameOff", False},
  {&MouseCursor::flow, "ToolBoxIconFlow", False},
  {&MouseCursor::flowoff, "ToolBoxIconFlowOff", False},
  {&MouseCursor::flowto, "ToolBoxIconFlowTo", False},
  {&MouseCursor::flowton, "ToolBoxIconFlowToNull", False},
  {&MouseCursor::flowtoe, "ToolBoxIconFlowToEmpty", False},
  {&MouseCursor::exchange, "ToolBoxIconEx", False},
  {&MouseCursor::exoff, "ToolBoxIconExOff", False},
  {&MouseCursor::exft, "ToolBoxIconExFromTo", False},
  {&MouseCursor::extooff, "ToolBoxIconExToOff", False},
  {&MouseCursor::margin, "ToolBoxIconMargin", False},
  {&MouseCursor::margoff, "ToolBoxIconMarginOff", False},
  {&MouseCursor::table, "ToolBoxIconTable", False},
  {&MouseCursor::tableoff, "ToolBoxIconTableOff", False},
  {&MouseCursor::framemargin, "ToolBoxIconFrameMargin", False},
  {&MouseCursor::framemargoff, "ToolBoxIconFrameMarginOff", False},
  {&MouseCursor::framemarginh, "ToolBoxIconFrameMarginH", False},
  {&MouseCursor::framemarginhoff, "ToolBoxIconFrameMarginHOff", False},
};

int MouseCursor::long_activity = 0;

// True if all cursors are loaded.
static int cursors_are_loaded_p = False;

// initialize mouse cursor
void
MouseCursor::InitialMouseCursor(HINSTANCE hInstance)
{
  if (!cursors_are_loaded_p)
  {
    CursorTable* p = cursor_table;
    int i = 0;
    for (; i != NUMBER_OF(cursor_table); ++i, ++p)
    {
      *p->place = ::LoadCursor(p->system_cursor_p ? 0 : hInstance, p->name);
    }
    cursors_are_loaded_p = True;
  }
}

void
MouseCursor::DestroyMouseCursor()
{
  if (cursors_are_loaded_p)
  {
    cursors_are_loaded_p = False;
    // Set system cursor.  MouseCursor::arrow shuld be system cursor.
    ::SetCursor(MouseCursor::arrow);
    CursorTable* p = cursor_table;
    int i = 0;
    for (; i != NUMBER_OF(cursor_table); ++i, ++p)
    {
      if (!p->system_cursor_p)
      {
	HCURSOR cursor = *p->place;
	if (cursor)
	{
	  *p->place = 0;
	  ::DestroyCursor(cursor);
	}
      }
    }
  }
}

// set cursor.  This will usually be called on WM_SETCURSOR messages.
bool
MouseCursor::WMSetCursor(bool active_window, int hitcode)
{
  if (cursors_are_loaded_p)
  {
    if (MouseCursor::long_activity)
    {
      ::SetCursor(MouseCursor::wait);
      return(True);
    }
    if (hitcode == HTCLIENT)
    {
      ::SetCursor(active_window ? MouseCursor::cur : MouseCursor::arrow);
      return(True);
    }
  }
  return(False);
}

bool
MouseCursor::WMSetCursor()
{
  return MouseCursor::WMSetCursor(True, HTCLIENT);
}

void
MouseCursor::StartLongActivity()
{
  ++MouseCursor::long_activity;
  assert(0 < MouseCursor::long_activity);
  MouseCursor::WMSetCursor();
}

void
MouseCursor::EndLongActivity()
{
  assert(0 < MouseCursor::long_activity);
  --MouseCursor::long_activity;
  MouseCursor::WMSetCursor();
}

HCURSOR
MouseCursor::SetCursor(HCURSOR cur)
{
  HCURSOR old_cur = MouseCursor::cur;
  if (cursors_are_loaded_p)
  {
    if (old_cur == 0)
    {
      old_cur = cur;
    }
    MouseCursor::cur = cur;
    MouseCursor::WMSetCursor();
  }
  return(old_cur);
}
