// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mcursor.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class MouseCursor
// mouse cursor resource manager

#ifndef MCURSOR_H
#define MCURSOR_H

class MouseCursor
{
public:
  // current cursor
  static HCURSOR cur;
  
  // windows's cursor
  static HCURSOR arrow;		// windows arrow cursor
  static HCURSOR cross;		// windows cross cursor
  static HCURSOR wait;		// windows wait cursor
  
  static HCURSOR ibeam;		// windows i-beam cursor
  static HCURSOR hbeam;
  static HCURSOR footer;
  static HCURSOR vfooter;
  
  // tool-box cursor
  // these member name are due to the cursor file name.
  static HCURSOR cutclos;
  static HCURSOR cutopen;
  static HCURSOR pen;
  static HCURSOR penon;
  static HCURSOR penoff;
  static HCURSOR grab;
  static HCURSOR grabh;
  static HCURSOR graba;
  static HCURSOR grabha;
  static HCURSOR graboff;
  static HCURSOR grabdiag;
  static HCURSOR paint;
  static HCURSOR paintoff;
  static HCURSOR selframe;
  static HCURSOR sfoff;
  static HCURSOR newflow;
  static HCURSOR nfoff;
  static HCURSOR flow;
  static HCURSOR flowoff;
  static HCURSOR flowto;
  static HCURSOR flowton;
  static HCURSOR flowtoe;
  static HCURSOR exchange;
  static HCURSOR exoff;
  static HCURSOR exft;
  static HCURSOR extooff;
  static HCURSOR margin;
  static HCURSOR margoff;
  static HCURSOR table;
  static HCURSOR tableoff;
  static HCURSOR framemargin;
  static HCURSOR framemargoff;
  static HCURSOR framemarginh;
  static HCURSOR framemarginhoff;
  
  static int long_activity;
  
private:
  static HCURSOR SetCursor(HCURSOR cur);
  
public:
  static void MouseCursor::EndLongActivity();
  static void MouseCursor::InitialMouseCursor(HINSTANCE hInstance);
  static void MouseCursor::DestroyMouseCursor();
  static void MouseCursor::StartLongActivity();
  static bool MouseCursor::WMSetCursor();
  static bool MouseCursor::WMSetCursor(bool active_window, int hitcode);
  
  // ------------------------------
  // set windows cursor
  static void Arrow() { SetCursor(arrow); }
  static void Cross() { SetCursor(cross); }
  
  // ------------------------------
  // set text cursor
  static void IBeam() { SetCursor(ibeam); }
  static void HBeam() { SetCursor(hbeam); }
  static void Footer() { SetCursor(footer); }
  static void VFooter() { SetCursor(vfooter); }
  
  // ------------------------------
  // set tool-box cursore

  // cut tool cursor
  static void CutClose() { SetCursor(cutclos); }
  static void CutOpen() { SetCursor(cutopen); }
  
  // draw line cursor
  static void Pen() { SetCursor(pen); }
  static void PenOn() { SetCursor(penon); }
  static void PenOff() { SetCursor(penoff); }
  
  // move line cursor
  static void Grab() { SetCursor(grab); }
  static void GrabH() { SetCursor(grabh); }
  static void GrabA() { SetCursor(graba); }
  static void GrabHA() { SetCursor(grabha); }
  static void GrabOff() { SetCursor(graboff); }
  static void GrabDiag() { SetCursor(grabdiag); }
  
  // select frame cursor
  static void SelectFrame() { SetCursor(selframe); }
  static void SelectFrameOff() { SetCursor(sfoff); }
  
  // set flow pipe cursor
  static void SetPipe() { SetCursor(flow); }
  static void SetPipeOff() { SetCursor(flowoff); }
  static void SetPipeTo() { SetCursor(flowto); }
  static void SetPipeToNull() { SetCursor(flowton); }
  static void SetPipeToEmpty() { SetCursor(flowtoe); }
  
  // exchange flow cursor
  static void Exchange() { SetCursor(exchange); }
  static void ExchangeOff() { SetCursor(exoff); }
  static void ExchangeFromTo() { SetCursor(exft); }
  static void ExchangeToOff() { SetCursor(extooff); }
  
  // set margin cursor
  static void Margin() { SetCursor(margin); }
  static void MarginOff() { SetCursor(margoff); }
  
  // make table cursor
  static void Table() { SetCursor(table); }
  static void TableOff() { SetCursor(tableoff); }
  
  // set margin cursor
  static void FrameMargin() { SetCursor(framemargin); }
  static void FrameMarginOff() { SetCursor(framemargoff); }
  static void FrameMarginH() { SetCursor(framemarginh); }
  static void FrameMarginHOff() { SetCursor(framemarginhoff); }
};

#endif /* MCURSOR_H */
