// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mdichild.cpp,v 3.6 1999/05/18 18:03:09 kudou Exp $
// implement MDIChild class

#include "pword.h"
#include "mdichild.h"
#include "mdiclien.h"
#include "mwindow.h"
#include "pwordpre.h"

// static variable for this class
HWND MDIChild::prev = 0;

MDIChild::MDIChild()
{
  client = MainWindow::GetMDIClient();
}

// virtual destructor
MDIChild::~MDIChild()
{
}

void
MDIChild::Destroy()
{
  // do not pass go, do not collect $200, especially do not do things
  // like sending me WM_SETFOCUS messages while I'm trying to kill
  // myself
  SetPointer(hWnd, 0);
  client->DestroyMeYourChild(this->GetHandle());
  hWnd = 0;
}

// Create -- create a child
//
// Create should be called by the constructor of the window type which
// is an MDI child.
void
MDIChild::Create(MDICREATESTRUCT& mdicreate)
{
  // these are fields we know about, and can save the caller the
  // trouble of filling in...???
  
  mdicreate.hOwner = PWordPresentation::hInstance;
  mdicreate.lParam = (LONG) this;
	
  // MDI child windows are created by sending a message to the client
  client->SendMessage(WM_MDICREATE, 0, (LONG) &mdicreate);
}

// DefWindowProc -- wrapper to Windows' version
LRESULT_T
MDIChild::DefWindowProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  return(::DefMDIChildProc(this->GetHandle(), iMessage, wParam, lParam));
}

// WndProc -- this handles only those messages relevant for MDI children.
LRESULT_T
MDIChild::WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
   case WM_MDIACTIVATE:
#ifdef _WIN32
     // WM_MDIACTIVATE message specification was changed from
     // 16-bit windows. (kudou)
     {
       HWND hwndChildAct = (HWND)lParam;
       HWND hwndChildDeact = (HWND)wParam;
       HWND hwndMe = this->GetHandle();
       if (hwndChildDeact == hwndMe)
       {
	 MDIChild::prev = NULL;
       }
       else if (hwndChildAct == hwndMe)
       {
	 // being activated
	 if ((MDIChild::prev = hwndChildDeact) == 0)
	 {
	   MDIChild::prev =  hwndMe;
	 }
       }
     }
#else /* _WIN32 */
    if (wParam == 0)
    {
      MDIChild::prev = NULL;
    }
    else
    {
      // being activated
      if ((MDIChild::prev = (HWND)HIWORD(lParam)) == 0)
      {
	MDIChild::prev = GetHandle();
      }
    }
#endif /* _WIN32 */
    break;
    
   case WM_MOUSEACTIVATE:
    return((GetHandle() != MDIChild::prev && LOWORD(lParam) == HTCLIENT)
	    ? MA_ACTIVATEANDEAT : MA_ACTIVATE);
    
   case WM_SETCURSOR:
    // now we know we are the previous child
    WMSetCursor();
    break;
  }
  return(DefWindowProc(msg, wParam, lParam));
}

void
MDIChild::WMSetCursor()
{
  MDIChild::prev = GetHandle();
}

// Dispatch -- dispatch messages to the mdi client
#ifdef BW3_DISPATCH
// I don't know who is using this function.
#else /* BW3_DISPATCH */
long
MDIChild::Dispatch(int /*wParam*/, long lParam)
{
  MENU_STATE_ENABLED
  return(0);
}
#endif /* BW3_DISPATCH */
