// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mdiclien.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the MDIClient class.
// Objects of the MDIClient class, of which normally only
// one per application invocation would be created, control
// multiple MDI children.

#include "pword.h"
#include "again.h"
#include "mwindow.h"
#include "pwordpre.h"
#include "mdiclien.h"
#include "mdichild.h"
#include "pmenus.h"

// Constructor for MDIClient
//
// important note about MDIClient:  this has no window procedure,
// as it is provided by Windows.  This obviates the need for the
// this pointer to be in the extra bytes of the window structure,
// since our generic window procedure ::xWndProc will never be used
// to dispatch to the window procedure local to the class.  Note that
// it is also impossible to pass this to the WM_CREATE message for this
// window where it would usually be plugged into the window record,
// since for an MDI client window the creation parameters argument must
// be set to a pointer to a CLIENTCREATESTRUCT.  
//
// To stay on the safe side, in case someone ever tries to do a 
// GetPointer() on an MDIClient window handle, we plug in the this 
// pointer ourselves here.

MDIClient::MDIClient(HWND parent)
{
  CLIENTCREATESTRUCT ccs;

  ccs.hWindowMenu  = GetSubMenu(::GetMenu(parent), IDM_DispMenu);
  ccs.idFirstChild = MDI_FirstChild;

  // Create the MDI client filling the client area
  hWnd = 
    ::CreateWindow("mdiclient",
		   0,
		   WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL,
		   0,
		   0,
		   0,
		   0,
		   parent,
		   (HMENU)1,
		   PWordPresentation::hInstance,
		   (LPSTR)&ccs);

  ::ShowWindow(hWnd, SW_SHOW);
}
  
MDIClient::~MDIClient()
{
  THIS_CHECK;
  ::DestroyWindow(hWnd);
}

MDIChild*
MDIClient::GetActiveChild()
{
  THIS_CHECK;
#ifdef _WIN32
  HWND hWndChild = (HWND)SendMessage(WM_MDIGETACTIVE);
#else /* _WIN32 */
  HWND hWndChild = LOWORD(this->SendMessage(WM_MDIGETACTIVE));
#endif /* _WIN32 */
  return(hWndChild == 0 ? NULL : (MDIChild*) GetPointer(hWndChild));
}

void
MDIClient::DestroyMeYourChild(HWND hWndChild)
{
  THIS_CHECK;
  SendMessage(WM_MDIDESTROY, (WPARAM_T)hWndChild);
}

#ifdef BW3_DISPATCH
LRESULT_T
MDIClient::Dispatch(WORD command, WORD notify_code, HWND /* hwnd */)
#else /* BW3_DISPATCH */
long
MDIClient::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  THIS_CHECK;
  switch (command)
  {
   case IDM_Disp_TileWindow:
    MENU_STATE(GetActiveChild() ? MF_ENABLED : MF_GRAYED);
    Again::CantDoAgain();
    SendMessage(WM_MDITILE);
    break;
	
   case IDM_Disp_CascadeWindow:
    MENU_STATE(GetActiveChild() ? MF_ENABLED : MF_GRAYED);
    Again::CantDoAgain();
    SendMessage(WM_MDICASCADE);
    break;
	
#ifndef NDEBUG
   default:
    syserr("Unknown message 0x%x in mdiclient", command);
#endif
  }
  return 0;
}
