// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: memo.h,v 3.3 1999/05/18 18:03:09 kudou Exp $
// define MemoDialog class

#ifndef MEMO_H
#define MEMO_H

#include "dlg.h"

class MemoDialog
  : public PModalDialog
{
protected:
  int value_set;
  char* value;
	
public:
  MemoDialog(char* initial, int initial_set=0);
	
  virtual char* GetValue() const
  {
    return value;
  }
  virtual void SetValue(char* value)
  {
    MemoDialog::value = value;
    value_set = 1;
  }
};

class MemoEditDialog
  : public MemoDialog
{
private:
  static char* dummy_memo;
  static LONG old_wndproc;
  
public:
  // max memo buffer size
  enum { MAX_MEMO_SIZE = 10000 };

  MemoEditDialog(char* initial);
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T CALLBACK _export OurWndProc(HWND h, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T OurWndProc_ (HWND h, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);
};

class MemoNoEditDialog
  : public MemoDialog
{
  static LONG old_wndproc;
  
public:
  MemoNoEditDialog(char* initial);
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T CALLBACK _export OurWndProc(HWND h, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T OurWndProc_ (HWND h, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);
};

#endif /* MEMO_H */

