// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: menu.h,v 3.3 1999/06/25 23:01:24 kudou Exp $
// menu

#ifndef MENU_H
#define MENU_H

enum Menu_Type
{
  Menu_Type_JAPANESE_FONT,
  Menu_Type_ENGLISH_FONT,
  Menu_Type_CHAR_STYLE,
  Menu_Type_PARA_STYLE,
  Menu_Type_MARK,
#ifdef BW2_ABBREV
  Menu_Type_ABBREV,
#endif /* BW2_ABBREV */
#ifdef BW3_RECENTOPEN
  Menu_Type_RECENTOPEN,
#endif /* BW3_RECENTOPEN */
  Menu_Type_UNUSED_MAX,
};

// NX Menu ̓CX^XȂÃW[ł
class Menu
{
public:
  static HMENU Menu::get_menu(int menu_pos);
  static HMENU Menu::get_menubar();
  static HMENU Menu::get_sub_menu(int menu_pos, int sub_menu_pos);
  static int Menu::item_exists_p(Menu_Type menu_type);
  static int Menu::go_dialog(Menu_Type menu_type, char* title);
  static long Menu::dispatch(int menu_state_p, int command);
  static long Menu::dispatch_anytime(int menu_state_p, int command);
  static void Menu::add_menu(Menu_Type menu_type, int attrib_index, char* name);
  static void Menu::add_static_menu(Menu_Type menu_type, int attrib_index, char* name, int idm);
  static void Menu::control_shortcuts();
  static void Menu::delete_menu(Menu_Type menu_type, int attrib_index);
  static void Menu::init();
  static void Menu::load();
  static void Menu::set_undo_redo(int undop, char* string);
};

#endif /* MENU_H */
