// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: messbox.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// lightweight message box

#include "pword.h"
#include "messbox.h"
#include "document.h"
#include "mdiclien.h"
#include "mwindow.h"
#include "pref.h"
#include "ptimer.h"
#include "pwordpre.h"

char MessBox::szClassName[] = MESSBOX_CLASS_NAME;

int
MessBox::Register()
{
  WNDCLASS Wc;
  Wc.style = 0 | CS_SAVEBITS;
  Wc.lpfnWndProc = xWndProc;
  Wc.cbWndExtra = sizeof(MessBox*);
  Wc.cbClsExtra = 0;
  Wc.hInstance = PWordPresentation::hInstance;
  Wc.hIcon = NULL;
  Wc.hCursor = NULL;
  Wc.hbrBackground = (HBRUSH)::GetStockObject(LTGRAY_BRUSH);
  Wc.lpszMenuName = NULL;
  Wc.lpszClassName = szClassName;
  if (!RegisterClass(&Wc))
  {
    return FALSE;
  }
  return TRUE;
}

MessBox::MessBox()
{
  timer = 0;
}


MessBox::~MessBox()
{
  Destroy();
}

// Display is called to put up the message box

void
MessBox::DisplayPermanent(char* msg)
{
  xDisplay(1, msg);
}

void
MessBox::Display(char* msg)
{
  xDisplay(0, msg);
}

void
MessBox::xDisplay(int permanent, char* _msg)
{
  if (Pref_no_message_box)
  {
    return;
  }
  
  if (this->GetHandle() != NULL)
  {
    this->Hide();
  }
  this->Destroy();
  
  // leaving in the line below causes a crash when five windows are open in
  // Japanese windows and you switch from one tool to another.
  //  main_window->Update();
  
  if (!_msg || !*_msg) 
  {
    return;
  }
  
  hWnd = 
  CreateWindow(szClassName,
		NULL,						//Window Name
		WS_CHILD|WS_DLGFRAME,				//dwStyle
		0,						//X
		0,						//Y
		0,						//nWidth - will resize;
		0,						//nHeight
		MainWindow::GetMDIClient() ->GetHandle(),	//hWndParent
		0,						//hMenu
		PWordPresentation::hInstance,			//hInstance
		(LPSTR) this);					//lpParam
  
  copy_string(msg, _msg, MAXMSGLEN);
  
  
  // get the size of the string, using a default DC
  
  HDC DC = GetDC(NULL);
#ifdef _WIN32
  SIZE width_height;
  GetTextExtentPoint32(DC, msg, strlen(msg), &width_height);
  int width = width_height.cx;
  int height = width_height.cy;
#else /* _WIN32 */
  DWORD dwExtent = GetTextExtent(DC, msg, strlen(msg));
  int width = LOWORD(dwExtent);
  int height = HIWORD(dwExtent);
#endif /* _WIN32 */
  ReleaseDC(NULL, DC);
  
  
  // the message box is centered in the middle of the current document
  // window, or the main window if there is no current document window
  RECT r;
  main_window->GetClientRect(&r);
  int vcenter = r.bottom/3;
  int hcenter = r.right/2;
  
  
  // now set the window's position
  
  SetPos(0, 
	  hcenter-width/2-MESSBOXBORDER, 
	  vcenter-height/2-MESSBOXBORDER,
	  width+MESSBOXBORDER*2, 
	  height+MESSBOXBORDER*2, 
	  0);
  
  Show(SW_SHOWNOACTIVATE);
  InvalidateAll();
  Update();
  
  if (!permanent) {
    timer = new PTimer(this, MESSBOXTIMER, DISAPPEAR_SECONDS);
  }
}


LRESULT_T
MessBox::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_TIMER:
    {
      if (wParam != MESSBOXTIMER) 
      {
#ifndef NDEBUG
	syserr("MessBox::WndProc -- invalid timer ID %x", wParam);
#endif
	return 0;
      }
      Destroy();
      return 0;
    }
    
   case WM_SETFOCUS:
    ::SendMessage(main_window_handle, WM_SETFOCUS, (WPARAM_T)GetHandle(), 0);
    return(0);
    
   case WM_PAINT:
    {
      PAINTSTRUCT paint;
      HDC dc = BeginPaint(&paint);
      (void) SetBkMode(dc, TRANSPARENT);
      RECT r;
      GetClientRect(&r);
      ::DrawText(dc, msg, strlen(msg), &r, DT_VCENTER|DT_CENTER|DT_NOPREFIX);
      EndPaint(&paint);
      return 0;
    }
    
    // pressing the mouse on the window means the user wants it to
    // go away
    
   case WM_LBUTTONDOWN:
   case WM_MBUTTONDOWN:
   case WM_RBUTTONDOWN:
    {
      Destroy();
      return 0;
    }
    
   default: 
    return DefWindowProc(Msg, wParam, lParam);
  }
}


// Hide() hides the little window, and turns off the timer
void
MessBox::Destroy()
{
  if (this->timer)
  {
    delete this->timer;
    this->timer = 0;
  }
  
  Window::Destroy();
}

void
MessBox::Clear()
{
  this->Display(NULL);
}
