// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: metafile.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Metafile
// ^t@C̏ێNXBgWindows̃^t@C
// f[^B

#include "pword.h"
#include "metafile.h"
#include <stdlib.h>
#include "dib.h"
#include "mwindow.h"
#include "pclipboa.h"
#include "picture.h"
#include "pmenus.h"
#include "pref.h"
#include "rect.h"
#include "tablepnl.h"
#include "vdisplay.h"
#include "view.h"
#include "xstr.h"

Metafile::Metafile(METAFILEPICT* mp)
{
  Metafile::mp = mp;
  hmf = mp->hMF;
}

// constructor for duplicate
Metafile::Metafile(Metafile* mf)
{
  mp = new METAFILEPICT;
  *mp = * (mf->mp);
  mp->hMF = hmf = (HMETAFILE)CopyHandle(mf->hmf);
}

#ifdef BUILD_IN_METAFILE
// constructor for to get the built in metafile
Metafile::Metafile(BuiltInMetafile bim)
{
  mp = new METAFILEPICT;
  mp->mm = MM_ANISOTROPIC;
  mp->xExt = BuiltInMetafileX;
  mp->yExt = BuiltInMetafileY;
  mp->hMF = GetBuiltInMetafile(bim);
}
#endif

// destructor
Metafile::~Metafile()
{
  ::GlobalFree(mp->hMF);
  delete mp;
}

// check scalable metafile
bool 
Metafile::IsScalable()
{
  return(mp->mm == MM_ISOTROPIC) || (mp->mm == MM_ANISOTROPIC);
}

Enum_Desc printer_metafile_desc[] =
{
  { S_metafile_direct,		(int) Metafile::DirectPlayMetafile, },
  { S_metafile_fine,		(int) Metafile::WidthDIB, },
  { S_metafile_rough,		(int) Metafile::Rough, },
  { S_metafile_fast_rough,	(int) Metafile::WidthBitMap, },
  { S_metafile2_direct,		(int) Metafile::DirectPlayMetafile, },
  { S_metafile2_fine,		(int) Metafile::WidthDIB, },
  { S_metafile2_rough,		(int) Metafile::Rough, },
  { S_metafile2_fast_rough,	(int) Metafile::WidthBitMap, },
  { NULL,			(int) Metafile::DirectPlayMetafile, },
};

Enum_Desc display_metafile_desc[] =
{
  { S_metafile_direct,		(int) Metafile::DirectPlayMetafile, },
  { S_metafile_rough,		(int) Metafile::Rough, },
  { S_metafile_fast_rough,	(int) Metafile::WidthBitMap, },
  { S_metafile2_direct,		(int) Metafile::DirectPlayMetafile, },
  { S_metafile2_rough,		(int) Metafile::Rough, },
  { S_metafile2_fast_rough,	(int) Metafile::WidthBitMap, },
  { NULL,			(int) Metafile::DirectPlayMetafile, },
};

// get display mode
Metafile::DisplayMode 
Metafile::GetDisplayMode(VDisplay* vdsp)
{
    return((Metafile::DisplayMode) (vdsp->IsPrinter()
				     ? Pref_printer_metafile
				     : Pref_display_metafile));
}

// set mapping mode
void
Metafile::SetMappingMode(HDC hDC, int width, int height)
{
  int mm = mp->mm;
  int x_ext = mp->xExt;
  int y_ext = mp->yExt;
  ::SetMapMode(hDC, mm);
  if (mm == MM_ISOTROPIC)
  {
    x_ext = (x_ext < 0) ? -x_ext : x_ext;
    y_ext = (y_ext < 0) ? -y_ext : y_ext;
    if (x_ext && y_ext)
    {
      if (x_ext > y_ext)
      {
	// use x scale
	height = (int) ((long) height * (long) y_ext / (long) x_ext);
      }
      else
      {
	// use y scale
	width = (int) ((long) width * (long) x_ext / (long) y_ext);
      }
    }
  }
  if (mm == MM_ISOTROPIC || mm == MM_ANISOTROPIC)
  {
#ifdef _WIN32
    ::SetViewportExtEx(hDC, width, height, NULL);
#else /* _WIN32 */
    ::SetViewportExt(hDC, width, height);
#endif /* _WIN32 */
  }
}

// make draw bitmap
HBITMAP 
Metafile::MakeDrawBitMap(HDC hDC, int width, int height)
{
  HBITMAP hbmp = ::CreateCompatibleBitmap(hDC, width, height);
  if (hbmp == 0) 
  {
    return 0;
  }
#ifdef METAFILE_SIZE_CHECK_BEEP
  //
  // size check beep
  //
  BITMAP bm;
  ::GetObject(hbmp, sizeof(BITMAP), (LPSTR)&bm);
  DWORD size = (DWORD)bm.bmHeight * (DWORD)bm.bmWidthBytes * 
  (DWORD)bm.bmBitsPixel * (DWORD)bm.bmPlanes;
  if (size > 65536L) 
  {
    // more than 64K bitmap
    ::MessageBeep(0);
  }
#endif
  HDC hdc_mem = ::CreateCompatibleDC(hDC);
  ::SelectObject(hdc_mem, hbmp);
  HBRUSH br = (HBRUSH)::GetStockObject(WHITE_BRUSH);
  RECT cl;
  cl.top = 0;
  cl.left = 0;
  cl.bottom = height;
  cl.right = width;
  ::FillRect(hdc_mem, &cl, br);
  SetMappingMode(hdc_mem, width, height);
  ::SetTextAlign(hdc_mem, TA_LEFT | TA_TOP | TA_NOUPDATECP);
  ::PlayMetaFile(hdc_mem, mp->hMF);
  ::DeleteDC(hdc_mem);
  return hbmp;
}

// display
void 
Metafile::Redisplay(VDisplay* vdsp, Rect& rec)
{
  HDC hDC = vdsp->GetDC();
  switch (GetDisplayMode(vdsp)) 
  {
   case DirectPlayMetafile:
    if (IsScalable()) 
    {
      //
      // direct play metafile
      //
      RECT r = vdsp->ItoWR(rec);
      ::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));
      int save = ::SaveDC(hDC);
      SetMappingMode(hDC, r.right - r.left, r.bottom - r.top);
#ifdef _WIN32
      ::SetViewportOrgEx(hDC, r.left, r.top, NULL);
#else /* _WIN32 */
      ::SetViewportOrg(hDC, r.left, r.top);
#endif /* _WIN32 */
      ::SetTextAlign(hDC, TA_LEFT | TA_TOP | TA_NOUPDATECP);
      ::SetBkMode(hDC, OPAQUE);
      ::PlayMetaFile(hDC, mp->hMF);
      ::RestoreDC(hDC, save);
    }
    else 
    {
      if (vdsp->IsPrinter()) 
      {
	goto L_Rough;
      }
      else 
      {
	goto L_BitMap;
      }
    }
    break;
   case WidthDIB:
    if (IsScalable()) 
    {
      //
      // create device size DIB
      //
      RECT r = vdsp->ItoWR(rec);
      int width = r.right - r.left;
      int height = r.bottom - r.top;
      bool painted = False;
      HBITMAP hbmp = MakeDrawBitMap(Default_View->GetDC(), 
				     width, height);
      if (hbmp) 
      {
	HANDLE hdib = Picture::CreateDIB(hbmp);
	if (hdib) 
	{
	  LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER)::GlobalLock(hdib);
	  if (lpbi)
	  {
	    ::DibBlt(hDC, r.left, r.top, width, height, lpbi, 0, 0);
	    painted = True;
	  }
	  ::GlobalUnlock(hdib);
	  ::GlobalFree(hdib);
	}
	::DeleteObject(hbmp);
      }
      if (!painted) 
      {
	::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));
      }
    }
    else 
    {
      goto L_Rough;
    }
    break;
   case Rough:
   L_Rough:
    {
      //
      // create default view size DIB
      //
      RectL iunits_base = vdsp->GetIunitsBase();
      RECT r = vdsp->ItoWR(Default_View, rec);
      RECT r2 = vdsp->ItoWR(rec);
      int width = r.right - r.left;
      int height = r.bottom - r.top;
      bool painted = False;
      HBITMAP hbmp = MakeDrawBitMap(Default_View->GetDC(), 
				     width, height);
      if (hbmp) 
      {
	HANDLE hdib = Picture::CreateDIB(hbmp);
	if (hdib) 
	{
	  void* cf_dib = ::GlobalLock(hdib);
	  if (::StretchDibBlt(hDC, r2.left, r2.top, 
			      r2.right - r2.left, r2.bottom - r2.top, 
			      cf_dib, 0, 0, width, height, SRCCOPY))
	  {
	    painted = True;
	  }
	  ::GlobalUnlock(hdib);
  	  ::GlobalFree(hdib);
	}
	::DeleteObject(hbmp);
      }
      if (!painted) 
      {
	::FillRect(hDC, &r2, (HBRUSH)::GetStockObject(WHITE_BRUSH));
      }
    }
    break;
   case WidthBitMap:
   L_BitMap:
    if (IsScalable()) 
    {
      //
      // scalable metafile
      //
      RECT r = vdsp->ItoWR(rec);
      HDC hDC = vdsp->GetDC();
      int width = r.right - r.left;
      int height = r.bottom - r.top;
      bool painted = False;
      HBITMAP hbmp = MakeDrawBitMap(hDC, width, height);
      if (hbmp) 
      {
	HDC hdc_mem = ::CreateCompatibleDC(hDC);
	if (hdc_mem) 
	{
	  ::SelectObject(hdc_mem, hbmp);
	  if (::BitBlt(hDC, r.left, r.top, 
			r.right - r.left, r.bottom - r.top, 
			hdc_mem, 0, 0, SRCCOPY)) 
	  {
	    painted = True;
	  }
	  ::DeleteDC(hdc_mem);
	}
	::DeleteObject(hbmp);
      }
      if (!painted) 
      {
	::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));
      }
    }
    else 
    {
      //
      // unscalable metafile
      //
      RECT r = vdsp->ItoWR(Default_View, rec);
      RECT r2 = vdsp->ItoWR(rec);
      int width = r.right - r.left;
      int height = r.bottom - r.top;
      bool painted = False;
      HBITMAP hbmp = MakeDrawBitMap(hDC, width, height);
      if (hbmp) 
      {
	HDC hdc_mem = ::CreateCompatibleDC(hDC);
	if (hdc_mem) 
	{
	  ::SelectObject(hdc_mem, hbmp);
	  if (::StretchBlt(hDC, r2.left, r2.top, 
			    r2.right - r2.left, r2.bottom - r2.top, 
			    hdc_mem, 0, 0, width, height, SRCCOPY)) 
	  {
	    painted = True;
	  }
	  ::DeleteDC(hdc_mem);
	}
	::DeleteObject(hbmp);
      }
      if (!painted) 
      {
	::FillRect(hDC, &r2, (HBRUSH)::GetStockObject(WHITE_BRUSH));
      }
    }
    break;
  }
}

// copy to clipboard
void 
Metafile::CopyToClipboard()
{
  HANDLE paste_metafile = ::GlobalAlloc(GHND, sizeof(METAFILEPICT));
  if (paste_metafile == 0) 
  {
    // error
    return;
  }
  METAFILEPICT* paste_mp = (METAFILEPICT*)::GlobalLock(paste_metafile);
  if (paste_mp == 0) 
  {
    // error
    return;
  }
  *paste_mp = *mp;
  paste_mp->hMF = (HMETAFILE)CopyHandle(mp->hMF);
  if (paste_mp->hMF == 0) 
  {
    ::GlobalUnlock(paste_metafile);
    ::GlobalFree(paste_metafile);
    // error
    return;
  }
  ::GlobalUnlock(paste_metafile);
  if (::OpenClipboard(main_window_handle)) 
  {
    PClipboard::SetOpenFlag(True);
    ::EmptyClipboard();
    ::SetClipboardData(CF_METAFILEPICT, paste_metafile);
    ::CloseClipboard();
    PClipboard::SetOpenFlag(False);
  }
}

//#define SAMPLE_METAFILE

// copy clipboard
METAFILEPICT* 
Metafile::CopyClipBoard(HWND hWnd)
{
#ifndef SAMPLE_METAFILE
  if (!::OpenClipboard(hWnd)) 
  {
    return 0;
  }
  PClipboard::SetOpenFlag(True);
  
  HANDLE h_clip_board = ::GetClipboardData(CF_METAFILEPICT);
  if (h_clip_board == 0) 
  {
    return 0;
  }
  METAFILEPICT* mp = CopyClipBoardData(h_clip_board);
  ::CloseClipboard();
  PClipboard::SetOpenFlag(False);
  
  return mp;
#else
  // for test
  return MakeSampleMetafile();
#endif
}

// copy clipboard data
METAFILEPICT* 
Metafile::CopyClipBoardData(HANDLE hmeta)
{
  METAFILEPICT* clpbd = (METAFILEPICT*)::GlobalLock(hmeta);
  if (clpbd == 0) 
  {
    return 0;
  }
  METAFILEPICT* mp = new METAFILEPICT;
  *mp = *clpbd;
  mp->hMF = (HMETAFILE)CopyHandle(clpbd->hMF);
  ::GlobalUnlock(hmeta);
  if (mp->hMF == 0) 
  {
    delete mp;
    return 0;
  }
  return mp;
}

// get width and height
void 
Metafile::GetWidthAndHeight(METAFILEPICT* mp, 
			     Iunit& width, Iunit& height)
{
  int x_ext = mp->xExt;
  int y_ext = mp->yExt;
  
  switch (mp->mm) 
  {
   case MM_TEXT:		// picel
    {
      int dpi_x = Default_View->GetDeviceDPIX();
      int dpi_y = Default_View->GetDeviceDPIY();
      width = (Iunit) ((IUNITS_PER_INCH_F * (double)x_ext) / 
			(double)dpi_x);
      height = (Iunit) ((IUNITS_PER_INCH_F * (double)y_ext) /
			 (double)dpi_y);
    }
    break;
   case MM_LOMETRIC:		// 1/10 mm
    {
      width = mm0_to_iu(x_ext);
      height = mm0_to_iu(y_ext);
    }
    break;
   case MM_HIMETRIC:		// 1/100 mm
    {
      width = mm0_to_iu(x_ext / 10);
      height = mm0_to_iu(y_ext / 10);
    }
    break;
   case MM_LOENGLISH:		// 1/100 inch
    {
      width = (Iunit) (((long)IUNITS_PER_INCH * (long)x_ext) / 100L);
      height = (Iunit) (((long)IUNITS_PER_INCH * (long)y_ext) / 100L);
    }
    break;
   case MM_HIENGLISH:		// 1/1000 inch
    {
      width = (Iunit) (((long)IUNITS_PER_INCH * (long)x_ext) / 1000L);
      height = (Iunit) (((long)IUNITS_PER_INCH * (long)y_ext) / 1000L);
    }
    break;
   case MM_TWIPS:		// 1/20 printer points
    {
      int dpi_x = Printer_View->GetDeviceDPIX();
      int dpi_y = Printer_View->GetDeviceDPIY();
      width = (Iunit) ((IUNITS_PER_INCH_F * (double)x_ext) / 
			(double)dpi_x / 20.0);
      height = (Iunit) ((IUNITS_PER_INCH_F * (double)y_ext) /
			 (double)dpi_y / 20.0);
    }
    break;
   case MM_ISOTROPIC:
    {
      if ((x_ext > 0) && (y_ext > 0)) 
      {
	// 1/100 mm
	width = mm0_to_iu(x_ext / 10);
	height = mm0_to_iu(y_ext / 10);
      }
      else 
      {
	// horz : vert
	Iunit def_size = TablePanel::GetDefaultTableSize();
	x_ext = - x_ext;
	y_ext = - y_ext;
	if ((x_ext == 0) || (y_ext == 0)) 
	{
	  width = def_size;
	  height = def_size;
	}
	else if (x_ext > y_ext) 
	{
	  width = def_size;
	  height = (Iunit) (((long)def_size * (long)y_ext) / (long)x_ext);
	}
	else 
	{
	  height = def_size;
	  width = (Iunit) (((long)def_size * (long)x_ext) / (long)y_ext);
	}
      }
    }
    break;
   case MM_ANISOTROPIC:
    {
      if ((x_ext > 0) && (y_ext > 0)) 
      {
	// 1/100 mm
	width = mm0_to_iu(x_ext / 10);
	height = mm0_to_iu(y_ext / 10);
      }
      else 
      {
	// any size
	Iunit def_size = TablePanel::GetDefaultTableSize();
	width = def_size;
	height = def_size;
      }
    }
    break;
  }
}

#ifdef SAMPLE_METAFILE
// make sample metafile
METAFILEPICT* 
Metafile::MakeSampleMetafile(char* name)
{
  HDC hdcMeta;
  int r, c;
  int x, y;
  char szBuf[11];
  
  const int COLS = 10;
  const int ROWS = 10;
  const int WIDTH = 30;
  
  int mf_x = COLS * WIDTH;
  int mf_y = ROWS * WIDTH;
  
  hdcMeta = ::CreateMetaFile(name);
  ::SetWindowExt(hdcMeta, mf_x, mf_y);
  
  for (r = 0; r < ROWS; r++) 
  {
    for (c = 0; c < COLS; c ++) 
    {
      itoa(r * COLS + c, szBuf, 10);
      x = c * WIDTH + 1;
      y = r * WIDTH;
      ::TextOut(hdcMeta, x, y, szBuf, strlen(szBuf));
    }
  }
  for (r = 0; r <= ROWS; r++) 
  {
    ::MoveTo(hdcMeta, 0, (r * WIDTH));
    ::LineTo(hdcMeta, mf_x, (r * WIDTH));
  }
  for (c = 0; c <= COLS; c++) 
  {
    ::MoveTo(hdcMeta, (c * WIDTH), 0);
    ::LineTo(hdcMeta, (c * WIDTH), mf_y);
  }
  
  METAFILEPICT* mfpic = new METAFILEPICT;
  mfpic->hMF = ::CloseMetaFile(hdcMeta);
  mfpic->xExt = mf_x + 1;
  mfpic->yExt = mf_y + 1;
  mfpic->mm = MM_TEXT;
  return mfpic;
}
#endif

#ifdef BUILD_IN_METAFILE
// get built in metafile
HDC
Metafile::GetBuiltInMetafile(BuiltInMetafile bim)
{
  HDC meta = ::CreateMetaFile(NULL);
  ::SetWindowExt(meta, BuiltInMetafileX, BuiltInMetafileY);

  switch (bim)
  {
   case LeftSlantLine:
   case LeftSlantDotted:
    {
      HPEN pen;
      if (bim == LeftSlantLine)
      {
	pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      }
      else
      {
	pen = ::CreatePen(PS_DOT, 1, RGB(0, 0, 0));
      }
      HPEN old = ::SelectObject(meta, pen);
      ::MoveTo(meta, 0, 0);
      ::LineTo(meta, BuiltInMetafileX, BuiltInMetafileY);
      ::SelectObject(meta, old);
    }
    break;
   case RightSlantLine:
   case RightSlantDotted:
    {
      HPEN pen;
      if (bim == RightSlantLine)
      {
	pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      }
      else
      {
	pen = ::CreatePen(PS_DOT, 1, RGB(0, 0, 0));
      }
      HPEN old = ::SelectObject(meta, pen);
      ::MoveTo(meta, 0, BuiltInMetafileY);
      ::LineTo(meta, BuiltInMetafileX, 0);
      ::SelectObject(meta, old);
    }
    break;
   case CrossLine:
   case CrossDotted:
    {
      HPEN pen;
      if (bim == CrossLine)
      {
	pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      }
      else
      {
	pen = ::CreatePen(PS_DOT, 1, RGB(0, 0, 0));
      }
      HPEN old = ::SelectObject(meta, pen);
      ::MoveTo(meta, 0, 0);
      ::LineTo(meta, BuiltInMetafileX, BuiltInMetafileY);
      ::MoveTo(meta, 0, BuiltInMetafileY);
      ::LineTo(meta, BuiltInMetafileX, 0);
      ::SelectObject(meta, old);
    }
    break;
    
   case RingLine:
   case RingDotted:
    {
      HPEN pen;
      if (bim == RingLine)
      {
	pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      }
      else
      {
	pen = ::CreatePen(PS_DOT, 1, RGB(0, 0, 0));
      }
      HPEN old = ::SelectObject(meta, pen);
      int x = BuiltInMetafileX / 4;
      int y = BuiltInMetafileY / 4;
      ::MoveTo(meta, x, y);
      ::LineTo(meta, x * 3, y);
      ::LineTo(meta, x * 3, y * 3);
      ::LineTo(meta, x, y * 3);
      ::LineTo(meta, x, y);
      ::SelectObject(meta, old);
    }
    break;
    
   case StrikeOut:
   case StrikeOutDotted:
    {
      HPEN pen;
      if (bim == StrikeOut)
      {
	pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      }
      else
      {
	pen = ::CreatePen(PS_DOT, 1, RGB(0, 0, 0));
      }
      HPEN old = ::SelectObject(meta, pen);
      int x = BuiltInMetafileX / 4;
      int y = BuiltInMetafileY / 2;
      ::MoveTo(meta, x, y);
      ::LineTo(meta, x * 3, y);
      ::SelectObject(meta, old);
    }
    break;
    
   case Circle:
   case FillCircle:
   case GrayCircle:
    {
      HPEN pen;
      pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      HPEN old = ::SelectObject(meta, pen);
      ::Ellipse(meta, 0, 0, BuiltInMetafileX, BuiltInMetafileY);
      ::SelectObject(meta, old);
      if ((bim == FillCircle) || (bim == GrayCircle))
      {
	HBRUSH hbr;
	if (bim == FillCircle)
	{
	  hbr = ::SelectObject(meta, GetStockObject(BLACK_BRUSH));
	}
	else
	{
	  hbr = ::SelectObject(meta, GetStockObject(GRAY_BRUSH));
	}
	::FloodFill(meta, BuiltInMetafileX / 2, BuiltInMetafileY / 2,
		     RGB(0, 0, 0));
	::SelectObject(meta, hbr);
      }
    }
    break;
    
   case Root:
    {
      HPEN pen;
      pen = ::CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
      HPEN old = ::SelectObject(meta, pen);
      int x = BuiltInMetafileX / 8;
      int y = BuiltInMetafileY / 8;
      ::MoveTo(meta, BuiltInMetafileX, 0);
      ::LineTo(meta, x * 4, BuiltInMetafileY);
      ::LineTo(meta, x * 2, y * 6);
      ::LineTo(meta, x, y * 7);
      ::SelectObject(meta, old);
    }
    break;
   case Integral:
   case IntegralC:
   case Sigma:
    break;
  }
  return ::CloseMetaFile(meta);
}
#endif
