// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mstream.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Memory Stream class

#ifndef MSTREAM_H
#define MSTREAM_H

#include "resizeme.h"

class MemStream 
{
  // resize memory
  ResizeMemory rm;
  
  // stream position
  offset stream_pos;
  
  // one time buffer size
  size_t one_time_buf_size;
  
  enum { DefaultBufSize = 256 };

public:
  // constructor
  MemStream(size_t buf_size = DefaultBufSize);
  
  // destructor
  ~MemStream();
  
  // printf
  // We shuld provide Puts or Putchar stdio like stuff some day.
  void CDECL Printf(char* format, ...);
  
  // get start memory address
  void* GetStartAddress() {  return rm.GetMem(); }
  
  // get memory size
  size_t GetSize() { return rm.GetSize(); }
  
  // take memory
  void* TakeMemory() { return rm.TakeMemory(); }
  
  // free taken memory
  static void FreeMemory(void* mem);
  
  // get stream size
  offset GetStreamSize() { return stream_pos - 1; }
};

#endif /* MSTREAM_H */
