// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mwindow.cpp,v 3.11 1999/07/05 00:09:41 kudou Exp $
// function definitions for class MainWindow
// MainWindow is the class inherited from Window which represents
// the main pWord window.

#include "pword.h"
#include <stdarg.h>
#include <stdlib.h>
#include <dde.h>
#include "mwindow.h"
#include "again.h"
#include "attribut.h"
#include "boxes.h"
#include "docconte.h"
#include "docedit.h"
#include "document.h"
#include "docwindo.h"
#include "eca.h"
#include "editpage.h"
#include "epa.h"
#include "fileopen.h"
#include "fileutil.h"
#include "fonts.h"
#include "lman.h"
#include "mdiclien.h"
#include "menu.h"
#include "messbox.h"
#include "pagebox.h"
#include "pime.h"
#include "pmenus.h"
#include "pref.h"
#include "printeri.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "saveasdl.h"
#include "screen.h"
#include "xstr.h"

// static data
HANDLE MainWindow::hAccel = 0;
MDIClient* MainWindow::client_window = NULL;
int MainWindow::size = 0;

MainWindow::HelpData MainWindow::help_data[] =
{
  { IDM_Help_Index, HELP_INDEX, 0 },
//  { IDM_Help_Keyboard, HELP_KEY, S_HelpKeyboardKey },
//  { IDM_Help_Commands, HELP_KEY, S_HelpCommandsKey },
  { IDM_Help_Concepts, HELP_KEY, S_HelpConceptsKey },
  { IDM_Help_Procedures, HELP_KEY, S_HelpProceduresKey },
//  { IDM_Help_Screen, HELP_KEY, S_HelpScreenKey },
  { IDM_Help_UsingHelp, HELP_HELPONHELP, 0 },
  { IDM_Help_License, HELP_KEY, S_HelpLicenseKey },
  { 0, 0, 0 }
};

// MainWindow constructor
MainWindow::MainWindow()
{
  hAccel = ::LoadAccelerators(PWordPresentation::hInstance, "PWordAccel");
  Make();
  client_window = new MDIClient(this->GetHandle());
  PositionWindows();
  // Connect to kana-kanji conversion system
  PIME::Create(this->GetHandle());
  PIME::DefaultConvertWin();
}

void
MainWindow::Make()
{
  // Create the window.  Remember, this is the frame surrounding
  // the MDI window and the status window.
  hWnd = CreateWindow(szClassName,
		       S_window_title,
		       WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		       CW_USEDEFAULT,
		       CW_USEDEFAULT,
		       CW_USEDEFAULT,
		       CW_USEDEFAULT,
		       NULL,
		       NULL,
		       PWordPresentation::hInstance,
		       (LPSTR) this);
  
  if (!this->GetHandle())
  {
#ifdef BW3_DEBUG
    assert(False);
#endif /* BW3_DEBUG */
    exit(FALSE);
  }
  
  Update();
}

MainWindow::~MainWindow()
{
  // Turn off FEP and terminate connection
  
  PIME::SetClosed();
  PIME::Destroy();
  
  if (client_window)
  {
    delete client_window; 
    client_window = 0;
  }
  Destroy();
}

// mainwindow window registerer

/*static*/
void
MainWindow::Register()
{
  WNDCLASS wndclass;
  wndclass.style = 0;
  wndclass.lpfnWndProc = xWndProc;
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = sizeof(MainWindow*);
  wndclass.hInstance = PWordPresentation::hInstance;
  wndclass.hIcon = LoadIcon(PWordPresentation::hInstance, "pWordIcon");
  wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH)::GetStockObject(WHITE_BRUSH);
  wndclass.lpszMenuName = S_menu_name;
  wndclass.lpszClassName = szClassName;
  if (!RegisterClass(&wndclass))
  {
#ifdef BW3_DEBUG
    assert(False);
#endif /* BW3_DEBUG */
    exit(FALSE);
  }
}

#ifdef _WIN32
static void
get_help_pathname(char* path)
{
  char executable_filename[MAX_PATH + 1];
  ::GetModuleFileName(NULL, executable_filename, MAX_PATH + 1);
  FileUtil::GetPathNameOnly(path, executable_filename);
  int n = strlen(path);
  path[n] = '\\';
  strcpy(&path[n + 1], S_HelpFileName);
}
#endif /* _WIN32 */

void
MainWindow::Terminate()
{
  THIS_CHECK;
#ifdef _WIN32
  char path[MAX_PATH + 1];
  get_help_pathname(path);
  WinHelp(this->GetHandle(), path, HELP_QUIT, NULL);
#else /* _WIN32 */
  WinHelp(this->GetHandle(), S_HelpFileName, HELP_QUIT, NULL);
#endif /* _WIN32 */
}

// MainWindow window procedure
LRESULT_T
MainWindow::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  THIS_CHECK;

  switch (iMessage)
  {
#if 0
   case WM_GETMINMAXINFO:
    {
      LPPOINT pts = (LPPOINT)lParam;
      pts[1].y -= Screen::kanji_window_height;
    }
    break;
#endif
    
#if 0
   case WM_ERASEBKGND:
    {
      long result = DefWindowProc(iMessage, wParam, lParam);
      if (::IsZoomed(this->GetHandle()) && PIME::GetOpen())
      {
	PIME::WindowUpdate(True);
      }
      return result;
    }
#endif
    
   case WM_SYSCOLORCHANGE:
    Screen::get_system_colors();
    break;
    
   case WM_ACTIVATEAPP:
    if (wParam)
    {
      PIME::SetFocus();
    }
    else
    {
      PIME::KillFocus();
    }
    break;
    
   case WM_PARENTNOTIFY:
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case WM_NCRBUTTONDBLCLK:
       case WM_NCRBUTTONDOWN:
       case WM_RBUTTONDBLCLK:
       case WM_RBUTTONDOWN:
	if (Selected_Window == NULL || !Selected_Window->mouse.activep)
	{
	  Boxes::toggle_global_visible();
	}
      }
    }
    break;
    
   case WM_FONTCHANGE:
    PWordBase::NewPrinter();
    return 0;
    
   case WM_MENUSELECT:
    if (Pref_guide_menu)
    {
#ifdef _WIN32
      Boxes::guide((int) LOWORD(wParam));
#else /* _WIN32 */
      Boxes::guide((int) wParam);
#endif /* _WIN32 */
    }
    return(0);
    
   case WM_WININICHANGE:
    // Check if user changed the list of printers from another 
    // application(most likely - Control Panel).
    if (lParam && stricmp((LPSTR) lParam, "devices"))
    {
      break;
    }
    
    // If printers have changes, deal with them
    delete Printer_Info;
    Printer_Info = new PrinterInfo;
    Printer_Info->SetupDefPrinter();
    PWordPresentation::NewPrinter();
    break;
    
   case WM_MOVE:
    if (PWordPresentation::GetPageBox()) 
    {
      PWordPresentation::GetPageBox()->Position();
    }
    DocumentWindow::control_ime();
    return 0;

   case WM_QUERYENDSESSION:
    // the only way we will get here is if Windows itself
    // is shutting down.  False in the call means this.
    
    return PWordBase::QueryEndSession(False, True);
    
   case WM_CLOSE:
    // comes when user shuts us down from task switcher ?
    return(dispatch_simple_command(IDM_File_Exit));
    
   case WM_CREATE:
    break;
    
   case WM_PAINT:
    {
      PAINTSTRUCT ps[1];
      this->BeginPaint(ps);
      this->EndPaint(ps);
    }
    break;
    
   case WM_DESTROY:
    break;
    
   case WM_SIZE:
    if (wParam==SIZEZOOMHIDE || wParam==SIZEZOOMSHOW)
    {
      break;
    }
    
    // turn on/off IME when going to/coming from iconic mode.
    // Is this necessary?
    
    if (size == SIZEICONIC)  // was iconic
    {
      PIME::PopOpenStatus();
    }
    else if (wParam == SIZEICONIC) // going to iconic
    {
      PIME::PushOpenStatus();
      PIME::SetOpen(0);
    }
    
    // remember size
    size = wParam;
    
    // position page box and windows
    if (size != SIZEICONIC)
    {
      if (PWordPresentation::GetPageBox())
      {
	PWordPresentation::GetPageBox()->Position();
      }
      PositionWindows();
#ifdef notdef
      DocumentWindow::control_ime();
#endif
    }
    DocumentWindow::touch_caret();
    break;
    
   case WM_LBUTTONDOWN:
    //	mouse down in pWord window, outside a document window
    MessageBeep(0);
    break;
    
   case WM_INITMENUPOPUP:
    // menu is about to be popped up. See what needs to be enabled,
    // checked, etc.
    
    // avoid message box under menu getting trapped
    ::StatusOut("");
    
    // make sure not system menu on maximized document window,
    // which MDI can't tell us is really the system menu
    if ((bool)(HIWORD(lParam) != 0) ||
	((LOWORD(lParam) == 0) &&
	 CurrentActiveDocumentWindowMaximized() &&
	 ((HMENU)wParam == ::GetSubMenu(Menu::get_menubar(), 0))))
    {
      goto DefProc;
    }
    InitMenuPopup((HMENU)wParam);
    break;
    
   case WM_COMMAND:
#ifdef BW3_DISPATCH
#ifdef _WIN32
    return Dispatch(LOWORD(wParam), HIWORD(wParam), (HWND)lParam);
#else /* _WIN32 */
    return Dispatch(wParam, HIWORD(lParam), (HWND)LOWORD(lParam));
#endif /* _WIN32 */
#else /* BW3_DISPATCH */
    return Dispatch(wParam, lParam);
#endif /* BW3_DISPATCH */
    
   case WM_DDE_ACK:
   case WM_DDE_TERMINATE:
   case WM_DDE_DATA:
    // This is kana-kanji conversion related stuff
    return PIME::DDEDispatch(iMessage, wParam, lParam);
    
   case WM_NCRBUTTONDBLCLK:
   case WM_NCRBUTTONDOWN:
   case WM_RBUTTONDBLCLK:
   case WM_RBUTTONDOWN:
    Boxes::toggle_global_visible();
    return 0;
    
   case WM_NCLBUTTONDBLCLK:
    // possible double-click on system menu.  Have to check this
    // ourselves, due to bug in MDI.
    
    RECT rect;
    
    if (wParam != HTMENU)
    {		// in menu bar?
      goto DefProc;
    }
    
    if (!CurrentActiveDocumentWindowMaximized())
    {
      goto DefProc;
    }
    
    GetRect(&rect);			// dim's of frame window
    rect.left += Screen::frame_width;
    rect.top += Screen::caption_height + Screen::frame_height;
    
    rect.bottom = rect.top + Screen::closebox_bitmap_height;
    rect.right = rect.left + Screen::closebox_bitmap_width;
#ifdef _WIN32
    POINT p;
    LPARAM_TO_POINT(lParam, p);
    if (! PtInRect(&rect, p))
#else /* _WIN32 */
    if (! PtInRect(&rect, MAKEPOINT(lParam)))
#endif /* _WIN32 */
    {
      return DefWindowProc(iMessage, wParam, lParam);
    }
    
    Selected_Window->SendMessage(WM_SYSCOMMAND, SC_CLOSE, lParam);
    return 0;
    
    
   DefProc:
   default:
    return DefWindowProc(iMessage, wParam, lParam);
  }
  return 0;
}

// InitMenuPopup
//
// This routine is called in response to a WM_INITMENUPOPUP message.
// The strategy is to send everybody in the menu the normal menu
// message they would get, but steal lParam for our own purposes,
// namely to tell them this is a query about menu status.  This allows
// the processing for a menu item itself and the logic about whether
// or not it should be enabled or what-have-you to be localized together.
//
// It also requires everybody handling WM_COMMAND messages to check
// lParam to see if it is PW_MENU_STATE, and if so, return
// a new menu flags mask.  Failing to do this means that every
// item on a menu might be executed just because the menu was pulled
// down.

void
MainWindow::InitMenuPopup(HMENU hMenu)
{
  THIS_CHECK;
  
  int i=GetMenuItemCount(hMenu);		// # of items on menu
  do
  {
    int id = GetMenuItemID(hMenu, --i);
    if (id== -1 || id==0 || COMMAND_HIGH_CODE(id) == MDI_HIGH_Command)
    {
      continue;
    }
    
#ifdef BW3_DISPATCH
    uword newstate = (uword)Dispatch(id, PW_MENU_STATE, 0);
#else /* BW3_DISPATCH */
    uword newstate = (uword)Dispatch(id, PW_MENU_STATE);
#endif /* BW3_DISPATCH */
    
    uword oldstate = (GetMenuState(hMenu, id, MF_BYCOMMAND)
		      & (MF_DISABLED|MF_GRAYED|MF_CHECKED|MF_UNCHECKED));
    if (oldstate!=newstate)
    {
      if ((newstate & (MF_CHECKED | MF_UNCHECKED)) 
	  != (oldstate & (MF_CHECKED | MF_UNCHECKED))) 
      {
	CheckMenuItem(hMenu, id, MF_BYCOMMAND|newstate);
      }
      if ((newstate & (MF_ENABLED | MF_DISABLED | MF_GRAYED)) 
	  != (oldstate & (MF_ENABLED | MF_DISABLED | MF_GRAYED))) 
      {
	EnableMenuItem(hMenu, id, MF_BYCOMMAND|newstate);
      }
    }
  }
  while (i>0);
}

// disableĂR}h̏B
#ifdef BW3_DISPATCH
LRESULT_T
disabled_command(bool menu_state_p)
#else /* BW3_DISPATCH */
long
disabled_command(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return MF_GRAYED;
  }
  MessageBeep(0);
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T
MainWindow::DispatchSystemCommand(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long NEAR
MainWindow::DispatchSystemCommand(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  if (COMMAND_HIGH_CODE(command) == MDI_HIGH_Command)
  {
    // if a MDI child has been selected, we let the
    // DefFrameProc handle it, after enabling menu items
    MENU_STATE_ENABLED
#ifdef BW3_DISPATCH
#ifdef _WIN32
      return DefWindowProc(WM_COMMAND, (WPARAM_T)MAKELONG(command, notify_code), (LPARAM_T)hwnd);
#else /* _WIN32 */
      return DefWindowProc(WM_COMMAND, (WPARAM_T)command, (LPARAM_T)MAKELONG(hwnd, notify_code));
#endif /* _WIN32 */
#else /* BW3_DISPATCH */
    return(DefWindowProc(WM_COMMAND, command, lParam));
#endif /* BW3_DISPATCH */
  }
  
  // If the MDI child is maximized, what would normally
  // be WM_SYSCOMMAND messages coming to the child instead
  // come here as WM_COMMAND messages.
  switch ((WORD) (command & 0xfff0))
  {
   case SC_SIZE:
   case SC_MOVE:
   case SC_MINIMIZE:
   case SC_MAXIMIZE:
   case SC_NEXTWINDOW:
   case SC_PREVWINDOW:
   case SC_CLOSE:
   case SC_VSCROLL:
   case SC_HSCROLL:
   case SC_ARRANGE:
   case SC_RESTORE:
   case SC_TASKLIST:
    MENU_STATE_ENABLED
#ifdef BW3_DISPATCH
#ifdef _WIN32
    return Selected_Window->SendMessage(WM_SYSCOMMAND, 
					(WPARAM_T)MAKELONG(command, notify_code), (LPARAM_T)hwnd);
#else /* _WIN32 */
    return Selected_Window->SendMessage(WM_SYSCOMMAND,
					(WPARAM_T)command, (LPARAM_T)MAKELONG(hwnd, notify_code));
#endif /* _WIN32 */
#else /* BW3_DISPATCH */
    return(Selected_Window->SendMessage(WM_SYSCOMMAND, command, lParam));
#endif /* BW3_DISPATCH */
  }
#ifdef BW3_DISPATCH
  return(disabled_command(MENU_STATE_P(notify_code)));
#else /* BW3_DISPATCH */
  return(disabled_command(MENU_STATE_P(lParam)));
#endif /* BW3_DISPATCH */
}

#ifdef BW3_DISPATCH
LRESULT_T
MainWindow::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
MainWindow::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  THIS_CHECK;

#ifdef _WIN32
  if (command >= SYSMENU_BASE)
  {
    // for MDI child window system menu dispatch. (kudou)
    return DispatchSystemCommand(command, notify_code, hwnd);
  }
#endif /* _WIN32 */
  
  if (command < IDM_BASE)
  {
#ifdef BW3_DISPATCH
    return DispatchSystemCommand(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
    return DispatchSystemCommand(command, lParam);
#endif /* BW3_DISPATCH */
  }
  
#ifdef BW3_DISPATCH
  bool menu_state_p = MENU_STATE_P(notify_code);
#else /* BW3_DISPATCH */
  int menu_state_p = MENU_STATE_P(lParam);
#endif /* BW3_DISPATCH */
  int high = COMMAND_HIGH_CODE(command);
  
  DocumentEdit* edit = NULL;
  int can_edit = False;
  if (Selected_Window != NULL)
  {
    if (Selected_Window->mouse.activep)
    {
      return(disabled_command(menu_state_p));
    }
    edit = Selected_Window->GetEditor();
    can_edit = True;
  }
  
  // again processing.  This logic assumes that all commands
  // to be subject to againing come through here.  For details
  // on againing, see the comments in again.h.
  if (high == IDM_HIGH_Again)
  {
    switch (command)
    {
     case IDM_Again:
      command = Again::GetCommandToDoAgain();
      break;
      
     case IDM_AgainReverse:
      command = Again::GetCommandForOtherDirection();
      break;
      
     default:
      command = 0;
    }
    if (command == 0)
    {
      return disabled_command(menu_state_p);
    }
    if (menu_state_p)
    {
      return MF_ENABLED;
    }
    high = COMMAND_HIGH_CODE(command);
    Again::SetDoingAgain(True);
  }
  else
  {
    // for all other commands, remember that they should be what
    // is done again next time, unless a CantDoAgain() is issued
    // by someone down the line
    if (!menu_state_p)
    {
      // We call inline method.
      Again::SetAgainFast(command);
    }
    Again::SetDoingAgain(False);
  }
  
  switch (high)
  {
   case IDM_HIGH_More:
   case IDM_HIGH_FontE:
   case IDM_HIGH_FontJ:
   case IDM_HIGH_CharStyle:
   case IDM_HIGH_ParaStyle:
   case IDM_HIGH_Mark:
#ifdef BW2_ABBREV
   case IDM_HIGH_Abbrev:
#endif /* BW2_ABBREV */
    if (command == IDM_MoreRecentOpen)
    {
      return Menu::dispatch_anytime(menu_state_p, command);
    }
    else
    {
      return Menu::dispatch(menu_state_p, command);
    }

#ifdef BW3_RECENTOPEN
   case IDM_HIGH_RecentOpen:
     if (menu_state_p)
     {
       return MF_ENABLED;
     }
     else
     {
       return Menu::dispatch_anytime(menu_state_p, command);
     }
     break;
#endif /* BW3_RECENTOPEN */
    
   case IDM_HIGH_Char:
    return can_edit
#ifdef BW3_DISPATCH
	   ? edit->GetEditCharAtts()->Dispatch(command, notify_code, hwnd)
#else /* BW3_DISPATCH */
	   ? edit->GetEditCharAtts()->Dispatch(command, lParam)
#endif /* BW3_DISPATCH */
	   : disabled_command(menu_state_p);
    
   case IDM_HIGH_Para:
    return can_edit
#ifdef BW3_DISPATCH
	   ? edit->GetParAtts()->Dispatch(command, notify_code, hwnd)
#else /* BW3_DISPATCH */
	   ? edit->GetParAtts()->Dispatch(command, lParam)
#endif /* BW3_DISPATCH */
	    : disabled_command(menu_state_p);
    
   case IDM_HIGH_Frame:
    return can_edit
	   ? (edit
	      ->GetDocument()
	      ->GetEditPage()
#ifdef BW3_DISPATCH
	      ->DispatchFrameMenu(command, notify_code, hwnd))
#else /* BW3_DISPATCH */
	      ->DispatchFrameMenu(command, lParam))
#endif /* BW3_DISPATCH */
	   : disabled_command(menu_state_p);
    
   case IDM_HIGH_Page:
    return can_edit
	    ? (edit
	       ->GetDocument()
	       ->GetEditPage()
#ifdef BW3_DISPATCH
	       ->DispatchLayoutMenu(command, notify_code, hwnd))
#else /* BW3_DISPATCH */
	       ->DispatchLayoutMenu(command, lParam))
#endif /* BW3_DISPATCH */
	    : disabled_command(menu_state_p);
    
   case IDM_HIGH_Nav:
    return can_edit
	    ? (edit->Navigate(command), 0)
	    : disabled_command(menu_state_p);
    
   case IDM_HIGH_CharSize:
    return can_edit
	    ? (edit
	       ->GetEditCharAtts()
	       ->ChangeTextSize(menu_state_p, command - IDM_CharSize))
	    : disabled_command(menu_state_p);
    
   default:
    switch (command)
    {
#ifndef NDEBUG
     case IDM_Abort:
      syserr("abort raised");
      break;
#endif
      
#ifndef NDEBUG
     case IDM_Debugger:
      ::DebugBreak();
      break;
#endif
      
     case IDM_NoOperation:
      return 0;

     case IDM_Disp_TileWindow:   
     case IDM_Disp_CascadeWindow: 
#ifdef BW3_DISPATCH
      return client_window->Dispatch(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
      return client_window->Dispatch(command, lParam);
#endif /* BW3_DISPATCH */
      
     case IDM_Edit_InputText_MODE:
     case IDM_Edit_MakeTable_MODE:
     case IDM_Edit_MoveLine_MODE:
     case IDM_Edit_SelectFrame_MODE:
     case IDM_Edit_DrawLine_MODE:
     case IDM_Edit_Cut_MODE:
     case IDM_Edit_SetFlow_MODE:
     case IDM_Edit_ExchFlow_MODE:
     case IDM_Edit_FrameMargin_MODE:
     case IDM_Edit_SetMargin_MODE:
     case IDM_Edit_Mode_Inc:
     case IDM_Edit_Mode_Dec:
      return PWordPresentation::HandleEditMode(command, menu_state_p);
      
     case IDM_Disp_Customizable:
     case IDM_Disp_Bar:
     case IDM_Disp_ModeBox:
     case IDM_Disp_CharBox:
     case IDM_Disp_ParaBox:
     case IDM_Disp_UserBox1:
     case IDM_Disp_UserBox2:
     case IDM_Disp_UserBox3:
     case IDM_Disp_UserBox4:
     case IDM_Disp_BigBox:
     case IDM_Disp_Ribbon_Top:
     case IDM_Disp_Ribbon_Bot:
     case IDM_Disp_Ribbon_Left:
     case IDM_Disp_Ribbon_Right:
      return Boxes::dispatch(command, menu_state_p);
      
     case IDM_Disp_FrameLine:
      return PWordPresentation::handle_display(menu_state_p,
					       &Pref_display_frame_line);
      
     case IDM_Disp_FrameMargin:
      return PWordPresentation::handle_display(menu_state_p,
					       &Pref_display_frame_margin);
      
     case IDM_Disp_ParaMargin:
      return PWordPresentation::handle_display(menu_state_p,
					       &Pref_display_para_margin);
      
     case IDM_Disp_FlowLine:
      return PWordPresentation::handle_display(menu_state_p,
					       &Pref_display_flow_line);
      
     case IDM_Disp_AutoLines:
      return PWordPresentation::handle_display(menu_state_p,
					       &Pref_display_auto_lines);
      
      // the "presentation" is called to handle menu items
      // which relate strictly to how the user is viewing
      // pWord on the screen
     case IDM_Edit_Ansi:
     case IDM_Edit_VText_Time:
     case IDM_Location_Search:
     case IDM_Help_About:
     case IDM_Help_DevInfo:
     case IDM_File_Preferences:
      if (menu_state_p)
      {
	return MF_ENABLED;
      }
      return PWordPresentation::Dispatch(command);
      
     case IDM_Help_Index:
     case IDM_Help_Keyboard:
     case IDM_Help_Commands:
     case IDM_Help_Concepts:
     case IDM_Help_Procedures:
     case IDM_Help_Screen:
     case IDM_Help_UsingHelp:
     case IDM_Help_License:
      {
	if (menu_state_p)
	{
	  return MF_ENABLED;
	}
#ifdef _WIN32
	char path[MAX_PATH + 1];
	get_help_pathname(path);
	for (HelpData* hd = help_data; hd->ID; hd++)
	{
	  if (hd->ID == command)
	  {
	    char* keyword = hd->string;
	    if (keyword != 0)
	    {
	      ::WinHelp(GetHandle(), path, hd->command,
			(DWORD) (keyword));
	    }
	    else
	    {
	      ::WinHelp(GetHandle(), path, hd->command, 0);
	    }
	    break;
	  }
	}
#else /* _WIN32 */
	for (HelpData* hd = help_data; hd->ID; hd++)
	{
	  if (hd->ID == command)
	  {
	    char* keyword = hd->string;
	    if (keyword != 0)
	    {
	      ::WinHelp(GetHandle(), S_HelpFileName, hd->command,
			(DWORD) (keyword));
	    }
	    else
	    {
	      ::WinHelp(GetHandle(), S_HelpFileName, hd->command, 0);
	    }
	    break;
	  }
	}
#endif /* _WIN32 */
      }
      break;
      
      // new, open, exit are pword-wide
      // activities and therefore are dispatched to pwordbase.
     case IDM_File_New:
     case IDM_File_Open:
     case IDM_File_PrinterSetup:
     case IDM_File_Exit:
     case IDM_File_WC:
     case IDM_File_AutoSave:
     case IDM_Location_RemoveMark:
#ifdef BW3_DISPATCH
      return PWordBase::Dispatch(menu_state_p, command);
#else /* BW3_DISPATCH */
      return PWordBase::Dispatch(command, menu_state_p);
#endif /* BW3_DISPATCH */
      
     case IDM_File_Close:
     case IDM_File_Save:
     case IDM_File_SaveAs:
     case IDM_File_Revert:
     case IDM_File_Print:
     case IDM_Location_FindGo:
     case IDM_Location_SearchForward:
     case IDM_Location_SearchBackward:
      if (Selected_Document != NULL)
      {
#ifdef BW3_DISPATCH
	return Selected_Document->Dispatch(menu_state_p, command);
#else /* BW3_DISPATCH */
	return Selected_Document->Dispatch(command, menu_state_p);
#endif /* BW3_DISPATCH */
      }
      return disabled_command(menu_state_p);
      
     case IDM_Edit_Undo:
     case IDM_Edit_UndoRun:
     case IDM_Edit_Redo:
     case IDM_Edit_RedoRun:
      if (Selected_Document != NULL)
      {
	return Selected_Document->GetDocumentContent() ->Dispatch(command, menu_state_p);
      }
      return disabled_command(menu_state_p);

     case IDM_Edit_IMEToggle:
      if (!menu_state_p)
      {
	PIME::SetOpen(!PIME::GetOpen());
      }
      break;
      
     default: 
      if (Selected_Window != NULL)
      {
#ifdef BW3_DISPATCH
	return Selected_Window->Dispatch(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
	return Selected_Window->Dispatch(command, lParam);
#endif /* BW3_DISPATCH */
      }
      return disabled_command(menu_state_p);
    }
  }
  return(0);
}

// public function
#ifdef BW3_DISPATCH
LRESULT_T
dispatch_command(WORD command, WORD notify_code, HWND hwnd)
{
  return main_window->Dispatch(command, notify_code, hwnd);
}
#else /* BW3_DISPATCH */
long
dispatch_command(int command, long lParam)
{
  return(main_window->Dispatch(command, lParam));
}
#endif /* BW3_DISPLATCH */

// public function
#ifdef BW3_DISPATCH
LRESULT_T
dispatch_simple_command(WORD command)
{
  return dispatch_command(command, 0, 0);
}
#else /* BW3_DISPATCH */
long
dispatch_simple_command(int command)
{
  return(dispatch_command(command, 0));
}
#endif /* BW3_DISPATCH */

// public function
#ifdef BW3_DISPATCH
int
dispatch_inc_dec(WORD inc_command, WORD dec_command)
#else /* BW3_DISPATCH */
int
dispatch_inc_dec(int inc_command, int dec_command)
#endif /* BW3_DISPATCH */
{
  if (PWordPresentation::ControlKey())
  {
    dispatch_simple_command(dec_command);
  }
  else if (PWordPresentation::ShiftKey())
  {
    dispatch_simple_command(inc_command);
  }
  else
  {
    return(False);
  }
  return(True);
}

// MainWindow class name

char MainWindow::szClassName[] = MAINWINDOW_CLASS_NAME;

void
MainWindow::PositionWindows()
{
  if (client_window != NULL)
  {
    RECT rect;
    GetClientRect(&rect);
    if (0 < Pref_ime_keep_lines && ::IsZoomed(this->GetHandle()))
    {
      rect.bottom -= Screen::kanji_window_height * Pref_ime_keep_lines;
    }
    Boxes::arrange_ribbons(&rect);
    ::MoveWindow(client_window->GetHandle(),
		 rect.left,
		 rect.top,
		 rect.right - rect.left, rect.bottom - rect.top, True);
  }
}

// our DefWindowProc 
LRESULT_T
MainWindow::DefWindowProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  THIS_CHECK;
  return(::DefFrameProc(this->GetHandle(),
			client_window ? client_window->GetHandle() : 0,
			iMessage, wParam, lParam));
}

void
StatusClear()
{
  PWordPresentation::GetMessBox() ->Clear();
}

void CDECL
StatusOut(char* str, ...) 
{
  char buf[256];  // "Is this enough, Dave?"
  va_list ap;
  va_start(ap, str);
  wvsprintf(buf, str, (VA_LIST) ap);
  va_end(ap);
  
  PWordPresentation::StatusOut(buf);
}

void CDECL
StatusOutPermanent(char* str, ...) 
{
  char buf[256];  // "Is this enough, Dave?"
  va_list ap;
  va_start(ap, str);
  wvsprintf(buf, str, (VA_LIST) ap);
  va_end(ap);
  
  PWordPresentation::StatusOutPermanent(buf);
}

bool
MainWindow::CurrentActiveDocumentWindowMaximized()
{
  THIS_CHECK;
#ifdef _WIN32
  BOOL klujy_gates_flag;	// this flag name comes from 16-bit code.
  ::SendMessage(client_window->GetHandle(),  WM_MDIGETACTIVE, 0, (LPARAM_T)&klujy_gates_flag);
  return klujy_gates_flag != 0;
#else /* _WIN32 */
  DWORD klujy_gates_doubleword = ::SendMessage(client_window->GetHandle(), WM_MDIGETACTIVE, 0, 0);
  return (HIWORD(klujy_gates_doubleword) == 1);
#endif /* _WIN32 */
}
