// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: new.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// memory management

#include "pword.h"
#include <stdlib.h>
#include "pwordbas.h"

#undef DEBUG_MEMORY
#ifdef NDEBUG
#define DEBUG_MEMORY 0
#else
#define DEBUG_MEMORY 1
#endif

// Helpful to see dump image.
#undef INITIAL_FILL
#undef SMARTNEW_FILL
#undef MALLOC_FILL
#ifndef NDEBUG
#define INITIAL_FILL '!'
#define SMARTNEW_FILL '@'
#define MALLOC_FILL '#'
#endif

union mhead
{
  unsigned short index;
  union mhead* chain;
};

// for cpp
#define HEADER_SIZE 2
#define MHEAD_SIZE 4
#define LOG2_OF_MHEAD_SIZE 2

#define PTR_TO_MHEAD(ptr) ((union mhead*) ((char*) (ptr) - HEADER_SIZE))
#define MHEAD_TO_PTR(m) ((char*) (m) + HEADER_SIZE)

#define VALID_INDEX_P(index) \
(LOG2_OF_MHEAD_SIZE <= (unsigned int) (index) \
 && (unsigned int) (index) <= LOG2_OF_MAX_ALLOC) \

static union mhead* nextf[16];

static void NEAR
global_compact()
{
  GlobalCompact(1L << LOG2_OF_MAX_ALLOC);
}

static void* NEAR
global_alloc_by_log2(unsigned int log_2)
{
//  HANDLE h = GlobalAlloc(GMEM_FIXED | GMEM_NOCOMPACT | GMEM_NODISCARD,
//			  1L << log_2);
  HANDLE h = GlobalAlloc(GMEM_MOVEABLE, 1L << log_2);
#ifdef INITIAL_FILL
  if (h)
  {
    void* p = (void*) GlobalLock(h);
    memset(p, INITIAL_FILL, 1 << log_2);
    return(p);
  }
  return(NULL);
#else
  return(h ? GlobalLock(h) : NULL);
#endif
}

static void NEAR
morecore(unsigned int index)
{
  static char* reserved_memory = NULL;
  static unsigned int reserved_size = 0;
  static bool emergency = False;
  
  assert(VALID_INDEX_P(index));

  char* cp;
  if (reserved_size == 0)
  {
    cp = (char*) global_alloc_by_log2(LOG2_OF_MAX_ALLOC);
    if (cp)
    {
      reserved_memory = cp;
      reserved_size = (1 << LOG2_OF_MAX_ALLOC);
      memset(reserved_memory, 0, reserved_size);
    }
  }
  
#ifdef BW2_FEW_SEGMENTS
  struct Segment
  {
    struct Segment* chain;
    unsigned int size;
  };
#define MIN_SEGMENT_SIZE 8

  static struct Segment* segment_list = NULL;

  unsigned int size = (1U << index);
  struct Segment** place = &segment_list;
  struct Segment* seg;
  
  for (;;)
  {
    seg = *place;
    if (seg == NULL || size <= seg->size)
    {
      break;
    }
    place = &seg->chain;
  }
  if (seg != NULL)
  {
    *place = seg->chain;
  }
  else
  {
    int emergency_occurred = False;
    for (;;)
    {
      cp = (char*) global_alloc_by_log2(LOG2_OF_MAX_ALLOC);
      if (cp != NULL)
      {
	break;
      }
      global_compact();
      cp = (char*) global_alloc_by_log2(LOG2_OF_MAX_ALLOC);
      if (cp != NULL)
      {
	break;
      }
      if (emergency_occurred)
      {
	cp = (char*) global_alloc_by_log2(index);
	if (cp != NULL)
	{
	  ((union mhead*) cp)->chain = nextf[index];
	  nextf[index] = (union mhead*) cp;
	  return;
	}
      }
      if (!emergency)
      {
	emergency = True;
	emergency_occurred = True;
#ifdef BWDUMP
#else /* BWDUMP */
	PWordBase::MemoryEmergency();
#endif /* BWDUMP */
	emergency = False;
	global_compact();
      }
      else
      {
	if (size <= reserved_size)
	{
	  ((union mhead*) reserved_memory)->chain = nextf[index];
	  nextf[index] = (union mhead*) reserved_memory;
	  reserved_memory += 1 << index;
	  reserved_size -= 1 << index;
	  return;
	}
	global_compact();
	cp = (char*) global_alloc_by_log2(index);
	if (cp != NULL)
	{
	  ((union mhead*) cp)->chain = nextf[index];
	  nextf[index] = (union mhead*) cp;
	  return;
	}
	ExitPWord();
      }
    }
    seg = (struct Segment*) cp;
    seg->size = (1U << LOG2_OF_MAX_ALLOC);
  }
  
  unsigned int seg_size = seg->size - size;
  cp = (char*) seg + seg_size;
  ((union mhead*) cp)->chain = nextf[index];
  nextf[index] = (union mhead*) cp;
  if (seg_size <= 2048)
  {
    cp = (char*) seg;
    while (LOG2_OF_MHEAD_SIZE <= index)
    {
      if (size <= seg_size)
      {
	((union mhead*) cp)->chain = nextf[index];
	nextf[index] = (union mhead*) cp;
	cp += size;
	seg_size -= size;
      }
      else
      {
	--index;
	size = (1U << index);
      }
    }
  }
  else
  {
    seg->size = seg_size;
    place = &segment_list;
    struct Segment* p;
    for (;;)
    {
      p = *place;
      if (p == NULL || seg_size <= p->size)
      {
	break;
      }
      place = &p->chain;
    }
    seg->chain = p;
    *place = seg;
  }
#else /* not BW2_FEW_SEGMENTS */
  for (;;)
  {
    cp = (char*) global_alloc_by_log2(LOG2_OF_MAX_ALLOC);
    if (cp)
    {
      break;
    }
    global_compact();
    cp = (char*) global_alloc_by_log2(LOG2_OF_MAX_ALLOC);
    if (cp)
    {
      break;
    }
    if (!emergency)
    {
      emergency = True;
      PWordBase::MemoryEmergency();
      emergency = False;
      global_compact();
    }
    else
    {
      if ((1U << index) <= reserved_size)
      {
	((union mhead*) reserved_memory)->chain = nextf[index];
	nextf[index] = (union mhead*) reserved_memory;
	reserved_memory += 1 << index;
	reserved_size -= 1 << index;
	return;
      }
      global_compact();
      cp = (char*) global_alloc_by_log2(index);
      if (cp)
      {
	((union mhead*) cp)->chain = nextf[index];
	nextf[index] = (union mhead*) cp;
	return;
      }
      ExitPWord();
    }
  }
  unsigned int size = 1 << index;
  int nblocks = 1 << (LOG2_OF_MAX_ALLOC - index);
  do
  {
    ((union mhead*) cp)->chain = nextf[index];
    nextf[index] = (union mhead*) cp;
    cp += size;
  } while (--nblocks != 0);
#endif /* not BW2_FEW_SEGMENTS */
}

void* 
xmalloc_on_log2(unsigned int index)
{
  SET_MAX(index, LOG2_OF_MHEAD_SIZE);
  
#ifndef NDEBUG
  if (!VALID_INDEX_P(index))
  {
    assert(VALID_INDEX_P(index));
  }
#endif
  
  union mhead* m = nextf[index];
  if (m == NULL)
  {
    morecore(index);
    m = nextf[index];
  }
  nextf[index] = m->chain;
#ifdef MALLOC_FILL
  memset(m, MALLOC_FILL, 1 << index);
#endif
  return((void*) m);
}

void* 
xmalloc_permanent(unsigned int size)
{
  static unsigned int free_size = 0;
  static char* free_memory = NULL;
  if (free_size < size)
  {
    free_memory = (char*) xmalloc_on_log2(LOG2_OF_MAX_ALLOC);
    free_size = 1U << LOG2_OF_MAX_ALLOC;
#ifdef SMARTNEW_FILL
    memset(free_memory, SMARTNEW_FILL, free_size);
#endif
  }
  void* memory = free_memory;
  free_memory += size;
  free_size -= size;
  return(memory);
}

void* 
xmalloc(unsigned int size)
{
  // using sign bit !
  
  int tmp = (int) size + HEADER_SIZE - 1;
  if (tmp <= HEADER_SIZE - 1)
  {
    if (tmp < HEADER_SIZE - 1)
    {
      for (;;)
      {
	syserr("Too large memory request 0x%04x", size);
      }
    }
    tmp = HEADER_SIZE - 1;
  }
  
  int index = 0;
  do
  {
    ++index;
  } while ((tmp >>= 1) != 0);
  
  union mhead* m = (union mhead*) xmalloc_on_log2(index);
  m->index = index;
  return(MHEAD_TO_PTR(m));
}

unsigned int
xmalloc_size(void* mem)
{
  return(mem == NULL ? 0 : (1 << (PTR_TO_MHEAD(mem))->index) - HEADER_SIZE);
}

void* 
xmalloc_zero(unsigned int size)
{
  void* new_mem = xmalloc(size);
  return(memset(new_mem, 0, xmalloc_size(new_mem)));
}

void
xfree_on_log2(void* mem, unsigned int index)
{
  if (mem != NULL)
  {
    SET_MAX(index, LOG2_OF_MHEAD_SIZE);
    assert(VALID_INDEX_P(index));
    
    ((union mhead*) mem)->chain = nextf[index];
    nextf[index] = (union mhead*) mem;
  }
}

void
xfree(void* mem)
{
  if (mem != NULL)
  {
    union mhead* m = PTR_TO_MHEAD(mem);
    xfree_on_log2(m, m->index);
  }
}

void* 
xrealloc(void* mem, unsigned int size)
{
  if (mem == NULL)
  {
    return(xmalloc(size));
  }
  union mhead* m = PTR_TO_MHEAD(mem);
  unsigned int index = m->index;
  unsigned int nbytes = size + HEADER_SIZE;
  if ((1U << (index - 1)) < nbytes && nbytes <= (1U << index))
  {
    return(mem);
  }
  void* new_mem = xmalloc(size);
  unsigned int copy_size = (1U << index) - HEADER_SIZE;
  memcpy(new_mem, mem, MIN(size, copy_size));
  xfree(mem);
  return(new_mem);
}

// ------------------------------------------------------------
// C++ interface

#if (DEBUG_MEMORY)
static void far* 
debug_new(size_t size)
#else
void far* CDECL
operator new(size_t size)
#endif
{
  return(xmalloc((unsigned int) size));
}

#if (DEBUG_MEMORY)
static void
debug_delete(void far* mem)
#else
void CDECL
operator delete(void far* mem)
#endif
{
  xfree(mem);
}

#if (DEBUG_MEMORY)
// ------------------------------------------------------------
// debugging functions

struct Head
{
  unsigned long magic0;
  Head* prev;
  Head* next;
  unsigned long size;
  unsigned long magic1;
};

#define FREE 0xdeaddeadUL
#define ALLOC 0xfacefaceUL

#define FREE4 0xe0c2a486UL
#define ALLOC4 0xf1d3b597UL

#define magic4(h) \
(*(unsigned long*) ((char*) h + sizeof(Head) + (unsigned int) h->size))

static Head base[1];

void check_all_memory();

void far* CDECL
operator new(size_t size)
{
  if (base->prev == NULL)
  {
    base->prev = base->next = base;
  }

#if (defined(STRICT_DEBUG_MEMORY))
  check_all_memory();
#endif
  
  size_t s = size + sizeof(Head) + 4;
  if (s < size || (1U << LOG2_OF_MAX_ALLOC) < (unsigned int) s + HEADER_SIZE)
  {
    syserr("new : Too large memory request, size = %d", size);
    assert(False);
  }
  
  Head* h = (Head*) debug_new(s);
  if (h == NULL)
  {
    syserr("new : You're loose !");
    assert(False);
  }

  h->prev = base;
  (h->next = base->next)->prev = h;
  base->next = h;
  
  h->magic0 = ALLOC;
  h->magic1 = ALLOC;
  h->size = size;
  magic4(h) = ALLOC4;

  return((void*) ((char*) h + sizeof(Head)));
}

void CDECL
operator delete(void far* addr)
{
#if (defined(STRICT_DEBUG_MEMORY))
  check_all_memory();
#endif
  
  if (addr != NULL)
  {
    Head* h = (Head*) ((char*) addr - sizeof(Head));
    if (h->magic0 != ALLOC || h->magic1 != ALLOC || magic4(h) != ALLOC4)
    {
      if (h->magic0 == FREE && h->magic1 == FREE && magic4(h) == FREE4)
      {
	syserr("delete : broken memory header."
		"  Maybe, this memory was already deleted");
      }
      else
      {
	syserr("delete : broken memory header");
      }
      assert(False);
    }
    
    h->magic0 = FREE;
    h->magic1 = FREE;
    magic4(h) = FREE4;
    Head* prev = h->prev;
    Head* next = h->next;
    prev->next = next;
    next->prev = prev;
    
    debug_delete(h);
  }
}

void
check_all_memory()
{
  Head* h = base;
  for (;;)
  {
    Head* next = h->next;
    if (next->prev != h)
    {
      syserr("check_all_memory : broken memory header");
      assert(False);
    }
    h = next;
    if (h == base)
    {
      break;
    }
    if (h->magic0 != ALLOC || h->magic1 != ALLOC || magic4(h) != ALLOC4)
    {
      syserr("check_all_memory : broken memory header");
      assert(False);
    }
  }
}

#endif /* DEBUG_MEMORY */
