// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: numdlg.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of NumDialog class for dialog boxes
// where you enter a single number

#include "pword.h"
#include "dialogs.h"
#include "pmenus.h"
#include "numdlg.h"

NumDialog::NumDialog(int initial_set, int initial)
 : value(initial),
   value_set(initial_set)
{
}

LRESULT_T
NumDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    if (!value_set)
    {
      SetItemText(IDD_Value, "");
    }
    else
    {
      SetItemInt(IDD_Value, value);
    }
    return(1);
			
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     // for a WM_COMMAND message on IDD_Value,
     // we look at the string, then enable or disable the OK
     // button depending on whether it contains a valid size.
     case IDD_Value:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case EN_UPDATE:
	 case EN_CHANGE:
	  {
	    int translated;
	    value=GetItemInt(IDD_Value, &translated);
	    
	    // at this point, translated tells us whether or not
	    // the thing was a valid integer, so we can use it
	    // as the argument to EnableWindow
	    EnableWindow(GetItem(IDOK), 
			 translated && CheckValue(value));
	  }
	  break;
	 default:
	  break;
	}
	break;
      }
      
     case IDOK:
      value_set = 1;
      End(1);
      return 1;
				
     case IDCANCEL:
      End(0);
      return 1;
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
  }
  return 0;
}
