// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pagebox.cpp,v 3.5 1999/05/15 17:48:20 kudou Exp $
// implementation of PageBox class

#include "pword.h"
#include "pagebox.h"
#include "dialogs.h"
#include "document.h"
#include "docwindo.h"
#include "docedit.h"
#include "pmenus.h"
#include "mwindow.h"
#include "bufnew.h"
#include "intlist.h"
#include "interval.h"
#include "pime.h"
#include "screen.h"
#include "xstr.h"

LONG PageBox::old_wndproc = 0;

PageBox::PageBox()
{
  this->class_name = "PageBox";
  this->cur1 = 0;
  this->cur2 = 0;
  this->active = 0;
  this->valid = 0;
  this->mode = PBM_PL;
}

void
PageBox::Position()
{
  if (this->GetHandle())
  {
    RECT main_r, my_r;
    main_window->GetRect(&main_r);
    this->GetRect(&my_r);
    
    int my_width = my_r.right - my_r.left;
    if ((main_r.right - main_r.left) / 2 < my_width)
    {
      this->Hide();
    }
    else
    {
#ifdef BW21_PAGEBOX
#ifdef _WIN32
      // for Win95/NT
      this->Move((main_r.right
		  - my_width
		  - Screen::caption_bitmap_height * 3
		  - Screen::frame_width - 1),
		 main_r.top + Screen::frame_height,
		 my_width,
		 Screen::caption_height - 1, TRUE);
#else /* _WIN32 */
      // for Win95/NT fix
      this->Move((main_r.right
		  - my_width
		  - Screen::caption_bitmap_height * (2 + (windows_w32_env_p() ? 1 : 0))
		  - Screen::frame_width - 1),
		  main_r.top + Screen::frame_height - 1,
		  my_width, Screen::caption_height, TRUE);
#endif
#else /* BW21_PAGEBOX */
      this->Move((main_r.right
		   - my_width
		   - Screen::caption_bitmap_height * 2
		   - Screen::frame_width - 1),
		  main_r.top + Screen::frame_height - 1,
		  my_width, Screen::caption_height, 0);
#endif /* BW21_PAGEBOX */
      this->Show();
    }
  }
}

void
PageBox::Show()
{
  if (this->GetHandle())
  {
    PModelessDialog::Show(SW_SHOWNOACTIVATE);
    this->InvalidateAll();
    this->Update();
  }
}

void
PageBox::MakeActive()
{
  if (this->GetHandle() && !this->active)
  {
    this->active = 1;
    this->valid = this->Get(cur1);
  }
}

void
PageBox::MakeInactive()
{
  this->active = 0;
}

// Get, Set, and Clear

// private method(for smaller code)
// This method is called from PageBox::Set only.
void NEAR
PageBox::Set0(int item_id, int old_value, int new_value)
{
  if (!this->valid || new_value != old_value)
  {
    if (this->mode == PBM_PL)
    {
      this->SetItemInt(item_id, new_value);
    }
    else
    {
      set_item_mm0(this->GetHandle(), item_id, new_value);
    }
  }
}

void
PageBox::Set(int v1, int v2)
{
  if (this->GetHandle())
  {
    this->Set0(IDD_PageBox_Val1, this->cur1, v1);
    this->cur1 = v1;
    this->Set0(IDD_PageBox_Val2, this->cur2, v2);
    this->cur2 = v2;
    this->valid = True;
  }
}

void
PageBox::Clear()
{
  if (this->GetHandle())
  {
    this->SetItemText(IDD_PageBox_Val1, "");
    this->SetItemText(IDD_PageBox_Val2, "");
    this->valid = 0;
  }
}

int
PageBox::Get(int& v)
{
  if (this->GetHandle())
  {
    BOOL translated;
    v = this->GetItemInt(IDD_PageBox_Val1, &translated);
    if (translated)
    {
      return(1);
    }
  }
  return(0);
}

// Window Procedure

LRESULT_T
PageBox::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  bool handled=0;
  
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      SendItemMessage(IDD_PageBox_Val1, EM_LIMITTEXT, 4);
      
      // remember old wndproc for "page"
      HWND handle=GetItem(IDD_PageBox_Val1);
      old_wndproc=GetWindowLong(handle, GWL_WNDPROC);
      
      // subclass "line" so it can't be edited
      handle=GetItem(IDD_PageBox_Val2);
      SetWindowLong(handle, GWL_WNDPROC, (LONG) PageBox::OurWndProc);
      this->SetLabels(S_LabelPage, S_LabelLine);
      handled = 1;
    }
    break;
    
   case WM_MOUSEACTIVATE:
    return(((Selected_Window == NULL) || (this->mode != PBM_PL)) ?
	    MA_NOACTIVATE : MA_ACTIVATE);
    
   case WM_CLOSE:
    Destroy();
    break;
    
   case WM_ACTIVATE:
#ifdef _WIN32
    if (LOWORD(wParam))
#else /* _WIN32 */
    if (wParam)
#endif /* _WIN32 */
    {
      // being activated
      MakeActive();
      pime_status = PIME::GetOpen();
      PIME::SetClosed();
    }
    else
    {
      // being deactivated
      if (active) 
      {
	if (valid) 
	{
	  SetItemInt(IDD_PageBox_Val1, cur1);
	}
	else 
	{
	  Clear();
	}
	MakeInactive();
	if (pime_status) 
	{
	  PIME::SetOpen();
	}
      }
    }
    break;
    
   case WM_SYSCOMMAND:
#if 0
    switch (wParam)
    {
      // kill these, such as Alt-F4 for close!!!!
    }
#endif
    return 1;
    
   case WM_COMMAND:	
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_PageBox_Val1:
     case IDD_PageBox_Val2:
     case IDD_PageBox_Lab1:
     case IDD_PageBox_Lab2:
     case IDD_PageBox_Shade1:
     case IDD_PageBox_Shade2:
      MakeActive();
      break;
      
      // IDOK comes when the user hits return
     case IDOK:
      {
	int new_page;
	if (Get(new_page) &&
	    Selected_Window &&
	    Selected_Window->GotoPage(new_page , 0)) 
	{
//	     MakeInactive();
	  Selected_Window->SetFocus();
	}
	else MessageBeep(0);
	break;
      }
      
      
      // IDCANCEL comes when the user hits cancel
      
     case IDCANCEL:
      if (Selected_Window)
      {
	if (valid)
	{
	  SetItemInt(IDD_PageBox_Val1, cur1);
	}
	else Clear();
	Selected_Window->SetFocus();
      }
      else
      {
	Clear();
	main_window->SetFocus();
      }
      MakeInactive();
      break;
      
     default:
      handled=0;
      break;
    }
    
   default: 
    handled=0;
  }
  return handled;
}

void
PageBox::Update()
{
  int page, line;
  bool ghost;
  this->SetWndProc();
  if (this->mode == PBM_PL
      && Selected_Window
      && Selected_Window->GetCaretPageAndLine(&page, &line, &ghost))
  {
    this->Set(page, line);
  }
  else
  {
    this->Clear();
  }
  Window::Update();
}

LRESULT_T
PageBox::OurWndProc_ (HWND h, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
   case WM_SETCURSOR:
   case WM_LBUTTONDOWN:
   case WM_MBUTTONDOWN:
   case WM_RBUTTONDOWN:
   case WM_MOUSEMOVE:
   case WM_KEYDOWN:
   case WM_CHAR:
    return(0);
  }
  return(CallWindowProc((WNDPROC) old_wndproc, h, msg, wParam, lParam));
}

// private method
void NEAR
PageBox::SetLabels(char* lab1, char* lab2)
{
  this->SetItemText(IDD_PageBox_Lab1, lab1);
  this->SetItemText(IDD_PageBox_Lab2, lab2);
}

void
PageBox::SetMode(PBMode new_mode)
{
  if (new_mode != this->mode)
  {
    char* lab1 = S_LabelPage;
    char* lab2 = S_LabelLine;
    this->mode = new_mode;
    this->SetWndProc();
    switch (new_mode)
    {
     case PBM_HW:
      lab1 = S_LabelBy;
      lab2 = S_LabelMM;
      break;
      
     case PBM_MP:
      lab1 = S_LabelMM;
      lab2 = S_LabelPercent;
      break;
    }
    this->SetLabels(lab1, lab2);
    this->Update();
  }
}

void
PageBox::SetWndProc()
{
  this->Enable((this->mode == PBM_PL) && (Selected_Window!=NULL));
}
