// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pagesize.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// PageSize class
// pTCYǗNX

#ifndef PAGESIZE_H
#define PAGESIZE_H

#include "rect.h"
#include "margin.h"
#include "pagemap.h"

class BluePrint;
class PStream;
class AllLayout;
class UniqLTList;
class DocumentContent;

class PageSize
  : public PageMap
{
  // ------------------------------
  // paper static informations
public:
  // paper kind
  // CAUTION: This enum values are stored in the BeatWord file.
  // Don't change this order.
  enum Kind 
  {
    A3,				// A3
    A4,				// A4
    A5,				// A5
    B4,				// B4
    B5,				// B5
    PostCard,			// 
    Letter,			// 
    LetterSmall,		// 
    Tabloid,			// 
    Ledger,			// 
    Legal,			// 
    Statement,			// 
    Executive,			// 
    Folio,			// 
    Quarto,			// 
    P10x14,			// 10 x 14 Inch
    P11x17,			// 11 x 17 Inch
    Note,			// Note size
    Env9,			// #9 envelope
    Env10,			// #10 envelope
    Env11,			// #11 envelope
    Env12,			// #12 envelope
    Env14,			// #14 envelope
    LetterExtra,		// 9.5 x 12 Inch
    LegalExtra,			// 9.5 x 15 Inch
    TabloidExtra,		// 11.69 x 18 Inch
    A4Extra,			// 9.27 x 12.69 Inch
    UserSize,			// user defined size
  };
  
  enum 
  {
    KindNumber = UserSize,
  };
  
  // paper direction
  // CAUTION: This enum values are stored in the BeatWord file.
  // Don't change this order.
  enum Orientation 
  {
    Portrait,			// vertical
    Landscape,			// horizontal
  };
  
private:
  // ------------------------------
  // default paper informations
  // default paper
  static Kind STATIC_NEAR default_kind;
  
  // default orientation
  static Orientation STATIC_NEAR default_orientation;
  
  // default margin div
  static Iunit STATIC_NEAR margin_div;
  
  // default header size
  static Iunit STATIC_NEAR header_size;
  
  // default footer size
  static Iunit STATIC_NEAR footer_size;
  
  // default usr paper size
  static Vector STATIC_NEAR def_usr_size;
  
  // default usr margin size
  static Margin STATIC_NEAR def_usr_margin;
  
  // minimum margin size
  static Margin STATIC_NEAR min_margin;
  
  // get min margin
  static void GetMinTopBottomMargin(Kind pk, Orientation o, 
                                     Iunit& min_top, Iunit& min_bot);
  static void GetMinLeftRightMargin(Kind pk, Orientation o,
                                     Iunit& min_left, Iunit& min_right);
  
public:
  static void PageSize::read_profile();
  static void PageSize::write_profile();
  
  // get max and min
  static Iunit GetMaxPaperSize();
  static Iunit GetMinPaperSize();
  static Iunit GetMinRegularSize();
  
  // get size
  static Iunit GetWidth(Kind pk, Orientation o);
  static Iunit GetHeight(Kind pk, Orientation o);
  static Vector GetSize(Kind pk, Orientation o);
  
  // get margin
  static Iunit GetTopMargin(Kind pk, Orientation o);
  static Iunit GetBottomMargin(Kind pk, Orientation o);
  static Iunit GetLeftMargin(Kind pk, Orientation o);
  static Iunit GetRightMargin(Kind pk, Orientation o);
  static Margin GetMargin(Kind pk, Orientation o);
  
  // get default paper size
  static Vector GetDefaultSize();
  
  // get default margin size
  static Margin GetDefaultMargin();
  
  // get default header size
  static Iunit GetDefaultHeaderSize();
  
  // get default footer size
  static Iunit GetDefaultFooterSize();
  
  // get proper margin
  static void GetProperMargin(Margin& m, Vector& page_size);

  // ------------------------------
  // document page size
private:
  // layout
  LayoutInstance* layout;
  
  // page size
  Kind kind;
  
  // page orientation
  Orientation orient;
  
  // page size
  Vector size;
  
  // page margin size
  Margin margin;
  
  // all layout object
  AllLayout* all_layout;
  
  // first page number
  word first_page_number;
  
  // file save version
  enum 
  {
    save_version = 1
  };
  
private:
  // create layout-template
  LayoutTemplate* CreateLayoutTemplate(DocumentContent* doc);
  
public:
  // constructor
  PageSize(DocumentContent* doc);
  
  // constructor for file read
  PageSize();
  
  // initialize for file read
  void Initialize();
  
  // destructor
  ~PageSize();
  
  // save file
  void WriteToStream(PStream* ps, UniqLTList* ltlist);
  
  // load file
  static PageSize* ReadFromStream(PStream* ps, 
				   DocumentContent* doc, 
				   UniqLTList* ltlist);
  
  // get size
  Kind GetKind() 
  {
    return kind;
  }
  
  Orientation GetOrientation() 
  {
    return orient;
  }
  
  Margin GetMargin() 
  {
    return margin;
  }
  
  Vector GetSize() 
  {
    return size;
  }
  
  Iunit GetHeight() 
  {
    return size.y;
  }
  
  Iunit GetWidth()  
  {
    return size.x;
  }
  
  // change page size
  void ChangeSize();
  void ChangeSize(Kind kind, Orientation o);
  void ChangeSize(Kind kind, Orientation o, Vector& s, Margin& m);
  
  // change margin
  void ChangeMargin();
  
  // get all layout offset
  Iunit GetAllLayoutsOffsetX();
  Iunit GetAllLayoutsOffsetY();
  
  // set layout position
  // x and y is the internal layout position
  void SetLayoutPosition(Lunit x, Lunit y);
  
  // get layout
  LayoutInstance* GetLayout() 
  {
    return layout;
  }
  
  // get all layout
  AllLayout* GetAllLayout() 
  {
    return all_layout;
  }
  
  // first page
  word GetFirstPageNumber() 
  {
    return first_page_number;
  }
  
  void SetFirstPageNumber(word first) 
  {
    first_page_number = first;
  }
  
  // get default frame margin
  static Margin GetDefaultFrameMargin();
};

#endif /* PAGESIZE_H */
