// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pclipboa.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// implement PClipboard, PClipboardWrite, and PClipboardRead
// classes for managing clipboard

#include "pword.h"
#include "pclipboa.h"

bool PClipboard::open_flag = False;

void
PClipboard::EnsureClose()
{
  if (open_flag)
  {
    ::CloseClipboard();
    open_flag = False;
  }
}

// constructor and destructor

PClipboard::PClipboard()
{
  status=closed;
  data=NULL;
  len=0;
  data_handle=NULL;
}

PClipboard::~PClipboard()
{
}

// check if clipboard data present -- static function

int
PClipboard::IsFormatAvailable(int type)
{
  return ::IsClipboardFormatAvailable(type);
}

// procedures common to reading and writing -- class PClipboard

// open clipboard -- general version for both reading or writing

int
PClipboard::Open(HWND hWnd)
{
  if (status!=closed)
  {
    syserr("Attempt to open clipboard when not closed.");
  }
  if (! ::OpenClipboard(hWnd))
  {
#ifndef NDEBUG
    syserr("Clipboard open failed.");
#endif
    status = error;
    open_flag = False;
  }
  else
  {
    status = opened;
    open_flag = True;
  }
  return 1;
}


void
PClipboard::Close()
{
  if (status != opened)
  {
    syserr("attempt to close clipboard while in use or not open");
  }
  open_flag = False;
  ::CloseClipboard();
  status = closed;
}
	
void
PClipboard::Start()
{
  if (status != opened)
  {
    syserr("attempt to start clipboard use without opening");
  }
  status = started;
}

void
PClipboard::End()
{
  if (status!=started)
  {
    syserr("attempt to end clipboard usage without starting");
  }
  status = opened;
}

void
PClipboard::Handle()
{
  if (status != opened)
  {
    syserr("PClipboard::Handle -- clipboard not open");
  }
}


// routines particular to writing onto clipboard

// open clipboard -- special version for writing which includes 
// call to empty clipboard

int
PClipboardWrite::Open(HWND hWnd)
{
  int ret = 1;
  if (PClipboard::Open(hWnd))
  {
    ::EmptyClipboard();
  }
  else ret = 0;
  return ret;
}

char*
PClipboardWrite::Start(udword len)
{
  PClipboard::Start();
  data = 0;
  data_handle = ::GlobalAlloc(GHND, len);
  if (data_handle)
  {
    data = (char*)::GlobalLock(data_handle);
  }
  return data;
}

void
PClipboardWrite::Handle(int type, HANDLE hndl)
{
  PClipboard::Handle();
  if (hndl)
  {
    data_handle = hndl;
    SetClipboardData(type, data_handle);
  }
}


// write global memory to clipboard
	
void
PClipboardWrite::End(int type)
{
  PClipboard::End();
  Handle(type, data_handle);
}


// versions particular to reading from clipboard

// PClipboardRead::Start -- get clipboard data

char*
PClipboardRead::Start(int type)
{
  PClipboard::Start();
  data_handle = ::GetClipboardData(type);
  data = 0;
  if (data_handle)
  {
    data = (char*)::GlobalLock(data_handle);
  }
  return data;
}

// end -- unlock data handle now owned by clipboard
void
PClipboardRead::End()
{
  PClipboard::End();
  if (data_handle)
  {
    ::GlobalUnlock(data_handle);
  }
}

HANDLE
PClipboardRead::Handle(int type)
{
  PClipboard::Handle();
  return data_handle = ::GetClipboardData(type);
}
