// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: picture.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Picture
// rbg}bvێNXBgDIB`ŃC[Wێ
// 邪AɃLbVꂽC[WǗ

#ifndef PICTURE_H
#define PICTURE_H

#include "rect.h"
#include "vmem.h"

#ifndef PICLIST_DEFINED
class PicList;
#endif

// this class is the core bitmap management class
class Picture
{
  // device independ bitmap data
  VMem* vm_dib;
  udword dib_size;
  int dib_width;
  int dib_height;
  
  // cache bitmap data
  HBITMAP cache;
  int cache_width;
  int cache_height;
  
  // cache management
  static PicList* cache_pic;
  static uword cache_num;
  enum 
  {
    cache_picture_max = 10, 
  };
  
private:
  // add cache
  void AddCache();
  
  // remove cache
  void RemoveCache();
  
  // change cache priority
  void CacheUsed();
  
  // cache hit check
  bool CacheHitCheck(int width, int height);
  
  // set dib width and height
  void SetDIBWidthAndHeight();
  
  // get cf_dib format memory
  void* GetCF_DIB();
  
  // clear
  void Clear();
  
public:
  // constructor
  // format : CF_DIB or CF_BITMAP
  Picture(HANDLE data, WORD format);
  
  // constructor for duplicate
  Picture(Picture* pic);
  
  // constructor
  Picture(VMem* vm_dib, udword size);
  
  // read file
  Picture(char* file_name);
  
  // destructor
  ~Picture();
  
  // valid check
  bool IsValid() 
  {
    return vm_dib != 0;
  }
  
  // display
  // rec		: Iunit position
  void Redisplay(VDisplay* vdsp, Rect& rec);
  
  // copy to clipboard
  void CopyToClipboard();
  
  // get vm-dib
  VMem* GetVMDIB() 
  {
    return vm_dib;
  }
  
  // get dib size
  udword GetSize() 
  {
    return dib_size;
  }
  
  // get clipboard picture
  static Picture* GetClipBoardPicture();
  
  // copy clipboard bitmap
  static HBITMAP CopyClipBoardBitMap(HWND hWnd);
  
  // copy clipboard DIB
  static HANDLE CopyClipBoardDIB(HWND hWnd);
  
  // copy bitmap
  static HBITMAP CopyBitMap(HBITMAP bmp);
  
  // copy DIB
  static HANDLE CopyDIB(HANDLE dib);
  
  // create DIB
  static HANDLE CreateDIB(HBITMAP bmp);
  
  // create bitmap
  static HBITMAP CreateBitMap(HANDLE dib);
  
  // get dib width and height
  static void GetDIBWidthAndHeightDIB(HANDLE dib, Iunit& width, Iunit& height);
  static void GetDIBWidthAndHeightCFDIB(void* cf_dib, Iunit& width, Iunit& height);
public:
  enum FileCheck
  {
    FileOk,
    OpenError,
    FormatError,
    FileSizeError,
    NotSupportFormatError,
    LessMemoryError,
  };
  
  enum FileFormat
  {
    BMP,    // Windows BitMap
    RGBE,   // Staff Kid R1, G1, B1, E1
    // GIF, TIFF, JPEG, EPS etc...
  };
  
  // check file consistency
  static FileCheck CheckFileConsistency(FileFormat ff, char* file_name);
  
private:
  static FileCheck CheckBMPFileConsistency(char* file_name);
  static FileCheck CheckRGBEFileConsistency(char* file_name);
  
  // read picture file
public:
  static Picture* ReadPictureFile(FileFormat ff, char* file_name,
				   FileCheck& fc);
private:
  static Picture* ReadBMPFile(char* file_name, FileCheck& fc);
  static Picture* ReadRGBFile(char* file_name, FileCheck& fc);
};

#endif /* PICTURE_H */
