// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pime.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// define PIME class for input method editors.
// This class should be used in the following way.  It is completely
// static--there are no instances of it.
//
// When your application starts up, call Create().
// When you get a message from somewhere, pass it to DDEDispatch().
// When your window gets the focus or the insertion point changes
// or the window scrolls or something, call one of the xxxConvertWindow()
// methods.
// Then just accept WM_CHAR messages.
// When your application is ready to terminate, call Destroy().
 
#ifndef PIME_H
#define PIME_H

#define BW3_IMM

#ifdef BW3_IMM
// ============================================================
// new PIME for 32-bit Windows

class PIME
{
public:
  // setup
  static void Create(HWND);
  static void Destroy();

  // IME status
  static bool GetOpen();			// IME  ON ǂ𔻒肷
  static void SetOpen(bool status = true);	// IME  ON ɂ
  static void SetClosed();			// IME  OFF ɂ
  static void PopOpenStatus();
  static void PushOpenStatus();
  static int GetPending();		// m蕶̒𓾂

  // Focus
  static void KillFocus();
  static void SetFocus();

  // Font
  static HFONT SetFont(HFONT font);
  static void SetIgnoreFont(int);
  static int GetIgnoreFont();

  // uses the little black window at the bottom of the screen
  static void DefaultConvertWin();

  // starts at the first coordinate for the first line, and uses
  // the rectangle specified by the remaining arguments for the
  // remaining lines
  static void RectConvertWin(HWND hWnd2, Drect* dr, Dpoint* dp, int ascent, int tategakip);

  // DDE related.  Certain IME's communication with the application
  // via DDE.  This routine handles such messages, namely
  // WM_DDE_ACK, WM_DDE_TERMINATE, WM_DDE_DATA
  static int DDEDispatch(unsigned, WORD, LONG);

  // register
  static void WordRegister(char* moji, char* yomi);
};

#else /* BW3_IMM */
// ============================================================
// old PIME for 16-bit Windows

#include <dde.h>

typedef DDEPOKE FAR* LPDDEPOKE;
typedef DDELN FAR* LPDDELN;
typedef DDEUP FAR* LPDDEUP;

class PIME
{
private:

  static HANDLE    hIme;	// memory handle to IME interface structure
  static HANDLE    hIMEP;	// memory handle to IMP interface structure
  static LONG	   lIMEParam;	// parameter used to communicate with IME
  static HWND      hWnd;  	// current window
  static DDEPOKE * ddepoke;
  static LPIMESTRUCT imestruct;

  // atoms

  static ATOM	aImeCtl;	// atom for ITEMCTL
  static ATOM	aMode;		// atom for MODE
  static ATOM	aIsOpen;	// atom for ISOPEN 
  static ATOM	aIme;		// atom for IMECMD

  static int	cfIme;		// clipboard format
  static HANDLE	vhIme;		// handle used for DDE calls

  static int	wIMEMode;	// henkan mode
  static int	wIMEOpen;	// is IME open?
  static int    was_open;       // one-level open status stack
  static HFONT  old_font;       // one-level font stack
  static int    ignore_font;    // ignore font requests
  static int    system_font_ascent;
  
  static HWND	hWndServer;	// server handle
  static int	fConversation;	// conversation flag
  static int	fInitializing;	

  static int    created;
  static int    error;

  static int    on_when_lost_focus;
  static int    first_focus_call;
  
public:

  // routines to set up conversion window

  // uses the little black window at the bottom of the screen
  static void DefaultConvertWin();

  // starts at the first coordinate for the first line, and uses
  // the rectangle specified by the remaining arguments for the
  // remaining lines
  static void RectConvertWin(HWND hWnd2, Drect* dr, Dpoint* dp, int ascent, int tategakip);
  
  // get and set mode.  These modes are logically-OR'd constants of
  // the form IME_MODE_xxx.  Since the IME permits the user to set these
  // by means of function keys and what have you, there might be no need
  // for the application to set them itself.  Then again, the application
  // might want to set mode to IME_MODE_ROMAN, for instance, when the
  // user puts the insertion point in the middle of Romaji, etc.
	
  static int GetMode();
  static void SetMode(WORD);

  // opening and querying open status.  This turns the IME on or off.
	
  static void WindowUpdate(int on_off);
  static void SetOpen(int=1);
  static void SetClosed()
  {
    SetOpen(0);
  }
  static WORD GetOpen();
  static int GetPending();
  static WORD GetOpenAndPending(int& pending);
  static int GetCreated();
  static int GetError() { return error; }
  static void ClearError() { error = 0; }
  
  // set font.  This is the font the IME will use to display characters
  // in the process of being entered.  Normally, the application would 
  // use the same font being used in the surrounding text, for example.
	
  static HFONT SetFont(HFONT);

  static void SetIgnoreFont(int);
  static int  GetIgnoreFont();
  
  // DDE related.  Certain IME's communication with the application
  // via DDE.  This routine handles such messages, namely
  // WM_DDE_ACK, WM_DDE_TERMINATE, WM_DDE_DATA

  static int DDEDispatch(unsigned, WORD, LONG);

  // send a key to the IME
  static void SendKey(WORD);
  static void Kakutei() { SendKey(VK_NONCONVERT); }
  
  // register a word with the IME
  static void WordRegister(char* moji, char* yomi);

private:
  static int DDERequest(ATOM);
  static int DDEStartAdvise(ATOM);
  static int DDEEndAdvise(ATOM);
  static void DDEProcess(HWND,ATOM,HANDLE);
  static void DDEAck(HWND, ATOM, ATOM);

  static int SendMessage(HWND hWnd2 = hWnd);
  
public:

  static int Exists();
  
  // setup and shutdown
  static void Create(HWND);
  static void Close();
  static void Destroy();

  static void KillFocus();
  static void SetFocus();
  
  // turn on/off advising of mode thorugh DDE
  static void AdviseMode(int);
	
  // query IME capabilities
  static int Query(int);

  // accessors
  static void PushOpenStatus()
  {
    was_open = GetOpen();
  }
  static void PopOpenStatus()
  {
    SetOpen(was_open);
  }
  static void PushFont()
  {
    old_font = PIME::SetFont(0);
  }
  static void PopFont()
  {
    PIME::SetFont(old_font);
  }

public:
  static char	szMode[16];
  static char	szOpen[8];		
};

#endif /* BW3_IMM */

#endif /* PIME_H */
