// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pmli.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class PageMapLayoutIterator
// LayoutInstance iterator for one PageMap

#ifndef PMLI_H
#define PMLI_H

#include "pagemap.h"
#include "layoutin.h"

class PageMapLayoutIterator
{
  // pagemap
  PageMap* pm;
  
  // iterate layout instance
  LayoutInstance* li;
  
public:
  // constructor
  PageMapLayoutIterator(PageMap* pm)
  {
    PageMapLayoutIterator::pm = pm;
    li = pm->GetFirstLayout();
  }
  
  // iterator
  LayoutInstance* operator() ()
  {
    LayoutInstance* ret = li;
    if (li != 0) 
    {
      li = li->GetNextPageMapLayout();
    }
    return ret;
  }
  
  // revert
  void Revert()
  {
    li = pm->GetFirstLayout();
  }
};

#endif /* PMLI_H */

