// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: position.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class EditFrame
// t[GfB^ɂʒuATCY\sȂNX

#include <stdarg.h>
#include "pword.h"
#include "editfram.h"
#include "docconte.h"
#include "document.h"
#include "fission.h"
#include "frameins.h"
#include "frameown.h"
#include "layoutte.h"
#include "pagebox.h"
#include "pagesize.h"
#include "pwordpre.h"

//#define STATUSOUT

#ifdef STATUSOUT
static void CDECL
StatusOut(char* format, ...)
{
  char buf[256];
  va_list va;
  va_start(va, format);
  wvsprintf(buf, format, (VA_LIST) va);
  va_end(va);
  PWordPresentation::StatusOut(buf);
}
#endif

// clear position
void 
EditFrame::ClearPosition()
{
  PWordPresentation::GetPageBox()->Update();
}

// show table size 
void 
EditFrame::ShowTableSize(Vector& from, Vector& to)
{
  Iunit width  = (from.x < to.x) ? (to.x - from.x) :
  (from.x - to.x);
  Iunit height = (from.y < to.y) ? (to.y - from.y) :
  (from.y - to.y);
#ifdef STATUSOUT
  StatusOut("Table Size  width:%4d mm  height:%4d mm", 
	     iu_to_mm(width), 
	     iu_to_mm(height));
#endif
  // width , height
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_HW);
  PWordPresentation::GetPageBox()->SetWH(iu_to_mm0(width), 
					   iu_to_mm0(height));
}

// show vertical draw line position
static void 
ShowVDrawLine(Iunit pos, Iunit up, Iunit low)
{
  Iunit total = low - up;
  word pacent0 = (total != 0
		  ? (word) (((long) (pos - up) * 1000L) / (long) total)
		  : 0);
#ifdef STATUSOUT
  StatusOut("%4d mm %4d %%  from upper line: %4d mm  from lower line: %4d mm",
             iu_to_mm(pos),
             pacent0,
             iu_to_mm(pos - up),
             iu_to_mm(low - pos));
#endif
  // position and %
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_MP);
  PWordPresentation::GetPageBox()->SetMP(iu_to_mm0(pos), pacent0);
}

// show horizonta draw line position
static void 
ShowHDrawLine(Iunit pos, Iunit l, Iunit r)
{
  Iunit total = r - l;
  word pacent0 = (total != 0
		  ? (word) (((long) (pos - l) * 1000L) / (long) total)
		  : 0);
#ifdef STATUSOUT
  StatusOut("%4d mm %4d %%  from left line: %4d mm  from right line: %4d mm",
             iu_to_mm(pos),
             pacent0,
             iu_to_mm(pos - r),
             iu_to_mm(l - pos));
#endif
  // position and %
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_MP);
  PWordPresentation::GetPageBox()->SetMP(iu_to_mm0(pos), pacent0);
}

void 
EditFrame::ShowDrawLinePos(Fission* f, VectW& pos)
{
  Vector v = WtoIv(pos);
  Vector offset(0,0);
  if (GetEditLT()->IsRegular()) 
  {
    PageSize* ps = doc->GetDocumentContent()->GetPageSize();
    offset.x = ps->GetAllLayoutsOffsetX();
    offset.y = ps->GetAllLayoutsOffsetY();
  }
  
  if (f->GetDir() == Fission::Vertical) 
  {
    // draw horizontal line
    Iunit upper = 0;
    Iunit lower = 0;
    for (CrossPoint* cp = f->GetStartCrossPoint();
	 cp != 0;
	 cp = cp->GetVNext()) 
    {
      if (cp->Y() <= v.y) 
      {
	lower = upper = cp->Y();
      }
      if (cp->Y() >= v.y) 
      {
	lower = cp->Y();
	break;
      }
    }
    ShowVDrawLine(v.y + offset.y, upper + offset.y, lower + offset.y);
  }
  else 
  {
    // draw vertical line
    Iunit left = 0;
    Iunit right = 0;
    for (CrossPoint* cp = f->GetStartCrossPoint();
	 cp != 0;
	 cp = cp->GetHNext()) 
    {
      if (cp->X() <= v.x) 
      {
	right = left = cp->X();
      }
      if (cp->X() >= v.x) 
      {
	right = cp->X();
	break;
      }
    }
    ShowHDrawLine(v.x + offset.x, left + offset.x, right + offset.x);
  }
}

// show move line position
void 
EditFrame::ShowMoveLinePos(Fission* f, Iunit pos, 
			    Iunit l_lim, Iunit u_lim)
{
  if (f->GetDir() == Fission::Vertical) 
  {
    // move vertical line
    Iunit offset = 0;
    if (GetEditLT()->IsRegular()) 
    {
      PageSize* ps = doc->GetDocumentContent()->GetPageSize();
      offset = ps->GetAllLayoutsOffsetX();
    }
    ShowHDrawLine(pos + offset, l_lim + offset, u_lim + offset);
  }
  else 
  {
    // move horizontal line
    Iunit offset = 0;
    if (GetEditLT()->IsRegular()) 
    {
      PageSize* ps = doc->GetDocumentContent()->GetPageSize();
      offset = ps->GetAllLayoutsOffsetY();
    }
    ShowVDrawLine(pos + offset, l_lim + offset, u_lim + offset);
  }
}

// show move line position
void 
EditFrame::ShowMoveLinePos()
{
  ShowMoveLinePos(move.GetMoveFission(), move.GetMovePos(),
                   move.GetScaleLLimit(), move.GetScaleULimit());
}

// show move frame line position
void 
EditFrame::ShowMoveFrameLinePos(Vector& pos, uword m, CrossPoint* cp)
{
  if (m == 0)
  {
    m = fmgn.GetMarginNumber();
  }
  if (cp == 0)
  {
    cp = fmgn.GetCrossPoint();
  }
  if ((cp == 0) || (cp->GetFrameObject() == 0)) 
  {
    return;
  }
  Rect r = cp->GetFrameObject()->GetInternalRect();
  word pacent0 = 0;
  word position = 0;
  switch (m) 
  {
   case 1: 		// top
    if (r.y2 <=  r.y1) 
    {
      return;
    }
    position = pos.y - r.y1;
    pacent0 = (word) (((long) position * 1000L) / (long) (r.y2 - r.y1));
    break;
    
   case 2: 		// bottom
    if (r.y2 <= r.y1) 
    {
      return;
    }
    position = r.y2 - pos.y;
    pacent0 = (word) (((long) position * 1000L) / (long) (r.y2 - r.y1));
    break;
    
   case 3:		// left
    if (r.x2 <= r.x1) 
    {
      return;
    }
    position = pos.x - r.x1;
    pacent0 = (word) (((long) position * 1000L) / (long) (r.x2 - r.x1));
    break;
    
   case 4:		// right
    if (r.x2 <= r.x1) 
    {
      return;
    }
    position = r.x2 - pos.x;
    pacent0 = (word) (((long) position * 1000L) / (long) (r.x2 - r.x1));
    break;
    
   default:
    return;
  }
  if (position < 0)
  {
    pacent0 = 0;
    position = 0;
  }
  
  // position and %
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_MP);
  PWordPresentation::GetPageBox()->SetMP(iu_to_mm0(position), pacent0);
}

// show move paragraph margin position
void 
EditFrame::ShowMoveParagraphMarginPos(Vector& pos)
{
  bool tate_p = setmgn.GetTateP();
  EMSetMargin::LockMargin mgn = setmgn.GetLockMargin();
  
  FrameInstance* fi = setmgn.GetFrame();
  Rect r = fi->GetFrameTemplate()->GetInternalRect();
  Margin m = fi->GetFrameTemplate()->GetMargin();
  
  r.y1 += m.GetTop();
  r.y2 -= m.GetBottom();
  r.x1 += m.GetLeft();
  r.x2 -= m.GetRight();
  
  if ((r.x1 >= r.x2) || (r.y1 >= r.y2))
  {
    return;
  }
  word pacent0 = 0;
  word position = 0;
  
  switch (mgn) 
  {
   case EMSetMargin::FirstMargin:
   case EMSetMargin::LeftMargin:
    if (tate_p)
    {
      position = pos.y - r.y1;
      pacent0 = (word) (((long) position * 1000L) / (long) (r.y2 - r.y1));
    }
    else
    {
      position = pos.x - r.x1;
      pacent0 = (word) (((long) position * 1000L) / (long) (r.x2 - r.x1));
    }
    break;
    
   case EMSetMargin::RightMargin:
    if (tate_p)
    {
      position = r.y2 - pos.y;
      pacent0 = (word) (((long) position * 1000L) / (long) (r.y2 - r.y1));
    }
    else
    {
      position = r.x2 - pos.x;
      pacent0 = (word) (((long) position * 1000L) / (long) (r.x2 - r.x1));
    }
    break;
    
   default:
    return;
  }
  
  // position and %
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_MP);
  PWordPresentation::GetPageBox()->SetMP(iu_to_mm0(position), pacent0);
}

// show change table size
void 
EditFrame::ShowResizeTableSize(Iunit new_pos)
{
  Fission* f = move.GetMoveFission();
  Vector new_size = GetEditFF()->GetSize();
  if (f->GetDir() == Fission::Vertical) 
  {
    // change x direction
    Fission* right = GetEditFF()->GetRight();
    Fission* left = GetEditFF()->GetLeft();
    if (f == left) 
    {
      new_size.x = right->GetPoint() - new_pos;
    }
    else if (f == right) 
    {
      new_size.x = new_pos;
    }
    if (new_size.x < 0) 
    {
      new_size.x = - new_size.x;
    }
  }
  else 
  {
    // change y direction
    Fission* top = GetEditFF()->GetTop();
    Fission* bottom = GetEditFF()->GetBottom();
    if (f == top) 
    {
      new_size.y = bottom->GetPoint() - new_pos;
    }
    else if (f == bottom) 
    {
      new_size.y = new_pos;
    }
    if (new_size.y < 0) 
    {
      new_size.y = - new_size.y;
    }
  }
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_HW);
  PWordPresentation::GetPageBox()->SetWH(iu_to_mm0(new_size.x), 
					   iu_to_mm0(new_size.y));
}

void 
EditFrame::ShowResizeTableSize(Vector pos)
{
  CrossPoint* cp = move.GetScaleCorner();
  Fission* top = GetEditFF()->GetTop();
  Fission* bottom = GetEditFF()->GetBottom();
  Vector new_size = bottom->GetEndPoint();
  if (cp == top->GetStartCrossPoint()) 
  {
    new_size -= pos;
  }
  else if (cp == top->GetEndCrossPoint()) 
  {
    new_size.x = pos.x;
    new_size.y -= pos.y;
  }
  else if (cp == bottom->GetStartCrossPoint()) 
  {
    new_size.x -= pos.x;
    new_size.y = pos.y;
  }
  else if (cp == bottom->GetEndCrossPoint()) 
  {
    new_size = pos;
  }
  else 
  {
    return;
  }
  if (new_size.x < 0) 
  {
    new_size.x = - new_size.x;
  }
  if (new_size.y < 0) 
  {
    new_size.y = - new_size.y;
  }
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_HW);
  PWordPresentation::GetPageBox()->SetWH(iu_to_mm0(new_size.x), 
					   iu_to_mm0(new_size.y));
}

void 
EditFrame::ShowResizeTableSize()
{
  Vector size = GetEditFF()->GetBottom()->GetEndPoint();
  PWordPresentation::GetPageBox()->SetMode(PageBox::PBM_HW);
  PWordPresentation::GetPageBox()->SetWH(iu_to_mm0(size.x), 
					   iu_to_mm0(size.y));
}
