// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pref.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// preference

#ifndef PREF_H
#define PREF_H

// Enum_Desc define enumerated integer preference.
// Ex.
//
// Enum_Desc button_size_desc =
// {{"small",	5},
//  {"medium",	6},
//  {"large",	7},
//  {NULL,	6}};
//
// NULL indicates end of vector, and VALUE slot of last element is a
// default value.

// Force NEAR allocation for Enum_Desc instance.
#define Enum_Desc Enum_Desc_Rec STATIC_NEAR
struct Enum_Desc_Rec
{
  char* name;
  int value;
};

// for file-name list, search string list.
class String10
{
private:
  char* string[10];
  int changed_;

public:
  String10();

public:
  char* String10::get_string(int n);
  int String10::changed();
  void String10::add_string(char* s);
  void String10::set_changed(int changed);
};

#define PREF_MAX_EXPR_ARGS 7

enum Pref_Value_Type
{
  Pref_Value_INTEGER,
  Pref_Value_STRING,
};

struct Pref_Value
{
  Pref_Value_Type type;
  union
  {
    int i;
    char* s;
  } u;
};

struct Pref_Expr
{
  char* op;
  int num_args;
  Pref_Value args[PREF_MAX_EXPR_ARGS];
};

class Pref
{
public:
  static char* Pref::enum_to_string(Enum_Desc* desc, int value);
  static char* Pref::read_string(char* key);
  static char* Pref::read_string(char* key, char* def);
  static int Pref::begin_profile();
  static int Pref::enum_value(Enum_Desc* desc, char* s);
  static int Pref::read_expr(Pref_Expr* expr);
  static void Pref::custom();
  static void Pref::end_profile();
  static void Pref::flush_expr(char* key);
  static void Pref::read_profile();
  static void Pref::set_expr(char* s);
  static void Pref::set_item_string10(HWND dialog, int item_id, String10* string10);
  static void Pref::start_write_expr();
  static void Pref::write_expr(Pref_Expr* expr);
  static void Pref::write_profile();
};

#define PREF_BOOLEAN(name, key, def, cust, fn, doc) \
extern int STATIC_NEAR name;

#define PREF_ENUM(name, key, desc, cust, fn, doc) \
extern int STATIC_NEAR name;

#define PREF_INTEGER(name, key, min, max, def, cust, fn, doc) \
extern int STATIC_NEAR name;

#define PREF_MM0(name, key, min, max, def, cust, fn, doc) \
extern int STATIC_NEAR name;

#define PREF_STRING(name, key, def, cust, fn, doc) \
extern char* STATIC_NEAR name;

#define PREF_STRING10(name, key, cust, fn, doc) \
extern String10 STATIC_NEAR name;

#include "pref_m.h"

#endif /* PREF_H */
