// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: psetdlg.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of PrinterSetupDialog class

#include "pword.h"
#include "pmenus.h"
#include <drivinit.h>
#include "dialogs.h"
#include "printeri.h"
#include "xstr.h"
#include "psetdlg.h"

#ifdef _WIN32
#include <string.h>
#define _fstrchr strchr
#endif /* _WIN32 */

PrinterSetupDialog::PrinterSetupDialog(PrinterInfo* pi, bool ao)
{
  this->class_name = "PrinterSetup";
  printer_info = new PrinterInfo(*pi);
  active_only = ao;
}

// Dialog function for use by "Printer setup" box.
LRESULT_T
PrinterSetupDialog::WndProc(MSG_T wMsg, WPARAM_T wParam, LPARAM_T lParam)
{
  char print_info[MAXPRINTINFOLEN];
  BOOL fProcessed = TRUE;
  switch (wMsg) 
  {
   case WM_INITDIALOG:
    {
      RECT rc;
      // Set TABSTOP in listbox to right-edge of its window.
      GetClientRect(&rc);
      int x;
      x = (rc.right * LOWORD(GetDialogBaseUnits())) / 4;
      SendItemMessage(IDD_PRINTSETPRINTERBOX,
		       LB_SETTABSTOPS, 1, Ptr2Long(&x));
      FillPrinterBox();
    }
    break;

   case WM_DESTROY:
    break;

   case WM_WININICHANGE:
    // Check if user changed the list of printers from another 
    // application(most likely - Control Panel).
    if (stricmp((LPSTR) lParam, "devices") != 0 && lParam != NULL)
    {
      break;
    }
    // If printers have changes, refill the list box.
    FillPrinterBox();
    break;

   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_PRINTSETPRINTERBOX:
#ifdef _WIN32
      if (HIWORD(wParam) == LBN_DBLCLK)
#else /* _WIN32 */
      if (HIWORD(lParam) == LBN_DBLCLK)
#endif /* _WIN32 */
      {
	// Get the ID of the default pushbutton.  Note, assume that the
	// HIWORD from sending DM_GETDEFID is DC_HASDEFID.
	int nDefID = LOWORD(SendMessage(DM_GETDEFID, 0, 0));
	
	// Simulate the user selecting the default pushbutton.
#ifdef _WIN32
	SendMessage(WM_COMMAND, MAKELONG(nDefID, BN_CLICKED),
		    (LPARAM_T)GetItem(nDefID));
#else /* _WIN32 */
	SendMessage(WM_COMMAND, nDefID,
		    MAKELONG(GetItem(nDefID), BN_CLICKED));
#endif /* _WIN32 */
      }
      break;

     case IDD_PRINTSETSETUP:
     case IDOK:
      {
	HWND hWndList;
#ifdef _WIN32
	if (HIWORD(wParam) != BN_CLICKED) break;
#else /* _WIN32 */
	if (HIWORD(lParam) != BN_CLICKED) break;
#endif /* _WIN32 */

	hWndList = GetItem(IDD_PRINTSETPRINTERBOX);

	// Get information about currently selected printer.
	int x = (int) ::SendMessage(hWndList, LB_GETCURSEL, 0, 0L);
	::SendMessage(hWndList, LB_GETTEXT, x, (LONG) (LPSTR) print_info);
	// print_info = "Generic / Text Only on FILE:\tGeneric / Text Only=TTY,FILE:"

	// If OK button pressed, do setup without displaying the printer's 
	// settings dialog box.
	PrinterInfo* new_info = new PrinterInfo;
	PrinterInfo::SNP snp_error = 
	new_info->SetupNewPrinter(printer_info, 
#ifdef _WIN32
				  (LOWORD(wParam) == IDOK) ? NULL : GetHandle(),
#else /* _WIN32 */
				  (wParam == IDOK) ? NULL : GetHandle(),
#endif /* _WIN32 */
				  _fstrchr(print_info, '\t') + 1);

	// New printer setup block returned, save it in the window property.
	if (snp_error == PrinterInfo::SNP_SUCCESS)
	{
	  delete printer_info;
	  printer_info = new_info;
	}
	else 
	{
	  switch (snp_error)
	  {
	   case PrinterInfo::SNP_NODRIVER:
	    Issue(S_CantFindDriverMsg, MB_OK | MB_ICONEXCLAMATION);
	    break;
	    
	   case PrinterInfo::SNP_INVALIDDRIVER:
	    Issue(S_BadDriverMsg, MB_OK | MB_ICONEXCLAMATION);
	    break;
	    
	   case PrinterInfo::SNP_NOMEMORY:
	    Issue(S_OutOfMemoryMsg, MB_OK | MB_ICONEXCLAMATION);
	  }
	  delete new_info;
	}

#ifdef _WIN32
	if (LOWORD(wParam) == IDOK)
#else /* _WIN32 */
	if (wParam == IDOK)
#endif /* _WIN32 */
	{
	  // Terminate the dialog box & return handle to new printer setup.
	  End(1);
	} 
	else
	{
	  // Set the "Ok" button back to the default button.
	  SendMessage(DM_SETDEFID, IDOK);
	  SendItemMessage(IDD_PRINTSETSETUP, BM_SETSTYLE, (int) BS_PUSHBUTTON, TRUE);
	  SendItemMessage(IDOK, BM_SETSTYLE, (int) BS_DEFPUSHBUTTON, TRUE);

	  // Set the focus back to the listbox.
	  ::SetFocus(GetItem(IDD_PRINTSETPRINTERBOX));
	}
      }
      break;

     case IDCANCEL:
      // Return NULL to caller stating that no change to selected printer.
      End(0);
      break;
    }
    break;

   case WM_CLOSE:
    End(0);
    break;

   default: 
    fProcessed = FALSE; 
    break;
  }
  return fProcessed;
}

void
PrinterSetupDialog::FillPrinterBox()
{
  char null_port[MAXPORTLEN];
  char all_printers[5 * MAXPRINTINFOLEN];

  // Get list of all printers installed by user.
  int x = GetProfileString("devices", NULL, "", all_printers,sizeof(all_printers));
  if (x == sizeof(all_printers) - 2)
  {  // Buffer too small.
    Issue(S_TooManyPrintersMsg, MB_OK | MB_ICONEXCLAMATION);
    char* printer = all_printers + sizeof(all_printers) - 3;
    while (printer > all_printers && *printer != 0)
    {
      *printer-- = 0;
    }
  }

  // Retrieve the name of the NullPort(usually "None").
  GetProfileString("windows", "NullPort", "", null_port, sizeof(null_port));


  // Tell the listbox NOT to update its display & empty it.
  SendItemMessage(IDD_PRINTSETPRINTERBOX, WM_SETREDRAW);
  SendItemMessage(IDD_PRINTSETPRINTERBOX, LB_RESETCONTENT);
  
  // Fill the LISTBOX with printers from [devices] section of WIN.INI.
  char* printer = all_printers;

  for (; *printer != 0; printer = _fstrchr(printer, 0) + 1)
  {
    // Get the driver name and port for the printer.
    char print_info[ MAXPRINTINFOLEN ];
    GetProfileString("devices", printer, "", print_info, sizeof(print_info));
    // printer = "IBM Graphics"
    // print_info = "IBMGRX,LPT1:,COM2:"

    char* cur_port = _fstrchr(print_info, ',');
    if (cur_port != NULL)
    {
      *cur_port++ = 0;
    }
    // print_info  = "IBMGRX"
    // cur_port = "LPT1:,COM2:"

    while (cur_port != NULL)
    {
      // If another port exists, terminate the string at the comma.
      char* temp = _fstrchr(cur_port, ',');
      if (temp != NULL) *temp = 0;
      // cur_port = "LPT1:"
	
      // If active only && printer NOT active, don't add to listbox.
      if (active_only && lstrcmpi(cur_port, null_port) == 0) 
      {
	;  // Do nothing.
      } 
      else 
      {
	// Build string that has the following form:
	//    "(device) ON(port)\t(device)=(driver),(port)"
	// Example: "IBM Graphics on LPT1:\tIBM Graphics=IBMGRX,LPT1:"
	char buf1[MAXPRINTINFOLEN*2];
	wsprintf(buf1, S_PrinterSetupString, printer, cur_port);
	char buf2[MAXPRINTINFOLEN*2];
	wsprintf(buf2, "%s\t%s=%s,%s",
		  buf1,
		  (LPSTR) printer,
		  (LPSTR) print_info,
		  (LPSTR) cur_port);
	
	// Add string to listbox. Note, the listbox sorts the printers
	// in alpha-order because LBS_SORT style used in dlg template.
	SendItemMessage(IDD_PRINTSETPRINTERBOX, LB_ADDSTRING, 0, (LONG) (LPSTR) buf2);
      }

      // Find next port if it exists.
      cur_port = temp;
      if (cur_port != NULL) 
      {
	cur_port++;
      }
      // cur_port = "COM2:"
    }
  }

  int nNumPrinters = (int) SendItemMessage(IDD_PRINTSETPRINTERBOX, 
					   LB_GETCOUNT);
  if (nNumPrinters == 0) 
  {
    Issue(S_NoPrinterMsg, MB_OK | MB_ICONEXCLAMATION);
      
    // Sending the WM_COMMAND w/IDCANCEL to terminate the dialog box
    // will free the memory allocated during the processing
    // of WM_INITDIALOG message.
#ifdef _WIN32
    SendMessage(WM_COMMAND, MAKELONG(IDCANCEL, BN_CLICKED),
		(LPARAM_T)GetItem(IDCANCEL));
#else /* _WIN32 */
    SendMessage(WM_COMMAND, IDCANCEL,
		MAKELONG(GetItem(IDCANCEL), BN_CLICKED));
#endif /* _WIN32 */
    return;
  }
  // Listbox is filled, determine which printer to select initially.
  SetDefaultPrinter();
  // Tell the listbox that it is now OK to update its display.
  SendItemMessage(IDD_PRINTSETPRINTERBOX, WM_SETREDRAW, TRUE);
  // Force the listbox to be completely redrawn.
  ::InvalidateRect(GetItem(IDD_PRINTSETPRINTERBOX), NULL, TRUE);
}

void 
PrinterSetupDialog::SetDefaultPrinter()
{
  // Set up the default selection in the listbox.
  HWND hWndList = GetItem(IDD_PRINTSETPRINTERBOX);
    
  // Get the information for the default printer selected by the user.
  char def_info[MAXPRINTINFOLEN];
  GetProfileString("windows", "device", "", def_info, sizeof(def_info));

  PrinterInfo def_printer;
  if (*def_info != 0)
  {
    def_printer.ParsePrintInfo(def_info, FALSE);
  } 

  int nDefPrint = -1;
  int nNumPrinters = (int) SendItemMessage(IDD_PRINTSETPRINTERBOX, 
					   LB_GETCOUNT);
  // Cannot be zero because of check in PSM_FILLPRINTERBOX message.

  for (int x = 0; x < nNumPrinters; x++)
  {
    // Get line 'x' from the listbox.
    char print_info[ MAXPRINTINFOLEN ];
    ::SendMessage(hWndList, LB_GETTEXT, x, (LONG) (LPSTR) print_info);

    // PrintInfo string is after the TAB('\t') character.
    PrinterInfo this_printer;
    this_printer.ParsePrintInfo(_fstrchr(print_info, '\t') + 1, FALSE);

    // Remember index in listbox where the "default printer" is located.
    if (lstrcmpi(this_printer.device_name, def_printer.device_name) == 0 &&
	lstrcmpi(this_printer.port_name, def_printer.port_name) == 0) 
    {
      nDefPrint = x;
    }
    
    // If device and port of listbox entry & printer in PSSTRUCT block
    // match, set that printer as the default and stop the "for" loop.
    if (lstrcmpi(this_printer.device_name, 
		 printer_info->device_name) == 0 &&
	lstrcmpi(this_printer.port_name, printer_info->port_name) == 0) 
    {
      ::SendMessage(hWndList, LB_SETCURSEL, x, 0);
      break;
    }
  }

  if (x == nNumPrinters)
  {
    // Printer in memory block didn't match any printer in listbox.

    // Set selection to "default printer" if it was found.
    ::SendMessage(hWndList, LB_SETCURSEL,
		  (nDefPrint == -1) ? 0 : nDefPrint, 0);
  }
}
