// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pword.h,v 3.8 1999/07/24 15:38:09 kudou Exp $
// BeatWord common header file.  (pword is a old project name.)
// This header file contains global messages and structures.

#ifndef PWORD_H
#define PWORD_H

#include "config.h"

// ------------------------------------------------------------
// compiler version control(from compiler.h)

// Borland C++
#ifdef __BORLANDC__
#  if (__BORLANDC__ == 0x0300)		// Borland C++ Version 2.0
#    define BCC2
#  elif (__BORLANDC__ == 0x0400)	// Borland C++ Version 3.0
#    define BCC3
#  elif (__BORLANDC__ == 0x0402)	// Borland C++ Version 3.1 beta
#    define BCC31
#  elif (__BORLANDC__ == 0x0410)	// Borland C++ Version 3.1
#    define BCC31
#  elif (__BORLANDC__ == 0x0452)	// Borland C++ Version 4.02 
#    define BCC4
#  elif (__BORLANDC__ == 0x0500)	// Borland C++ Version 5.0
#    define BCC5
#  endif
#endif

#if (!defined(BCC2))
#  define PREFIX(a) a::
#else
#  define PREFIX(a)
#endif

#ifdef __BORLANDC__
// Pack all far segment
#  pragma option -zEbw_far
#endif

// VC
#ifdef _MSC_VER
#  if (_MSC_VER == 900)			// need checking
#    define MSC7
#    define MSC7_FUNARG_BUG
#  endif
// if (_MSC_VER == 1000)		// VC Version 4.0
// if (_MSC_VER == 1010)		// VC Version 4.1
// if (_MSC_VER == 1020)		// VC Version 4.2
// if (_MSC_VER == 1100)		// VC Version 5.0
#  if (_MSC_VER == 1200)		// VC Version 6.0
#    define VC6
#    define HAS_BOOL
#    define HAS_BYTE
#    define MSC7_FUNARG_BUG
#  endif
#endif /* _MSC_VER */

#if defined(BCC3) || defined(BCC31) || defined(BCC4) || defined(BCC5)
#  define VA_LIST char*
#elif defined(VC6)
#  define VA_LIST char*
#else
#  define VA_LIST void*
#endif

#ifdef _WIN32
#  define _export
#endif /* _WIN32 */

// version of windows.h
#if (C_SYSTEM == C_SYSTEM_MSC7) || (C_SYSTEM == C_SYSTEM_BC31)
// for Windows 3.1
#  define VERSION_OF_WINDOWS_H 31
#elif _WIN32
// for Win32
#  define VERSION_OF_WINDOWS_H 32
#else
// for Windows 3.0
#  define VERSION_OF_WINDOWS_H 30
#endif


// ------------------------------------------------------------

#if (!defined(NOT_WINDOWS) && !defined(_Windows))
#define _Windows
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>


// ------------------------------------------------------------
// for Beatword Version 2
#ifdef BW2

#if (C_SYSTEM == C_SYSTEM_MSC7)
// suppress _fastcall keyword
#define _fastcall
#endif

#if (C_SYSTEM == C_SYSTEM_MSC7)
// define Japanese Windows symbols
#define VK_NONCONVERT 0x1D
#endif

#include "windows/bwcc.h"
extern "C" {
#include "windows/ime.h"
}

#endif /* BW2 */

// ------------------------------------------------------------
// for Beatword Version 3
#ifdef BW3

#include <ime.h>

#endif /* BW3 */

// ------------------------------------------------------------
// adjust for any type of compilers.

// Next 4 symbols, CDECL, PASCAL, NEAR, and FAR are used in BeatWord project.
// Don't use Cdecl, _FAR, etc ...
#ifndef CDECL
#define CDECL cdecl
#endif
#ifndef PASCAL
#define PASCAL pascal
#endif
#ifndef NEAR
#define NEAR near
#endif
#ifndef FAR
#define FAR far
#endif

// Windows compat
#ifndef WINAPI
#  define WINAPI FAR PASCAL
#endif
#ifndef CALLBACK
#  define CALLBACK FAR PASCAL
#endif

// type of window procedure arguments
#if (VERSION_OF_WINDOWS_H < 31)
#  define LRESULT_T LONG
#  define MSG_T WORD
#  define WPARAM_T WORD
#  define LPARAM_T LONG
#else
#  define LRESULT_T LRESULT
#  define MSG_T UINT
#  define WPARAM_T WPARAM
#  define LPARAM_T LPARAM
#endif

// ------------------------------------------------------------
// class declaration

class Again;
class AttsEntry;
class AutoSaveDialog;
class BP;
class BitString;
class BlockStream;
class BoundBufferPointer;
class BoundInterval;
class BoundIntervalList;
class Boxes;
class BufStream;
class Buffer;
class Document;
class DocumentCaret;
class DocumentChar;
class DocumentClip;
class DocumentContent;
class DocumentEdit;
class DocumentMouse;
class DocumentPresentation;
class DocumentSelection;
class DocumentWindow;
class EditCharAtts;
class EditFrame;
class EditPage;
class EditParAtts;
class FileOpenDialog;
class FileStream;
class Fission;
class FrameInstance;
class FrameRectRgn;
class FrameTemplate;
class HFission;
class Interval;
class IntervalList;
class LayoutInstance;
class LayoutTemplate;
class Line;
class MDIClient;
class MainWindow;
class MemoryStream;
class MessBox;
class PClipboard;
class PClipboardRead;
class PClipboardWrite;
class PModalDialog;
class PModelessDialog;
class PStream;
class PTimer;
class PUndo;
class PUndoAtom;
class PUndoItem;
class PWordBase;
class PWordPresentation;
class PageBox;
class PageMap;
class Panel;
class PrefDialog;
class Preferences;
class PrinterIC;
class PrinterInfo;
class Stats;
class TablePanel;
class TextFlow;
class VDisplay;
class VFission;
class VMem;
class VText;
class VTextPanel;
class View;
class Window;

struct Dpoint;
struct Drect;
struct Ipoint;
struct Irect;
struct Lpoint;
struct Lrect;

// COMPAT
typedef Buffer EditText;
typedef Buffer Paragraph;
typedef BP BufferPointer;
typedef BP* BPP;

#ifndef NDEBUG
class DebugDisplay;
#endif

// ------------------------------------------------------------
// basic type and constant definition

#ifdef _WIN32
#ifndef HAS_BOOL
typedef char bool;
#endif /* HAS_BOOL */
#ifndef HAS_BYTE
typedef signed char byte;
#endif /* HAS_BYTE */
typedef unsigned char ubyte;
typedef short int word;
typedef unsigned short int uword;
typedef long int dword;
typedef unsigned long int udword;
#else /* _WIN32 */
#ifndef HAS_BOOL
typedef char bool;
#endif /* HAS_BOOL */
#ifndef HAS_BYTE
typedef signed char byte;
#endif /* HAS_BYTE */
typedef unsigned char ubyte;
typedef short int word;
typedef unsigned int uword;
typedef long dword;
typedef unsigned long udword;
#endif /* _WIN32 */

typedef bool flag;		// flag
typedef uword sjis;		// Shift JIS

#ifdef _WIN32
// this type is used for reading 16-bit enum value in case of
// file read, etc...  
typedef short int bit16_enum_t;
#endif /* _WIN32 */

// Using macro rather than C-constant.
#define True 1
#define False 0

#ifndef NULL
#define NULL 0
#endif

#define BITS_PER_CHAR 8
#define LOG2_OF_BITS_PER_CHAR 3

#define BITS_PER_INT 16
#define LOG2_OF_BITS_PER_INT 4

#define MAX_UCHAR 255

// ------------------------------------------------------------
// basic units definition(from iunits.h)

// default character size.  This is used to initialize some default size,
// frame margin, ...
#define DEFAULT_POINT 12

#define POINTS_PER_INCH 72
#define MM_PER_INCH 25.3999

// Device unit(depend on Windows)
#ifdef _WIN32
typedef signed int Dunit;
#else /* _WIN32 */
typedef signed int Dunit;
#endif /* _WIN32 */

// Internal unit.
#ifdef _WIN32
typedef signed int Iunit;
#else /* _WIN32 */
typedef signed int Iunit;
#endif /* _WIN32 */

// Logical unit(Document's common coordinates)
#ifdef _WIN32
typedef signed long Lunit;
#else /* _WIN32 */
typedef signed long Lunit;
#endif /* _WIN32 */

#ifdef BW3
typedef word Bw2_Dunit;
typedef word Bw2_Iunit;
typedef dword Bw2_Lunit;
#endif /* BW3 */

#define IUNITS_PER_INCH 360
#define IUNITS_PER_INCH_F 360.0
#define IUNITS_PER_POINT 5

// unit converters

#define MM0_PER_INCH 254L
#define IU_PER_INCH 360L

// Be care, `b' must be positive.
#ifdef ROUND_DIV
#error
#endif
#define ROUND_DIV(a, b) (((a) + ((b) >> 1)) / (b))

#define mm0_to_iu(a) ((int) ROUND_DIV((a) * IU_PER_INCH, MM0_PER_INCH))
#define iu_to_mm0(a) ((int) ROUND_DIV((a) * MM0_PER_INCH, IU_PER_INCH))

#define mm_to_iu(a) ((int) ROUND_DIV((a) * IU_PER_INCH * 10, MM0_PER_INCH))
#define iu_to_mm(a) ((int) ROUND_DIV((a) * MM0_PER_INCH, IU_PER_INCH * 10))

#define Inch_to_iu(x) ((Iunit) (IUNITS_PER_INCH * (x)))
#define Point_to_iu(x) ((Iunit) (IUNITS_PER_POINT * (x)))

// ------------------------------------------------------------
// describe contents of "attr" type(from cookie.h)

typedef uword attr;

// IV_MASK means that the character is inverted somehow in order to show
// that it is selected.
// IV_SUBMASK is used for not-main selections.
#define IV_MASK ((int) 0x8000)
#define IV_SUBMASK ((int) 0x4000)
#define IV_ALLMASK (IV_MASK | IV_SUBMASK)

// ------------------------------------------------------------
// routines defined on jis strings

// Compare 2 sjis strings J1, J2 with length LEN.  Returns 0 if strings are
// equal, otherwise returns non-zero value.
#define jiscmp(j0, j1, length) memcmp(j0, j1, sizeof(sjis)* (length))

char* jis_squeeze(sjis* chars, int num_chars, int* len_ret);
int jislen(sjis* j);
sjis* jis_spread(char* chars, int num_chars, int* len_ret);
sjis* jisz_spread(char* chars, int* len_ret);

// ------------------------------------------------------------
// Windows version control

// don't reference this value directly.
extern WORD windows_version_;

#define windows_version() windows_version_
#define windows_31_or_later_p() (0x030a <= windows_version())
#define windows_has_true_type_p() windows_31_or_later_p()

#ifdef BW21_W32
#define windows_95_or_later_p() (0x035f <= windows_version())
bool windows_w32_env_p();
bool windows_nt4_env_p();
#endif /* BW21_W32 */


// ------------------------------------------------------------
// BeatWord Command table(in pword.cpp)

struct Command_Desc
{
  char* guide;
  char* name;
  int idm_code;
};

Command_Desc** get_command_by_guide_table();
Command_Desc** get_command_by_name_table();
Command_Desc* command_by_idm(int idm_code);
Command_Desc* command_by_name(char* name);
int get_command_table_length();
void init_command_table();

#define MAX_COMMAND_NAME_LENGTH 32

// ------------------------------------------------------------
// macros of accessor definition

#define DEFINE_READER(name, place, type) \
type \
name() \
{ \
  return(this->place); \
}

#define DEFINE_WRITER(name, place, type) \
void \
set_ ## name(type a) \
{ \
  this->place = a; \
}

#define DEFINE_ACCESSOR(name, place, type) \
DEFINE_READER(name, place, type) \
DEFINE_WRITER(name, place, type)

// ------------------------------------------------------------
// unified XY direction control

// Index of xy array.
#define INDEX_X 0
#define INDEX_Y 1

// Index of top/bottom array.
#define INDEX_TOP INDEX_X
#define INDEX_BOT INDEX_Y

// Aliases of INDEX_[XY]

// width and height
#define INDEX_WIDTH INDEX_X
#define INDEX_HEIGHT INDEX_Y

// horizontal and vertical
#define INDEX_HORIZONTAL INDEX_X
#define INDEX_VERTICAL INDEX_Y

// Using xor operation
#define REVERSED_INDEX(i) ((i) ^ 1)

// Check index of xy array at debug time.
#ifdef NDEBUG
#define CHECK_INDEX_XY(index_xy)
#else
#define CHECK_INDEX_XY(index_xy) \
assert((index_xy) == INDEX_X || (index_xy == INDEX_Y))
#endif

// Check index of top/bottom array at debug time.
#define CHECK_INDEX_TOPBOT(index_topbot) CHECK_INDEX_XY(index_topbot)

// ------------------------------------------------------------
// menu handling

#ifdef _WIN32
#  define PW_MENU_STATE 0x0007
#else /* _WIN32 */
#  define PW_MENU_STATE 0x0001
#endif /* _WIN32 */

#ifdef BW3_DISPATCH
inline bool MENU_STATE_P(WORD notify_code) { return notify_code == PW_MENU_STATE; }
//#define IF_MENU_STATE if (MENU_STATE_P(notify_code))
#define MENU_STATE_ENABLED \
do \
{ \
  if (MENU_STATE_P(notify_code)) \
  { \
    return MF_ENABLED; \
  } \
} while (0); \

#define MENU_STATE(state) \
do \
{ \
  if (MENU_STATE_P(notify_code)) \
  { \
    return(state); \
  } \
} while (0); \

#else /*  BW3_DISPATCH */
// `lParam'Amenu-state`FbN邽߂̒loB
#define LPARAM_MENU_STATE(lParam) ((int) LOWORD(lParam))
#define MENU_STATE_P(lParam) (LPARAM_MENU_STATE(lParam) == PW_MENU_STATE)
#define IF_MENU_STATE if (MENU_STATE_P(lParam))
#define MENU_STATE_ENABLED \
do \
{ \
  IF_MENU_STATE \
  { \
    return(0); \
  } \
} while (0); \

#define MENU_STATE(state) \
do \
{ \
  IF_MENU_STATE \
  { \
    return(state); \
  } \
} while (0); \

#endif /*  BW3_DISPATCH */




// ------------------------------------------------------------
// EditMode from pwordpre.h

enum EditMode
{
  Error_MODE = 0,
  InputText_MODE,
  SelectFrame_MODE,
  FrameMargin_MODE,
  SetMargin_MODE,
  MakeTable_MODE,
  MoveLine_MODE,
  DrawLine_MODE,
  Cut_MODE,
  SetFlow_MODE,
  ExchFlow_MODE,
  EditMode_UNUSED_MAX,
  EditMode_DEFAULT = InputText_MODE,
  EditMode_FIRST = InputText_MODE,
  EditMode_LAST = ExchFlow_MODE,
};

// Check MODE is a valid EditMode.
#define VALID_EDIT_MODE_P(mode) \
((unsigned int) (mode) - 1 < EditMode_UNUSED_MAX - 1)

// ------------------------------------------------------------
// misc

#define XSTR(s) #s
#define XXSTR(s) XSTR(s)

// The Constructor and Destructor keywords are designed to improve
// readability and allow searching for constructors etc.
#define  Constructor
#define  Destructor

// This macro generate too many strings.  SHUT-OUT !
#if (0)
#ifndef NDEBUG
#define THIS_CHECK \
do \
{ \
  if (this == NULL) \
  { \
    syserr("null this: %s %d", __FILE__, __LINE__); \
  } \
} while (0)
#else
#define THIS_CHECK
#endif
#endif

#define THIS_CHECK

#define PTR_SIZE 4
#define Ptr2Long(p) ((DWORD) (void far*) (p))
#define Long2Ptr(l) ((void far*) (l))
#define GetWindowPtr(Wnd, Num) GetWindowLong(Wnd, (Num)* PTR_SIZE)
#define SetWindowPtr(Wnd, Num, Ptr) \
SetWindowLong(Wnd, (Num)* PTR_SIZE, (LONG) (Ptr))

#define MAX(x,y) (((x) > (y)) ? (x) : (y))
#define MIN(x,y) (((x) < (y)) ? (x) : (y))
#define CONTROLCH(x) ((x) - 0x40)

#define SET_MAX(a, b) \
do \
{ \
  if ((a) < (b)) \
  { \
    (a) = (b); \
  } \
} while (0)

#define SET_MIN(a, b) \
do \
{ \
  if ((b) < (a)) \
  { \
    (a) = (b); \
  } \
} while (0)

#define SET_BOUND(a, b, c) \
do \
{ \
  SET_MAX(a, b); \
  SET_MIN(a, c); \
} while (0)

// get number of vector's elements
#define NUMBER_OF(vector) (sizeof(vector) / sizeof(vector[0]))

// Canonical newline  -- frigging ROGUE has already defined NL
// as "\n", which is incredibly useful in C programs.
#define NLC '\n'
// End of buffer
#define EOB '\0'
// End of interval
#define EOP 1

// array index and device indicater
#define PRINTER 0
#define SCREEN 1

extern Document* Selected_Document;
extern DocumentWindow* Selected_Window;
extern HWND main_window_handle;
extern LayoutInstance* current_top_level_layout;
extern MainWindow* main_window;
extern PrinterInfo* Printer_Info;

char* copy_string(char* dest, char* src, int size);
char* dup_string(char* s);
char* int_to_string(int i);
char* mm0_to_string(int mm0);
int CDECL IssueVA(char* format, int flags, ...);
int Issue(char* message, int flags);
int StepSize(int, int, int*);
int ceil_log2(int a);
int gcd(int a, int b);
int get_item_button_unit(HWND dialog, int item_id, int* int_ret);
int get_item_int(HWND dialog, int item_id, int* int_ret);
int get_item_int_or_mm0(HWND dialog, int item_id, int* i_ret, int mm0);
int get_item_mm0(HWND dialog, int item_id, int* mm0_ret);
int string_to_int(char* s, int* i_ret);
int string_to_mm0(char* s, int* mm0_ret);
#ifdef BW3_DISPATCH
LRESULT_T dispatch_command(WORD command, WORD notify_code, HWND hwnd);
LRESULT_T dispatch_simple_command(WORD command);
int dispatch_inc_dec(WORD inc_command, WORD dec_command);
LRESULT_T disabled_command(bool menu_state_p);
#else /* BW3_DISPATCH */
long dispatch_command(int command, long lParam);
long dispatch_simple_command(int command);
int dispatch_inc_dec(int inc_command, int dec_command);
long disabled_command(int menu_state_p);
#endif /* BW3_DISPATCH */
udword huge_fread(FILE* stream, void far* mem, udword count);
udword huge_fwrite(FILE* stream, void far* mem, udword count);
unsigned int xmalloc_size(void* mem);
void* huge_add(void far* base, udword offset);
void* xmalloc(unsigned int size);
void* xmalloc_on_log2(unsigned int index);
void* xmalloc_permanent(unsigned int size);
void* xmalloc_zero(unsigned int size);
void* xrealloc(void* mem, unsigned int size);
void CDECL StatusOut(char* str, ...);
void CDECL StatusOutPermanent(char* str, ...);
void CDECL syserr(char* Format, ...);
void ExitPWord(bool end = True);
void StatusClear();
void huge_memcpy(void* dest, long dest_offset, void* src, long src_offset, udword n);
void initialization_fail();
void set_item_button_unit(HWND dialog, int item_id, int i);
void set_item_int(HWND dialog, int item_id, int i);
void set_item_int_or_mm0(HWND dialog, int item_id, int i, int mm0);
void set_item_mm0(HWND dialog, int item_id, int mm0);
void xfree(void* mem);
void xfree_on_log2(void* mem, unsigned int index);

#ifndef NDEBUG
void check_all_memory();
#endif

#ifndef LOG2_OF_MAX_ALLOC
#define LOG2_OF_MAX_ALLOC 15
#elif (LOG2_OF_MAX_ALLOC < 8 || 15 < LOG2_OF_MAX_ALLOC)
#error
#endif

// Best buffer size is 4KB(currently)
#define LOG2_OF_BEST_BUFSIZE 12
#define BEST_BUFSIZE (1 << LOG2_OF_BEST_BUFSIZE)

// Maximum size of "new"able memory block.  THis value depend on new.cpp
#define MAX_NEW_SIZE ((1U << LOG2_OF_MAX_ALLOC) - 32)

#ifdef _WIN32
// MAX_PATH is 260 under Win32
#  include <windef.h>
#else /* _WIN32 */
// Maximum path length
#  define MAX_PATH 80
#endif /* _WIN32 */

#ifdef _WIN32
inline void 
LPARAM_TO_POINT(LPARAM_T lParam, POINT& p)
{
  p.x = (long)((short int)LOWORD(lParam));
  p.y = (long)((short int)HIWORD(lParam));
}

inline int
LPARAM_TO_X (LPARAM_T lParam)
{
  return (int)((short int)LOWORD(lParam));
}

inline int
LPARAM_TO_Y (LPARAM_T lParam)
{
  return (int)((short int)HIWORD(lParam));
}
#else /* _WIN32 */
inline int
LPARAM_TO_X (LPARAM_T lParam)
{
  return LOWORD(lParam);
}

inline int
LPARAM_TO_Y (LPARAM_T lParam)
{
  return HIWORD(lParam);
}
#endif /* _WIN32 */


#endif /* PWORD_H */
