// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pwordbas.h,v 3.7 1999/07/12 18:08:56 kudou Exp $
// define PWordBase class
// The PWordBase class which enforces the distinction in the internal
// pWord architecture between content and representation.

#ifndef PWORDBAS_H
#define PWORDBAS_H

// All slots and methods of this class are declared STATIC.
// Keep this rule for best performance.  (konno)

class PWordBase
{
  // constants
private:
  enum
  {
    WINDOW_LIMIT = 16,
  };

  // static slots
private:
  static Document* PWordBase::first_document;
#ifndef BW3_FILEDLG
  static FileOpenDialog* PWordBase::file_open_dialog;
#endif /* BW3_FILEDLG */
  
  // If LOBOTOMIZED is True, BeatWord cannot save file. (for sample
  // version ?)
  static int lobotomized;

  // All methods are STATIC.
private:
  static Document* NEAR NewDocument(Document* d);
  static void NEAR AddDocument(Document* d);
#ifdef BW3_REGCHECK
  static void RegistoryCheck();
#endif /* BW3_REGCHECK */
  static bool CommandLine(char* cmd_line);

public:
  static Document* GetDocumentByPathName(char* path_name);
  static Document* GetFirstDocument();
#ifndef BW3_FILEDLG
  static FileOpenDialog* GetFileOpenDialog();
#endif /* BW3_FILEDLG */
#ifdef BW3_FILEDLG
  static int FileOpenDlg(char* filename, char* filter_str, bool insert_file=False);
#else /* BW3_FILEDLG */
  static int FileOpenDlg(char* filename, bool insert_file=False);
#endif /* BW3_FILEDLG */
  static int GetLobotomized();
  static int QueryEndSession(int local, int confirm);
#ifdef BW3_DISPATCH
  static LRESULT_T Dispatch(bool menu_state_p, WORD command);
#else /* BW3_DISPATCH */
  static long Dispatch(int command, int menu_state_p);
#endif /* BW3_DISPATCH */
  static void CheckWindowCount();
  static void DelayFormat();
  static void GotoMark(int);
  static void MemoryEmergency();
  static void NewPrinter();
  static void RedisplayHidden();
  static void RemoveDocument(Document* d);
  static void RevertDocument(Document* d);
  static void StyleChange(uword style);
  static void Terminate();
  static void control_scroll_bar();
  static void init(HINSTANCE hInstance, HINSTANCE hPrevInstance, char* lpszCmdLine, int nCmdShow);
  static void no_more_memory();
  static void term();
#ifdef BW3_FILEDLG
  static void OpenFile(char* filename);
#endif /* BW3_FILEDLG */
#ifdef BW3_RECENTOPEN
  static void RegisterRecentOpenFileName(char* filename);
  static void MakeUpRecentOpenMenu();
#endif /* BW3_RECENTOPEN */
};

inline Document* 
PWordBase::GetFirstDocument()
{
  return(PWordBase::first_document);
}

#ifndef BW3_FILEDLG
inline FileOpenDialog* 
PWordBase::GetFileOpenDialog()
{
  return(PWordBase::file_open_dialog);
}
#endif /* BW3_FILEDLG */

inline int
PWordBase::GetLobotomized()
{
  return(PWordBase::lobotomized);
}

#endif /* PWORDBAS_H */
