// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pwordpre.cpp,v 3.4 1999/05/18 18:03:09 kudou Exp $
// implementation of PWordPresentation class

#include "pword.h"
#include <drivinit.h>
#include <time.h>
#include "pwordpre.h"
#include "again.h"
#include "ansidlg.h"
#include "atts.h"
#include "autosave.h"
#include "boxes.h"
#include "dlg.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "editfram.h"
#include "fileutil.h"
#include "fonts.h"
#include "mcursor.h"
#include "mdiclien.h"
#include "menu.h"
#include "messbox.h"
#include "mwindow.h"
#include "pagebox.h"
#include "pime.h"
#include "pmenus.h"
#include "pref.h"
#include "printeri.h"
#include "pwordbas.h"
#include "screen.h"
#include "searchdl.h"
#include "view.h"
#include "vttime.h"
#include "xstr.h"

AnsiDialog* PWordPresentation::ansi_dialog = NULL;
EditMode PWordPresentation::edit_mode_status = InputText_MODE;
#ifdef _WIN32
HHOOK PWordPresentation::old_hook_handle = 0;
#else /* _WIN32 */
FARPROC PWordPresentation::old_hook_proc = NULL;
#endif /* _WIN32 */
HINSTANCE PWordPresentation::hInstance = 0;
HINSTANCE PWordPresentation::hPrevInstance = 0;
MessBox* PWordPresentation::messbox = NULL;
PageBox* PWordPresentation::pagebox = NULL;
Preferences* PWordPresentation::preferences = NULL;
SearchDialog* PWordPresentation::search_dialog = NULL;
VTTimeDialog* PWordPresentation::vttime_dialog = NULL;
int PWordPresentation::display_flags = 0;
int PWordPresentation::error = 0;
int PWordPresentation::event_loop_started_p = False;
int PWordPresentation::nCmdShow = 0;

int
PWordPresentation::Init()
{
  if (!hPrevInstance)
  {
    Register();
  }
  
  if (CheckExpiration())
  {
    error = 1;
    return 0;
  }
  
  Default_View->SetDC(Screen::dc);
  
  main_window = new MainWindow();
  main_window_handle = main_window->GetHandle();
  
  // create dialog boxes
  {
    ansi_dialog = new AnsiDialog;
    search_dialog = new SearchDialog;
    vttime_dialog = new VTTimeDialog;
    pagebox = new PageBox;
    pagebox->Go();
  }
  
  Boxes::init();
  Pref::read_profile();
  Menu::control_shortcuts();
  if (Pref_system_ime_font)
  {
    PIME::SetIgnoreFont(1);
  }
  main_window->Show(Pref_maximized_main_window ? SW_SHOWMAXIMIZED
		     : SW_SHOWNORMAL);
  main_window->Update();
  GlobalAttsTable.SetDefaultSize(Pref_default_font_size);
  if (Pref_document_directory != NULL && Pref_document_directory[0] != '\0')
  {
    FileUtil::ChDir(Pref_document_directory);
  }
  // the polarity of the check below is correct.
  // it's the name of the routine "soft_japanese_spaces" that is backwards.
  if (!Pref_soft_zenkaku_space)
  {
    void soft_japanese_spaces();
    soft_japanese_spaces();
  }
  
  NewPrinter();
  if (GlobalFontTable.GetNEntries() == 0)
  {
    Issue(S_CantFindAnyFonts, MB_ICONSTOP | MB_OK);
    return 0;
  }
  
  messbox = new MessBox();
  return(1);
}

void
PWordPresentation::term()
{
  if (!error)
  {
    Pref::write_profile();
    Boxes::term();
    delete ansi_dialog;
    delete search_dialog;
    delete vttime_dialog;
    delete messbox;
    delete pagebox;
    MainWindow* mw = main_window;
    main_window = NULL;
    main_window_handle = 0;
    delete mw;
  }
}

void
PWordPresentation::Register()
{
  MainWindow		::Register();
  DocumentWindow	::Register();
  MessBox		::Register();
}

// EditMode management

// This structure must be synchronized to enum EditMode.
static struct EditModeInfo
{
  int command_to_change;
  PageBox::PBMode page_box_mode;
} edit_mode_info[] =
{
  { 0,				PageBox::PBM_PL, },
  { IDM_Edit_InputText_MODE,	PageBox::PBM_PL, },
  { IDM_Edit_SelectFrame_MODE,	PageBox::PBM_HW, },
  { IDM_Edit_FrameMargin_MODE,	PageBox::PBM_MP, },
  { IDM_Edit_SetMargin_MODE,	PageBox::PBM_MP, },
  { IDM_Edit_MakeTable_MODE,	PageBox::PBM_HW, },
  { IDM_Edit_MoveLine_MODE,	PageBox::PBM_MP, },
  { IDM_Edit_DrawLine_MODE,	PageBox::PBM_MP, },
  { IDM_Edit_Cut_MODE,		PageBox::PBM_PL, },
  { IDM_Edit_SetFlow_MODE,	PageBox::PBM_PL, },
  { IDM_Edit_ExchFlow_MODE,	PageBox::PBM_PL, },
};

int
PWordPresentation::GetEditModeCommand()
{
  return(edit_mode_info[edit_mode_status].command_to_change);
}

// public method
void
PWordPresentation::redraw_all_windows()
{
  for (Document* doc = PWordBase::GetFirstDocument();
       doc != NULL; doc = doc->GetNextDocument())
  {
    doc->GetDocumentPresentation() ->RedrawWindows();
  }
}

// private method
void NEAR
PWordPresentation::control_display()
{
  int flags = 0;
  if (Pref_display_frame_line)
  {
    flags |= DISPLAY_FRAME_LINE;
  }
  if (Pref_display_frame_margin)
  {
    flags |= DISPLAY_FRAME_MARGIN;
  }
  if (Pref_display_para_margin)
  {
    flags |= DISPLAY_PARA_MARGIN;
  }
  if (Pref_display_flow_line)
  {
    flags |= DISPLAY_FLOW_LINE;
  }
  if (Pref_display_auto_lines)
  {
    switch (PWordPresentation::edit_mode_status)
    {
     case SelectFrame_MODE:
     case MoveLine_MODE:
      flags |= DISPLAY_FRAME_LINE;
      break;
      
     case DrawLine_MODE:
     case Cut_MODE:
     case SetFlow_MODE:
     case ExchFlow_MODE:
      flags |= (DISPLAY_FRAME_LINE | DISPLAY_FLOW_LINE);
      break;
      
     case FrameMargin_MODE:
      flags |= DISPLAY_FRAME_MARGIN;
      break;
      
     case SetMargin_MODE:
      flags |= DISPLAY_PARA_MARGIN;
      break;
    }
  }
  
  if (PWordPresentation::display_flags != flags)
  {
    PWordPresentation::display_flags = flags;
    PWordPresentation::redraw_all_windows();
  }
}

// This method is called from MainWindow::Dispatch() only.
// public method
long
PWordPresentation::handle_display(int menu_state_p, int* pref_ptr)
{
  int value = *pref_ptr;
  if (menu_state_p)
  {
    return(value != 0 ? (MF_CHECKED | MF_ENABLED) : MF_ENABLED);
  }
  *pref_ptr = !value;
  PWordPresentation::control_display();
  return(0);
}

// force set edit mode
// don't call next functin from other class, use ChangeEditMode.
// private method
void NEAR
PWordPresentation::SetEditMode(EditMode mode, int do_message)
{
  if (VALID_EDIT_MODE_P(mode))
  {
    // Update page-box at first
    {
      PageBox::PBMode new_page_box_mode = edit_mode_info[mode].page_box_mode;
      PageBox* pb = PWordPresentation::GetPageBox();
      if (pb->GetMode() != new_page_box_mode)
      {
	pb->SetMode(new_page_box_mode);
	if (new_page_box_mode == PageBox::PBM_PL)
	{
	  pb->Update();
	}
      }
    }
    
    // set global variable at this timing.
    PWordPresentation::edit_mode_status = mode;
    
    // set new mode to all EditFrame
    {
      for (Document* doc = PWordBase::GetFirstDocument();
	   doc != NULL; doc = doc->GetNextDocument())
      {
	doc->GetEditFrame() ->ReceiveChangeToolBoxItem(mode);
      }
    }
    
    // Show message.
    if (do_message)
    {
      PWordPresentation::StatusOut
      (command_by_idm(edit_mode_info[mode].command_to_change) ->guide);
    }
    Boxes::update();
  }
  
  PWordPresentation::control_display();
}

void
PWordPresentation::ChangeEditMode(EditMode mode)
{
  if (mode != edit_mode_status)
  {
    SetEditMode(mode, True);
  }
  if (Selected_Window != 0)
  {
    Selected_Window
    ->GetPresentation()
    ->GetDocument()
    ->GetEditFrame()
    ->ChangeEditMode(mode);
  }
}

long
PWordPresentation::HandleEditMode(int command, int menu_state_p)
{
  int mode = edit_mode_status;
  switch (command)
  {
   case IDM_Edit_Mode_Inc:
    ++mode;
    if (!VALID_EDIT_MODE_P(mode))
    {
      mode = EditMode_FIRST;
    }
    break;
    
   case IDM_Edit_Mode_Dec:
    --mode;
    if (!VALID_EDIT_MODE_P(mode))
    {
      mode = EditMode_LAST;
    }
    break;
    
   default:
    if (!menu_state_p)
    {
      Again::CantDoAgain();
    }
    for (mode = 1; mode < NUMBER_OF(edit_mode_info); ++mode)
    {
      if (command == edit_mode_info[mode].command_to_change)
      {
	break;
      }
    }
    break;
  }
  if (menu_state_p)
  {
    return(mode == edit_mode_status ? (MF_CHECKED | MF_ENABLED) : MF_ENABLED);
  }
  ChangeEditMode((EditMode) mode);
  return(0);
}

// Dispatch -- dispatch menu messages
// All menu-state are enabled.  MainWindiw::Dispatch handling menu-state.
long
PWordPresentation::Dispatch(int command)
{
  switch (command)
  {
   case IDM_Help_About:
    AboutDialog::About(PWordPresentation::ControlKey() ? SPECIAL_ABOUT : NORMAL_ABOUT);
    break;

   case IDM_Help_DevInfo:
    AboutDialog::About(SPECIAL_ABOUT);
    break;
    
   case IDM_Edit_VText_Time:
    vttime_dialog->Go();
    break;
    
   case IDM_Edit_Ansi:
    ansi_dialog->Go();
    break;
    
   case IDM_Location_Search:
    search_dialog->Go();
    break;
    
   case IDM_File_Preferences:
    Pref::custom();
    break;
    
#ifndef NDEBUG
#ifdef BW2_VERBOSE
   default:
    syserr("Unknown command 0x%x in PWordPres dispatch", command);
#endif
#endif
  }
  return(0);
}

// show status message
void
PWordPresentation::StatusOut(char* str)
{
  Boxes::status_out(str, False);
}

void
PWordPresentation::StatusOutPermanent(char* str)
{
  Boxes::status_out(str, True);
}

// get modifier key status

static int NEAR
get_key_state(int key)
{
  return(!Again::GetDoingAgain()
	  && (GetKeyState(key) & 0x8000) != 0);
}

// static method
int
PWordPresentation::ShiftKey()
{
  return(get_key_state(VK_SHIFT));
}

// static method
int
PWordPresentation::ControlKey()
{
  return(get_key_state(VK_CONTROL));
}

void
PWordPresentation::Terminate()
{
  main_window->Terminate();
  PostQuitMessage(0) ;
}

void
PWordPresentation::Update()
{
  Boxes::update();
  if (pagebox)
  {
    pagebox->Update();
  }
}

int
PWordPresentation::IsToolBox(HWND hWnd)
{
  return(hWnd != 0
	  && ((pagebox != NULL && hWnd == pagebox->GetHandle())
	      || (ansi_dialog != NULL && hWnd == ansi_dialog->GetHandle())
	      || (search_dialog != NULL && hWnd == search_dialog->GetHandle())
	      || (vttime_dialog != NULL && hWnd == vttime_dialog->GetHandle())
	      || Boxes::boxes_window_p(hWnd)));
}

// simple printer DC management

static HDC printer_dc = 0;

HDC
PWordPresentation::MakePrinterDC()
{
  //  assert(printer_dc == 0);
  printer_dc = Printer_Info->CreateIC();
  return(printer_dc ? printer_dc : Screen::dc);
}

void
PWordPresentation::KillPrinterDC()
{
  if (printer_dc)
  {
    ::DeleteDC(printer_dc);
    printer_dc = 0;
  }
}

// PWordPresentation::NewPrinter -- handle new printer installation
// This is called at initialization and from the MainWindow wndproc.
// Have to reset the printer info-environment.

void
PWordPresentation::NewPrinter()
{
  MouseCursor::StartLongActivity();
  Printer_View->ResetDC();
  PWordPresentation::KillPrinterDC();
  Printer_View->SetDC(PWordPresentation::MakePrinterDC());
  Printer_View->SetDeviceType(PRINTER);
  PWordBase::NewPrinter();
  MouseCursor::EndLongActivity();
}

// returns True if more formatting is needed
static bool
FormatOneStep()
{
  bool result = False;
  for (Document* doc = PWordBase::GetFirstDocument();
       doc != NULL; doc = doc->GetNextDocument())
  {
    result = (doc->GetDocumentContent())->FormatOneStep();
    DocumentPresentation* pre = doc->GetDocumentPresentation();
    if (pre->GetRequestCaretControl())
    {
      pre->ControlCaret();
    }
    if (result)
    {
      break;
    }
  }
  return(result);
}

LRESULT_T
PWordPresentation::HelpHookProc_(int nCode, WPARAM_T wParam, LPARAM_T lParam)
{
  bool processed = False;
  
  if (nCode < 0)
  {
#ifdef _WIN32
    return (int)::CallNextHookEx(PWordPresentation::old_hook_handle,
                                 nCode, wParam, lParam);
#else /* _WIN32 */
    return(int)::DefHookProc(nCode, wParam, lParam, 
			     &PWordPresentation::old_hook_proc);
#endif /* _WIN32 */
  }
  switch (nCode)
  {
   case MSGF_DIALOGBOX:
    {
      MSG* msg = (MSG*)lParam;
      switch (msg->message)
      {
       case WM_KEYDOWN:
	switch (msg->wParam)
	{
	 case VK_F1:
	  main_window->SendMessage(WM_COMMAND, IDM_Help_Index);
	  processed = True;
	  break;
	}
	break;
      }
      
    }
   case MSGF_MENU:
    break;
   default:
    break;
  }
  return processed;
}

// to "Go" on the PWordPresentation means to run the
// Windows event loop
int
PWordPresentation::Go()
{
  MSG msg;
  
  if (error)  // error in setup
  {
    return 0;
  }
  
  if (Pref_startup_about)
  {
    // tell the user he's about to use "pWord"
    AboutDialog::About(TIMER_ABOUT);
  }
  
  SetEditMode(InputText_MODE, False);
  
  if (Pref_start_ime)
  {
    PIME::SetOpen();
  }
  
  // Restart the autosave stuff after we have some windows.
  AutoSaveDialog::Restart();
#ifdef _WIN32
  old_hook_handle = ::SetWindowsHookEx(WH_MSGFILTER, 
				       (HOOKPROC)PWordPresentation::HelpHookProc,
				       PWordPresentation::hInstance,
				       0);
#else /* _WIN32 */
  old_hook_proc = ::SetWindowsHook(WH_MSGFILTER, 
				   (FARPROC)PWordPresentation::HelpHookProc);
#endif /* _WIN32 */
  Menu::init();
  PWordPresentation::event_loop_started_p = True;
  for (;;)
  {
#ifndef NDEBUG
#ifndef _WIN32
    (void) ::ValidateFreeSpaces();
    // to make this work, you have to be using the debugging kernel, plus
    // have these two lines in win.ini:
    // [kernel]
    // EnableFreeChecking=1
    // EnableHeapChecking=1
#endif
#endif
    
    while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
      if (search_dialog->GetHandle()
	  && ::IsDialogMessage(search_dialog->GetHandle(), &msg))
      {
      }
      else if (vttime_dialog->GetHandle()
	       && ::IsDialogMessage(vttime_dialog->GetHandle(), &msg))
      {
      }
      else if (pagebox->GetHandle()
	       && ::IsDialogMessage(pagebox->GetHandle(), &msg))
      {
      }
      else if (::TranslateMDISysAccel((MainWindow::GetMDIClient()
					->GetHandle()),
				       &msg))
      {
      }
      else if (::TranslateAccelerator(main_window_handle,
				      (HACCEL)MainWindow::GetAccel(), &msg))
      {
      }
      else
      {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
      }
      if (msg.message == WM_QUIT)
      {
	return(msg.wParam);
      }
    }
    if (!::FormatOneStep())
    {
#ifndef NDEBUG
      {
	void check_all_memory(); // see new.cpp
	check_all_memory();
      }
#endif
      
      // autosaving
      if (AutoSaveDialog::GetAutoSave() && 
	  (Selected_Window != NULL) && 
	  (!Selected_Window->mouse.activep))
      {
	AutoSaveDialog::Do();  
      }
      
      WaitMessage();
    }
  }
}

void
PWordPresentation::EnableModeless(bool onoff)
{
  if (ansi_dialog && ansi_dialog->GetHandle())
  {
    ansi_dialog->Enable(onoff);
  }
  if (search_dialog && search_dialog->GetHandle())
  {
    search_dialog->Enable(onoff);
  }
  if (vttime_dialog && vttime_dialog->GetHandle())
  {
    vttime_dialog->Enable(onoff);
  }
  if (pagebox && pagebox->GetHandle())
  {
    pagebox->Enable(onoff);
  }
  Boxes::enable_modeless(onoff);
}

// check expiration date.  Based on two pre-processor variables,
// EXPIRE_YEAR and EXPIRE_MONTH.  returns True if expired.

bool
PWordPresentation::CheckExpiration()
{
#ifndef EXPIRE_YEAR
  return False;
#else
  time_t timer;
  time(&timer);
  struct tm* info = localtime(&timer);
  
  if ((info->tm_year > EXPIRE_YEAR) ||
      ((info->tm_year == EXPIRE_YEAR) && ((info->tm_mon+1) > EXPIRE_MONTH)))
  {
    Issue(S_ExpiredMsg, MB_OK | MB_ICONEXCLAMATION);
    return True;
  }
  else
  {
    return False;
  }
#endif
}
