// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pwordpre.h,v 3.3 1999/05/18 18:03:09 kudou Exp $
// define the PWordPresentation class
// This class maintains the global pWord information
// related to the Windows interface.

#ifndef PWORDPRE_H
#define PWORDPRE_H

// All slots and methods of this class are declared STATIC.
// Keep this rule for best performance.  (konno)

// Mask value of display control flag.
#define DISPLAY_FRAME_LINE	(1 << 0)
#define DISPLAY_FRAME_MARGIN	(1 << 1)
#define DISPLAY_PARA_MARGIN	(1 << 2)
#define DISPLAY_FLOW_LINE	(1 << 3)

class AnsiDialog;
class SearchDialog;
class VTTimeDialog;

// this is here, rather than with all the other external variables
// in pword.h, cuz otherwise everybody'd hafta include windows.h

extern UINT Clipboard_Format;

class PWordPresentation
{
private:
  static AnsiDialog* PWordPresentation::ansi_dialog;
  static EditMode PWordPresentation::edit_mode_status;
#ifdef _WIN32
  static HHOOK PWordPresentation::old_hook_handle;
#else /* _WIN32 */
  static FARPROC PWordPresentation::old_hook_proc;
#endif /* _WIN32 */
  static MessBox* PWordPresentation::messbox;
  static PageBox* PWordPresentation::pagebox;
  static Preferences* PWordPresentation::preferences;
  static SearchDialog* PWordPresentation::search_dialog;
  static VTTimeDialog* PWordPresentation::vttime_dialog;
  static int PWordPresentation::error;
  static int PWordPresentation::display_flags;
public:
  static HINSTANCE PWordPresentation::hInstance;
  static HINSTANCE PWordPresentation::hPrevInstance;
  static int PWordPresentation::event_loop_started_p;
  static int PWordPresentation::nCmdShow;
  
  // exported function
public:
  static LRESULT_T FAR PASCAL _export PWordPresentation::HelpHookProc(int nCode, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T PWordPresentation::HelpHookProc_ (int nCode, WPARAM_T wParam, LPARAM_T lParam);

  // all methods are STATIC
private:
  static void NEAR PWordPresentation::control_display();
  static void NEAR PWordPresentation::SetEditMode(EditMode mode, int do_message);
public:
  static AnsiDialog* PWordPresentation::GetAnsiDialog();
  static EditMode PWordPresentation::GetEditModeStatus();
  static HDC PWordPresentation::MakePrinterDC();
  static MessBox* PWordPresentation::GetMessBox();
  static PageBox* PWordPresentation::GetPageBox();
  static SearchDialog* PWordPresentation::GetSearchDialog();
  static bool PWordPresentation::CheckExpiration();
  static int PWordPresentation::ControlKey();
  static int PWordPresentation::GetEditModeCommand();
  static int PWordPresentation::Go();
  static int PWordPresentation::Init();
  static int PWordPresentation::IsToolBox(HWND);
  static int PWordPresentation::ShiftKey();
  static int PWordPresentation::display_flow_line_p();
  static int PWordPresentation::display_frame_line_p();
  static int PWordPresentation::display_frame_margin_p();
  static int PWordPresentation::display_para_margin_p();
  static long PWordPresentation::Dispatch(int command);
  static long PWordPresentation::HandleEditMode(int command, int menu_state_p);
  static long PWordPresentation::handle_display(int menu_state_p, int* pref_ptr);
  static void PWordPresentation::ChangeEditMode(EditMode mode);
  static void PWordPresentation::EnableModeless(bool);
  static void PWordPresentation::KillPrinterDC();
  static void PWordPresentation::NewPrinter();
  static void PWordPresentation::Register();
  static void PWordPresentation::StatusOut(char*);
  static void PWordPresentation::StatusOutPermanent(char*);
  static void PWordPresentation::Terminate();
  static void PWordPresentation::Update();
  static void PWordPresentation::redraw_all_windows();
  static void PWordPresentation::term();
};

inline AnsiDialog* 
PWordPresentation::GetAnsiDialog()
{
  return(PWordPresentation::ansi_dialog);
}

inline SearchDialog* 
PWordPresentation::GetSearchDialog()
{
  return(PWordPresentation::search_dialog);
}

inline MessBox* 
PWordPresentation::GetMessBox()
{
  return(PWordPresentation::messbox);
}

inline PageBox* 
PWordPresentation::GetPageBox()
{
  return(PWordPresentation::pagebox);
}

// get edit mode status
inline EditMode
PWordPresentation::GetEditModeStatus()
{
  return(PWordPresentation::edit_mode_status);
}

// Returns non-zero, if frame line redisplay is needed.
inline int
PWordPresentation::display_frame_line_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FRAME_LINE);
}

// Returns non-zero, if frame margin redisplay is needed.
inline int
PWordPresentation::display_frame_margin_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FRAME_MARGIN);
}

// Returns non-zero, if paragraph margin redisplay is needed.
inline int
PWordPresentation::display_para_margin_p()
{
  return(PWordPresentation::display_flags & DISPLAY_PARA_MARGIN);
}

// Returns non-zero, if flow line redisplay is needed.
inline int
PWordPresentation::display_flow_line_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FLOW_LINE);
}

#endif /* PWORDPRE_H */
