// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: rect.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// rect

#include "pword.h"
#include "rect.h"

// This function returns TRUE if point P is placed inside R.
int
lrect_insidep(Lrect* r, Lpoint* p)
{
  return(RECT_TOP_X(r) <= POINT_X(p)
	  && POINT_X(p) < RECT_BOT_X(r)
	  && RECT_TOP_Y(r) <= POINT_Y(p) && POINT_Y(p) < RECT_BOT_Y(r));
}

// Thisfunction TRUE if two rectangles R0, R1 are intersected.
int
lrect_intersectp(Lrect* r0, Lrect* r1)
{
  return(RECT_TOP_X(r0) < RECT_BOT_X(r1)
	  && RECT_TOP_Y(r0) < RECT_BOT_Y(r1)
	  && RECT_TOP_X(r1) < RECT_BOT_X(r0)
	  && RECT_TOP_Y(r1) < RECT_BOT_Y(r0));
}

// This function returns TRUE if rectangle R0 include rectangle R1.
int
lrect_includep(Lrect* r0, Lrect* r1)
{
  return(RECT_TOP_X(r0) <= RECT_TOP_X(r1)
	  && RECT_TOP_Y(r0) <= RECT_TOP_Y(r1)
	  && RECT_BOT_X(r1) <= RECT_BOT_X(r0)
	  && RECT_BOT_Y(r1) <= RECT_BOT_Y(r0));
}

// This function expands TARGET to include original TARGET and SRC
// rectangles.
void
lrect_or(Lrect* target, Lrect* src)
{
  SET_MIN(RECT_TOP_X(target), RECT_TOP_X(src));
  SET_MIN(RECT_TOP_Y(target), RECT_TOP_Y(src));
  SET_MAX(RECT_BOT_X(target), RECT_BOT_X(src));
  SET_MAX(RECT_BOT_Y(target), RECT_BOT_Y(src));
}

// This function calcunates "TARGET = TARGET & SRC", and returns FALSE if
// result is empty rectangle.
int
lrect_and(Lrect* target, Lrect* src)
{
  SET_MAX(RECT_TOP_X(target), RECT_TOP_X(src));
  SET_MAX(RECT_TOP_Y(target), RECT_TOP_Y(src));
  SET_MIN(RECT_BOT_X(target), RECT_BOT_X(src));
  SET_MIN(RECT_BOT_Y(target), RECT_BOT_Y(src));
  if (RECT_BOT_X(target) <= RECT_TOP_X(target)
      || RECT_BOT_Y(target) <= RECT_TOP_Y(target))
  {
    RECT_BOT_X(target) = RECT_TOP_X(target);
    RECT_BOT_Y(target) = RECT_TOP_Y(target);
    return(False);
  }
  return(True);
}

// This function returns TRUE if point P is placed inside R.
int
irect_insidep(Irect* r, Ipoint* p)
{
  return(RECT_TOP_X(r) <= POINT_X(p)
	  && POINT_X(p) < RECT_BOT_X(r)
	  && RECT_TOP_Y(r) <= POINT_Y(p) && POINT_Y(p) < RECT_BOT_Y(r));
}

// Thisfunction TRUE if two rectangles R0, R1 are intersected.
int
irect_intersectp(Irect* r0, Irect* r1)
{
  return(RECT_TOP_X(r0) < RECT_BOT_X(r1)
	  && RECT_TOP_Y(r0) < RECT_BOT_Y(r1)
	  && RECT_TOP_X(r1) < RECT_BOT_X(r0)
	  && RECT_TOP_Y(r1) < RECT_BOT_Y(r0));
}

// This function calcunates "TARGET = TARGET & SRC", and returns FALSE if
// result is empty rectangle.
int
irect_and(Irect* target, Irect* src)
{
  SET_MAX(RECT_TOP_X(target), RECT_TOP_X(src));
  SET_MAX(RECT_TOP_Y(target), RECT_TOP_Y(src));
  SET_MIN(RECT_BOT_X(target), RECT_BOT_X(src));
  SET_MIN(RECT_BOT_Y(target), RECT_BOT_Y(src));
  if (RECT_BOT_X(target) <= RECT_TOP_X(target)
      || RECT_BOT_Y(target) <= RECT_TOP_Y(target))
  {
    RECT_BOT_X(target) = RECT_TOP_X(target);
    RECT_BOT_Y(target) = RECT_TOP_Y(target);
    return(False);
  }
  return(True);
}
