// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: rect.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// Rect, Vector		for Iunit coordinate
// RectW, VectW		for window coordinate
// RectL, VectL		for document coordinate
// rect and vector descriptions

#ifndef RECT_H
#define RECT_H

// class name definition
#undef name2
#define name2(a, b) a ## b
#define GVect(T) name2(GVect, T)
#define GRect(T) name2(GRect, T)

#define GVectRectDeclare(T)						\
struct GVect(T)								\
{									\
   T x;									\
   T y;									\
   									\
   GVect(T)(T x = 0, T y = 0) { GVect(T)::x = x; GVect(T)::y = y; }	\
   void Set(T x = 0, T y = 0) { GVect(T)::x = x; GVect(T)::y = y; }	\
   void operator += (GVect(T)& v) { x += v.x, y += v.y; }		\
   void operator -= (GVect(T)& v) { x -= v.x, y -= v.y; }		\
   bool operator == (GVect(T)& v) { 					\
      return(x == v.x && y == v.y);					\
   }									\
   bool operator != (GVect(T)& v) {					\
      return(x != v.x) || (y != v.y);					\
   }									\
};									\
									\
struct GRect(T)								\
{									\
   T x1, y1;	/* left up position */					\
   T x2, y2;	/* right down position */				\
   									\
   GRect(T)(T x1 = 0, T y1 = 0, T x2 = 0, T y2 = 0) {			\
      GRect(T)::x1 = x1, GRect(T)::y1 = y1;				\
      GRect(T)::x2 = x2, GRect(T)::y2 = y2;				\
   }									\
   GRect(T)(GVect(T)& pos, GVect(T)& size) {				\
      x1 = pos.x, y1 = pos.y;						\
      x2 = pos.x + size.x - 1, y2 = pos.y + size.y - 1;			\
   }									\
   void Set(T x1 = 0, T y1 = 0, T x2 = 0, T y2 = 0) {			\
      GRect(T)::x1 = x1, GRect(T)::y1 = y1;				\
      GRect(T)::x2 = x2, GRect(T)::y2 = y2;				\
   }									\
   void Set(GVect(T)& pos, GVect(T)& size) {				\
      x1 = pos.x, y1 = pos.y;						\
      x2 = pos.x + size.x - 1, y2 = pos.y + size.y - 1;			\
   }									\
   GVect(T)& GetPos() { return *((GVect(T)*)this); }			\
   GVect(T) GetSize() { return GVect(T)(x2 - x1 + 1, y2 - y1 + 1); }	\
   T GetXSize() { return x2 - x1 + 1; }					\
   T GetYSize() { return y2 - y1 + 1; }					\
   void operator += (GVect(T)& v) {					\
      x1 += v.x, y1 += v.y, x2 += v.x, y2 += v.y;			\
   }									\
   void operator -= (GVect(T)& v) {					\
      x1 -= v.x, y1 -= v.y, x2 -= v.x, y2 -= v.y;			\
   }									\
   bool IsInThisRect(GVect(T)& v) {					\
      return !(v.x < x1 || x2 < v.x || v.y < y1 || y2 < v.y);		\
   }									\
   bool IsInternalPos(GVect(T)& v) {					\
      return !(v.x <= x1 || x2 <= v.x || v.y <= y1 || y2 <= v.y);	\
   }									\
   bool IntersectP(GRect(T)& rec) {					\
      return(x1 <= rec.x2) && (x2 >= rec.x1) && 			\
             (y1 <= rec.y2) && (y2 >= rec.y1);				\
   }									\
};									\

// Iunit vector and rect
GVectRectDeclare(Iunit)
#define Vector GVect(Iunit)
#define Rect GRect(Iunit)
#define VECTOR_RECT_DEFINED

// window vector and rect
// Dunit and Iunit have same representations now.
#define VectW Vector
#define RectW Rect
#define VECTW_RECTW_DEFINED

// document vector and rect
GVectRectDeclare(Lunit)
#define VectL GVect(Lunit)
#define RectL GRect(Lunit)
#define VECTL_RECTL_DEFIND

#ifdef _WIN32
// for to handle old BeatWord file.
GVectRectDeclare(Bw2_Iunit)
#define Bw2_Vector GVect(Bw2_Iunit)
#define Bw2_Rect GRect(Bw2_Iunit)

inline void Bw2_Vector_to_Vector(Bw2_Vector& b2v, Vector& v)
{
  v.Set((Iunit)b2v.x, (Iunit)b2v.y);
}

inline void Vector_to_Bw2_Vector(Vector& v, Bw2_Vector& b2v)
{
  b2v.Set((Bw2_Iunit)v.x, (Bw2_Iunit)v.y);
}

inline void Bw2_Rect_to_Rect(Bw2_Rect& b2r, Rect& r)
{
  r.Set((Iunit)b2r.x1, (Iunit)b2r.y1, (Iunit)b2r.x2, (Iunit)b2r.y2);
}

inline void Rect_to_Bw2_Rect(Rect& r, Bw2_Rect& b2r)
{
  b2r.Set((Bw2_Iunit)r.x1, (Bw2_Iunit)r.y1, (Bw2_Iunit)r.x2, (Bw2_Iunit)r.y2);
}

//GVectRectDeclare(Bw2_Lunit)
//#define Bw2_VectL GVect(Bw2_Lunit)
//#define Bw2_RectL GRect(Bw2_Lunit)
#endif /* _WIN32 */


// ------------------------------------------------------------
// New design of point and rectangle structures.

// Define 3 point structures: Dpoint, Ipoint, and Lpoint.
#define DEFINE_POINT_STRUCT(name, type) \
struct name \
{ \
  /* units[INDEX_X] and units[INDEX_Y] */ \
  type units[2]; \
};
DEFINE_POINT_STRUCT(Dpoint, Dunit)
DEFINE_POINT_STRUCT(Ipoint, Iunit)
DEFINE_POINT_STRUCT(Lpoint, Lunit)
#undef DEFINE_POINT_STRUCT

// accessors
#define POINT_UNIT(p, index) ((p)->units[index])
#define POINT_X(p) POINT_UNIT(p, INDEX_X)
#define POINT_Y(p) POINT_UNIT(p, INDEX_Y)

#define SET_POINT(p, x, y) \
do \
{ \
  POINT_X(p) = (x); \
  POINT_Y(p) = (y); \
} while (0)

// Define 3 rectangle structures: Drect, Irect, and Lrect.
#define DEFINE_RECT_STRUCT(name, type) \
struct name \
{ \
  /* points[INDEX_TOP] and points[INDEX_BOT] */ \
  type points[2]; \
};
DEFINE_RECT_STRUCT(Drect, Dpoint)
DEFINE_RECT_STRUCT(Irect, Ipoint)
DEFINE_RECT_STRUCT(Lrect, Lpoint)
#undef DEFINE_RECT_STRUCT

// accessors
#define RECT_POINT(r, index) (&(r)->points[index])
#define RECT_TOP(r) RECT_POINT(r, INDEX_TOP)
#define RECT_BOT(r) RECT_POINT(r, INDEX_BOT)
#define RECT_TOP_X(r) POINT_X(RECT_TOP(r))
#define RECT_TOP_Y(r) POINT_Y(RECT_TOP(r))
#define RECT_BOT_X(r) POINT_X(RECT_BOT(r))
#define RECT_BOT_Y(r) POINT_Y(RECT_BOT(r))

#define RECT_UNIT(r, index_topbot, index_xy) \
POINT_UNIT(RECT_POINT(r, index_topbot), index_xy)

#define SET_RECT(r, top_x, top_y, bot_x, bot_y) \
do \
{ \
  SET_POINT(RECT_TOP(r), top_x, top_y); \
  SET_POINT(RECT_BOT(r), bot_x, bot_y); \
} while (0)

// True if rectangle is a empty.
#define RECT_IS_EMPTY_P(r) \
(RECT_BOT_X(r) <= RECT_TOP_X(r) || RECT_BOT_Y(r) <= RECT_TOP_Y(r))

int drect_and(Irect* target, Irect* src);
int drect_insidep(Drect* r, Dpoint* p);
int drect_intersectp(Drect* r0, Drect* r1);
int irect_and(Irect* target, Irect* src);
int irect_insidep(Irect* r, Ipoint* p);
int irect_intersectp(Irect* r0, Irect* r1);
int lrect_and(Lrect* target, Lrect* src);
int lrect_includep(Lrect* r0, Lrect* r1);
int lrect_insidep(Lrect* r, Lpoint* p);
int lrect_intersectp(Lrect* r0, Lrect* r1);
void lrect_or(Lrect* target, Lrect* src);

inline int
drect_and(Drect* r0, Drect* r1)
{
  return(irect_and((Irect*) r0, (Irect*) r1));
}

inline int
drect_insidep(Drect* r, Dpoint* p)
{
  return(irect_insidep((Irect*) r, (Ipoint*) p));
}

inline int
drect_intersectp(Drect* r0, Drect* r1)
{
  return(irect_intersectp((Irect*) r0, (Irect*) r1));
}

// HACK HACK HACK HACK
// Following 2 functions are dangerous code, I design structure Drect to
// have same memory image as Windows RECT.

inline RECT* 
CastDrectToWindowsRECT(Drect* r)
{
  return((RECT*) r);
}

inline Drect* 
CastWindowsRECTToDrect(RECT* r)
{
  return((Drect*) r);
}

inline POINT* 
CastDpointToWindowsPOINT(Dpoint* p)
{
  return((POINT*) p);
}

#endif /* RECT_H */
