// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: regabb.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the RegAbbDialog class for PWord Register
// Abbreviation dialog box

#include "pword.h"
#ifdef BW2_ABBREV
#include "pmenus.h"
#include "pwordpre.h"
#include "dialogs.h"
#include "abbrevs.h"
#include "xstr.h"
#include "regabb.h"

RegAbbDialog::RegAbbDialog(char* suggestion)
{
  this->class_name = "RegAbbDlg";
  if (!suggestion) 
  {
    name[0] = NULL;
  }
  else
  {
    ::copy_string(name, suggestion, ABBNAMELEN + 1);
  }
}

LRESULT_T
RegAbbDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      this->SendItemMessage(IDD_RegAbbName, EM_LIMITTEXT, ABBNAMELEN);
      this->SetItemText(IDD_RegAbbName, name);
    }
    return 1;

    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
			
   case WM_CLOSE:
    this->End(0);
    return(1);

   case WM_COMMAND:		// OK button
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      if (GlobalAbbrevTable.GetAbbrevByName(name, Selected_Document) == 0
	  || (IssueVA(S_RegAbb_RedefineMsg,
		       MB_ICONQUESTION | MB_OKCANCEL, name)
	      == IDOK))
      {
	this->End(1);
      }
      break;
				
     case IDD_RegAbbName:
      this->GetItemText(IDD_RegAbbName, name, ABBNAMELEN+1);
      ::EnableWindow(GetItem(IDOK), *name);
      break;

     case IDCANCEL:
      this->End(0);
      break;
					
     default:
      break;
    }
		
   default: 
    break;
  }
  return 0;
}
#endif /* BW2_ABBREV */
